/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatTextView;
import com.folioreader.R;

public class UnderlinedTextView
extends AppCompatTextView {
    private Rect mRect;
    private Paint mPaint;
    private int mColor;
    private float mDensity;
    private float mStrokeWidth;

    public UnderlinedTextView(Context context) {
        this(context, null, 0);
    }

    public UnderlinedTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public UnderlinedTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attributeSet, int defStyle) {
        this.mDensity = context.getResources().getDisplayMetrics().density;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.UnderlinedTextView, defStyle, 0);
        this.mStrokeWidth = typedArray.getDimension(R.styleable.UnderlinedTextView_underlineWidth, this.mDensity * 2.0f);
        typedArray.recycle();
        this.mRect = new Rect();
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
    }

    public int getUnderLineColor() {
        return this.mColor;
    }

    public void setUnderLineColor(int mColor) {
        this.mColor = mColor;
        this.mRect = new Rect();
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(mColor);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.postInvalidate();
    }

    public float getUnderlineWidth() {
        return this.mStrokeWidth;
    }

    public void setUnderlineWidth(float mStrokeWidth) {
        this.mStrokeWidth = mStrokeWidth;
        this.postInvalidate();
    }

    protected void onDraw(Canvas canvas) {
        int count = this.getLineCount();
        Layout layout2 = this.getLayout();
        for (int i = 0; i < count; ++i) {
            int baseline = this.getLineBounds(i, this.mRect);
            int firstCharInLine = layout2.getLineStart(i);
            int lastCharInLine = layout2.getLineEnd(i);
            float xStart = layout2.getPrimaryHorizontal(firstCharInLine);
            float xDiff = layout2.getPrimaryHorizontal(firstCharInLine + 1) - xStart;
            float xStop = layout2.getPrimaryHorizontal(lastCharInLine - 1) + xDiff;
            canvas.drawLine(xStart, (float)baseline + this.mStrokeWidth, xStop, (float)baseline + this.mStrokeWidth, this.mPaint);
        }
        super.onDraw(canvas);
    }
}

