/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.widget.ProgressBar;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.folioreader.Config;
import com.folioreader.R;
import com.folioreader.util.AppUtil;
import com.folioreader.util.UiUtil;

public class LoadingView
extends ConstraintLayout {
    private ProgressBar progressBar;
    private int maxVisibleDuration = -1;
    private Handler handler;
    private Runnable hideRunnable = new Runnable(){

        @Override
        public void run() {
            LoadingView.this.hide();
        }
    };
    private static final String LOG_TAG = LoadingView.class.getSimpleName();

    public LoadingView(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public LoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public LoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        LayoutInflater.from((Context)context).inflate(R.layout.view_loading, (ViewGroup)this);
        if (this.isInEditMode()) {
            return;
        }
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.LoadingView, 0, 0);
        this.maxVisibleDuration = typedArray.getInt(R.styleable.LoadingView_maxVisibleDuration, -1);
        this.handler = new Handler();
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.setClickable(true);
        this.setFocusable(true);
        this.updateTheme();
        if (this.getVisibility() == 0) {
            this.show();
        }
    }

    public void updateTheme() {
        Config config = AppUtil.getSavedConfig(this.getContext());
        if (config == null) {
            config = new Config();
        }
        UiUtil.setColorIntToDrawable(config.getCurrentThemeColor(), this.progressBar.getIndeterminateDrawable());
        if (config.isNightMode()) {
            this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.night_background_color));
        } else {
            this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.day_background_color));
        }
    }

    @JavascriptInterface
    public void show() {
        this.handler.removeCallbacks(this.hideRunnable);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                LoadingView.this.setVisibility(0);
            }
        });
        if (this.maxVisibleDuration > -1) {
            this.handler.postDelayed(this.hideRunnable, (long)this.maxVisibleDuration);
        }
    }

    @JavascriptInterface
    public void hide() {
        this.handler.removeCallbacks(this.hideRunnable);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                LoadingView.this.setVisibility(4);
            }
        });
    }

    @JavascriptInterface
    public void visible() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                LoadingView.this.setVisibility(0);
            }
        });
    }

    @JavascriptInterface
    public void invisible() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                LoadingView.this.setVisibility(4);
            }
        });
    }

    public int getMaxVisibleDuration() {
        return this.maxVisibleDuration;
    }

    public void setMaxVisibleDuration(int maxVisibleDuration) {
        this.maxVisibleDuration = maxVisibleDuration;
    }
}

