/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.DialogFragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.folioreader.Config;
import com.folioreader.R;
import com.folioreader.model.dictionary.Dictionary;
import com.folioreader.model.dictionary.Wikipedia;
import com.folioreader.ui.adapter.DictionaryAdapter;
import com.folioreader.ui.base.DictionaryCallBack;
import com.folioreader.ui.base.DictionaryTask;
import com.folioreader.ui.base.WikipediaCallBack;
import com.folioreader.ui.base.WikipediaTask;
import com.folioreader.util.AppUtil;
import com.folioreader.util.UiUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class DictionaryFragment
extends DialogFragment
implements DictionaryCallBack,
WikipediaCallBack {
    private static final String TAG = "DictionaryFragment";
    private String word;
    private MediaPlayer mediaPlayer;
    private RecyclerView dictResults;
    private TextView noNetwork;
    private TextView dictionary;
    private TextView wikipedia;
    private TextView wikiWord;
    private TextView def;
    private ProgressBar progressBar;
    private Button googleSearch;
    private LinearLayout wikiLayout;
    private WebView wikiWebView;
    private DictionaryAdapter mAdapter;
    private ImageView imageViewClose;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(1, 0);
        this.word = this.getArguments().getString("selected_word");
        this.mediaPlayer = new MediaPlayer();
    }

    public void onActivityCreated(Bundle arg0) {
        super.onActivityCreated(arg0);
        this.getDialog().getWindow().getAttributes().windowAnimations = R.style.DialogAnimation;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.layout_dictionary, container);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.noNetwork = (TextView)view.findViewById(R.id.no_network);
        this.progressBar = (ProgressBar)view.findViewById(R.id.progress);
        this.dictResults = (RecyclerView)view.findViewById(R.id.rv_dict_results);
        this.googleSearch = (Button)view.findViewById(R.id.btn_google_search);
        this.dictionary = (TextView)view.findViewById(R.id.btn_dictionary);
        this.wikipedia = (TextView)view.findViewById(R.id.btn_wikipedia);
        this.wikiLayout = (LinearLayout)view.findViewById(R.id.ll_wiki);
        this.wikiWord = (TextView)view.findViewById(R.id.tv_word);
        this.def = (TextView)view.findViewById(R.id.tv_def);
        this.wikiWebView = (WebView)view.findViewById(R.id.wv_wiki);
        this.wikiWebView.getSettings().setLoadsImagesAutomatically(true);
        this.wikiWebView.setWebViewClient(new WebViewClient());
        this.wikiWebView.getSettings().setJavaScriptEnabled(true);
        this.wikiWebView.setScrollBarStyle(0);
        this.dictionary.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DictionaryFragment.this.loadDictionary();
            }
        });
        this.wikipedia.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DictionaryFragment.this.loadWikipedia();
            }
        });
        this.googleSearch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent("android.intent.action.WEB_SEARCH");
                intent.putExtra("query", DictionaryFragment.this.word);
                DictionaryFragment.this.startActivity(intent);
            }
        });
        this.imageViewClose = (ImageView)view.findViewById(R.id.btn_close);
        this.imageViewClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DictionaryFragment.this.dismiss();
            }
        });
        this.dictResults.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.mAdapter = new DictionaryAdapter((Context)this.getActivity(), this);
        this.configureTheme(view);
        this.loadDictionary();
    }

    private void configureTheme(View view) {
        Config config = AppUtil.getSavedConfig(this.getContext());
        assert (config != null);
        assert (this.getContext() != null);
        int themeColor = config.getCurrentThemeColor();
        UiUtil.setColorIntToDrawable(themeColor, this.imageViewClose.getDrawable());
        LinearLayout layoutHeader = (LinearLayout)view.findViewById(R.id.layout_header);
        layoutHeader.setBackgroundDrawable((Drawable)UiUtil.getShapeDrawable(themeColor));
        UiUtil.setColorIntToDrawable(themeColor, this.progressBar.getIndeterminateDrawable());
        UiUtil.setShapeColor((View)this.googleSearch, themeColor);
        if (config.isNightMode()) {
            view.findViewById(R.id.toolbar).setBackgroundColor(-16777216);
            view.findViewById(R.id.contentView).setBackgroundColor(-16777216);
            this.dictionary.setBackgroundDrawable((Drawable)UiUtil.createStateDrawable(themeColor, -16777216));
            this.wikipedia.setBackgroundDrawable((Drawable)UiUtil.createStateDrawable(themeColor, -16777216));
            this.dictionary.setTextColor(UiUtil.getColorList(-16777216, themeColor));
            this.wikipedia.setTextColor(UiUtil.getColorList(-16777216, themeColor));
            int nightTextColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.night_text_color);
            this.wikiWord.setTextColor(nightTextColor);
            this.wikiWord.setBackgroundColor(-16777216);
            this.def.setTextColor(nightTextColor);
            this.def.setBackgroundColor(-16777216);
            this.noNetwork.setTextColor(nightTextColor);
        } else {
            view.findViewById(R.id.contentView).setBackgroundColor(-1);
            this.dictionary.setTextColor(UiUtil.getColorList(-1, themeColor));
            this.wikipedia.setTextColor(UiUtil.getColorList(-1, themeColor));
            this.dictionary.setBackgroundDrawable((Drawable)UiUtil.createStateDrawable(themeColor, -1));
            this.wikipedia.setBackgroundDrawable((Drawable)UiUtil.createStateDrawable(themeColor, -1));
            this.wikiWord.setBackgroundColor(-1);
            this.def.setBackgroundColor(-1);
            this.googleSearch.setTextColor(-1);
        }
    }

    private void loadDictionary() {
        if (this.noNetwork.getVisibility() == 0 || this.googleSearch.getVisibility() == 0) {
            this.noNetwork.setVisibility(8);
            this.googleSearch.setVisibility(8);
        }
        this.wikiWebView.loadUrl("about:blank");
        this.mAdapter.clear();
        this.dictionary.setSelected(true);
        this.wikipedia.setSelected(false);
        this.wikiLayout.setVisibility(8);
        this.dictResults.setVisibility(0);
        DictionaryTask task = new DictionaryTask(this);
        String urlString = null;
        try {
            urlString = "https://api.pearson.com/v2/dictionaries/entries?headword=" + URLEncoder.encode(this.word, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)"-> loadDictionary", (Throwable)e);
        }
        task.execute(new String[]{urlString});
    }

    private void loadWikipedia() {
        if (this.noNetwork.getVisibility() == 0 || this.googleSearch.getVisibility() == 0) {
            this.noNetwork.setVisibility(8);
            this.googleSearch.setVisibility(8);
        }
        this.wikiWebView.loadUrl("about:blank");
        this.mAdapter.clear();
        this.wikiLayout.setVisibility(0);
        this.dictResults.setVisibility(8);
        this.dictionary.setSelected(false);
        this.wikipedia.setSelected(true);
        WikipediaTask task = new WikipediaTask(this);
        String urlString = null;
        try {
            urlString = "https://en.wikipedia.org/w/api.php?action=opensearch&namespace=0&format=json&search=" + URLEncoder.encode(this.word, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)"-> loadWikipedia", (Throwable)e);
        }
        task.execute(new String[]{urlString});
    }

    @Override
    public void onError() {
        this.noNetwork.setVisibility(0);
        this.progressBar.setVisibility(8);
        this.noNetwork.setText((CharSequence)"offline");
        this.googleSearch.setVisibility(8);
    }

    @Override
    public void onDictionaryDataReceived(Dictionary dictionary) {
        this.progressBar.setVisibility(8);
        if (dictionary.getResults().isEmpty()) {
            this.noNetwork.setVisibility(0);
            this.googleSearch.setVisibility(0);
            this.noNetwork.setText((CharSequence)"Word not found");
        } else {
            this.mAdapter.setResults(dictionary.getResults());
            this.dictResults.setAdapter((RecyclerView.Adapter)this.mAdapter);
        }
    }

    @Override
    public void onWikipediaDataReceived(Wikipedia wikipedia) {
        this.wikiWord.setText((CharSequence)wikipedia.getWord());
        if (wikipedia.getDefinition().trim().isEmpty()) {
            this.def.setVisibility(8);
        } else {
            String definition = "\"" + wikipedia.getDefinition() + "\"";
            this.def.setText((CharSequence)definition);
        }
        this.wikiWebView.loadUrl(wikipedia.getLink());
    }

    @Override
    public void playMedia(String url) {
        if (this.mediaPlayer != null) {
            try {
                this.mediaPlayer.setDataSource(url);
                this.mediaPlayer.prepare();
                this.mediaPlayer.start();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"playMedia failed", (Throwable)e);
            }
        }
    }

    public void onStart() {
        super.onStart();
        Dialog d = this.getDialog();
        if (d != null) {
            d.getWindow().setLayout(-1, -1);
        }
    }

    public void onStop() {
        super.onStop();
        if (this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.stop();
            this.mediaPlayer.release();
        }
    }
}

