/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.adapter;

import android.content.Context;
import android.graphics.Typeface;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.folioreader.Config;
import com.folioreader.R;
import com.folioreader.model.dictionary.Audio;
import com.folioreader.model.dictionary.DictionaryResults;
import com.folioreader.model.dictionary.Example;
import com.folioreader.model.dictionary.Pronunciations;
import com.folioreader.model.dictionary.Senses;
import com.folioreader.ui.base.DictionaryCallBack;
import com.folioreader.util.AppUtil;
import java.util.ArrayList;
import java.util.List;

public class DictionaryAdapter
extends RecyclerView.Adapter<DictionaryHolder> {
    private List<DictionaryResults> results = new ArrayList<DictionaryResults>();
    private Context context;
    private DictionaryCallBack callBack;
    private static Config config;

    public DictionaryAdapter(Context context, DictionaryCallBack callBack) {
        this.context = context;
        this.callBack = callBack;
        config = AppUtil.getSavedConfig(context);
    }

    public DictionaryHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new DictionaryHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_dictionary, parent, false));
    }

    public void onBindViewHolder(DictionaryHolder holder, int position) {
        DictionaryResults res = this.results.get(position);
        if (res.getPartOfSpeech() != null) {
            int wordLength = res.getHeadword().length();
            SpannableString spannableString = new SpannableString((CharSequence)(res.getHeadword() + " - " + res.getPartOfSpeech()));
            spannableString.setSpan((Object)new StyleSpan(1), 0, wordLength, 0);
            spannableString.setSpan((Object)new StyleSpan(2), wordLength + 2, spannableString.length(), 0);
            holder.name.setText((CharSequence)spannableString);
        } else {
            holder.name.setTypeface(Typeface.DEFAULT_BOLD);
            holder.name.setText((CharSequence)res.getHeadword());
        }
        StringBuilder def = new StringBuilder();
        StringBuilder exp = new StringBuilder();
        if (res.getSenses() != null) {
            for (Senses senses : res.getSenses()) {
                if (senses.getDefinition() == null) continue;
                for (String s : senses.getDefinition()) {
                    def.append("\u2022 ").append(s).append('\n');
                }
            }
            for (Senses senses : res.getSenses()) {
                if (senses.getExamples() == null) continue;
                for (Example s : senses.getExamples()) {
                    exp.append("\u2022 ").append(s.getText()).append('\n');
                }
            }
        }
        if (!def.toString().trim().isEmpty()) {
            def.insert(0, "Definition\n");
            holder.definition.setText((CharSequence)def.toString());
        } else {
            holder.definition.setVisibility(8);
        }
        if (!exp.toString().trim().isEmpty()) {
            exp.insert(0, "Example\n");
            holder.example.setText((CharSequence)exp.toString());
        } else {
            holder.example.setVisibility(8);
        }
    }

    private String getAudioUrl(List<Pronunciations> pronunciations) {
        Audio audio;
        if (!pronunciations.isEmpty() && pronunciations.get(0).getAudio() != null && !pronunciations.get(0).getAudio().isEmpty() && (audio = pronunciations.get(0).getAudio().get(0)).getUrl() != null) {
            return audio.getUrl();
        }
        return null;
    }

    public void setResults(List<DictionaryResults> resultsList) {
        if (resultsList != null && !resultsList.isEmpty()) {
            this.results.addAll(resultsList);
            this.notifyDataSetChanged();
        }
    }

    public void clear() {
        this.results.clear();
        this.notifyItemRangeRemoved(0, this.results.size());
    }

    public int getItemCount() {
        return this.results.size();
    }

    public static class DictionaryHolder
    extends RecyclerView.ViewHolder {
        private TextView name;
        private TextView definition;
        private TextView example;

        public DictionaryHolder(View itemView) {
            super(itemView);
            this.name = (TextView)itemView.findViewById(R.id.tv_word);
            this.definition = (TextView)itemView.findViewById(R.id.tv_definition);
            this.example = (TextView)itemView.findViewById(R.id.tv_examples);
            View rootView = itemView.findViewById(R.id.rootView);
            if (config.isNightMode()) {
                rootView.setBackgroundColor(-16777216);
                int nightTextColor = ContextCompat.getColor((Context)itemView.getContext(), (int)R.color.night_text_color);
                this.name.setTextColor(nightTextColor);
                this.definition.setTextColor(nightTextColor);
                this.example.setTextColor(nightTextColor);
            } else {
                rootView.setBackgroundColor(-1);
            }
        }
    }
}

