/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.model.sqlite;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.folioreader.model.sqlite.FolioDatabaseHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DictionaryTable {
    public static final String TABLE_NAME = "dictionary_table";
    public static final String ID = "_id";
    public static final String WORD = "word";
    public static final String MEANING = "meaning";
    private SQLiteDatabase database;
    public static final String SQL_CREATE = "CREATE TABLE IF NOT EXISTS dictionary_table ( _id INTEGER PRIMARY KEY AUTOINCREMENT,word TEXT,meaning TEXT)";
    public static final String SQL_DROP = "DROP TABLE IF EXISTS dictionary_table";

    public DictionaryTable(Context context) {
        FolioDatabaseHelper dbHelper = new FolioDatabaseHelper(context);
        this.database = dbHelper.getWritableDatabase();
    }

    public boolean insertWord(String word, String meaning) {
        ContentValues values = new ContentValues();
        values.put(WORD, word);
        values.put(MEANING, meaning);
        return this.database.insert(TABLE_NAME, null, values) > 0L;
    }

    public void insert(Map<String, String> map) {
        this.database.beginTransaction();
        for (String key : map.keySet()) {
            this.insertWord(key.toLowerCase(), map.get(key));
        }
        this.database.setTransactionSuccessful();
        this.database.endTransaction();
    }

    public String getMeaningForWord(String word) {
        Cursor c = this.database.rawQuery("SELECT * FROM dictionary_table WHERE word = \"" + word.trim() + "\"", null);
        if (c.moveToFirst()) {
            String toRetuen = c.getString(2);
            c.close();
            return toRetuen;
        }
        c.close();
        return null;
    }

    public List<String> getMeaning(String word) {
        ArrayList<String> words = new ArrayList<String>();
        String meaning = this.getMeaningForWord(word);
        if (meaning != null) {
            words.add(meaning);
            return words;
        }
        return this.getProbableCombinations(word);
    }

    private List<String> getProbableCombinations(String word) {
        ArrayList<String> combinations = new ArrayList<String>();
        for (int i = 1; i <= 3; ++i) {
            String m = this.getMeaningForWord(word.substring(0, word.length() - i));
            if (m == null) continue;
            combinations.add(m);
        }
        return combinations;
    }
}

