/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.adapter;

import android.os.Bundle;
import android.util.Log;
import android.view.ViewGroup;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;
import com.folioreader.ui.fragment.FolioPageFragment;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.readium.r2.shared.Link;

public class FolioPageFragmentAdapter
extends FragmentStatePagerAdapter {
    private static final String LOG_TAG = FolioPageFragmentAdapter.class.getSimpleName();
    private List<Link> mSpineReferences;
    private String mEpubFileName;
    private String mBookId;
    private ArrayList<Fragment> fragments;
    private ArrayList<Fragment.SavedState> savedStateList;

    public FolioPageFragmentAdapter(FragmentManager fragmentManager, List<Link> spineReferences, String epubFileName, String bookId) {
        super(fragmentManager);
        this.mSpineReferences = spineReferences;
        this.mEpubFileName = epubFileName;
        this.mBookId = bookId;
        this.fragments = new ArrayList<Fragment>(Arrays.asList(new Fragment[this.mSpineReferences.size()]));
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        super.destroyItem(container, position, object);
        this.fragments.set(position, null);
    }

    public Object instantiateItem(ViewGroup container, int position) {
        Fragment fragment = (Fragment)super.instantiateItem(container, position);
        this.fragments.set(position, fragment);
        return fragment;
    }

    public Fragment getItem(int position) {
        if (this.mSpineReferences.size() == 0 || position < 0 || position >= this.mSpineReferences.size()) {
            return null;
        }
        Fragment fragment = this.fragments.get(position);
        if (fragment == null) {
            fragment = FolioPageFragment.newInstance(position, this.mEpubFileName, this.mSpineReferences.get(position), this.mBookId);
            this.fragments.set(position, fragment);
        }
        return fragment;
    }

    public ArrayList<Fragment> getFragments() {
        return this.fragments;
    }

    public ArrayList<Fragment.SavedState> getSavedStateList() {
        if (this.savedStateList == null) {
            try {
                Field field = FragmentStatePagerAdapter.class.getDeclaredField("mSavedState");
                field.setAccessible(true);
                this.savedStateList = (ArrayList)field.get((Object)this);
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)"-> ", (Throwable)e);
            }
        }
        return this.savedStateList;
    }

    public static Bundle getBundleFromSavedState(Fragment.SavedState savedState) {
        Bundle bundle = null;
        try {
            Field field = Fragment.SavedState.class.getDeclaredField("mState");
            field.setAccessible(true);
            bundle = (Bundle)field.get(savedState);
        }
        catch (Exception e) {
            Log.v((String)LOG_TAG, (String)("-> " + e));
        }
        return bundle;
    }

    public int getCount() {
        return this.mSpineReferences.size();
    }
}

