/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.folioreader.Config;
import com.folioreader.R;
import com.folioreader.util.FontFinder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\"\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/folioreader/ui/adapter/FontAdapter;", "Landroid/widget/ArrayAdapter;", "", "config", "Lcom/folioreader/Config;", "context", "Landroid/content/Context;", "userFonts", "", "Ljava/io/File;", "systemFonts", "fontKeyList", "", "(Lcom/folioreader/Config;Landroid/content/Context;Ljava/util/Map;Ljava/util/Map;Ljava/util/List;)V", "getFontKeyList", "()Ljava/util/List;", "createTextView", "Landroid/widget/TextView;", "position", "", "getDropDownView", "Landroid/view/View;", "convertView", "parent", "Landroid/view/ViewGroup;", "getView", "folioreader_release"})
public final class FontAdapter
extends ArrayAdapter<String> {
    private final Config config;
    private final Map<String, File> userFonts;
    private final Map<String, File> systemFonts;
    @NotNull
    private final List<String> fontKeyList;

    @NotNull
    public View getView(int position, @Nullable View convertView, @NotNull ViewGroup parent) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        TextView view = this.createTextView(position);
        if (this.config.isNightMode()) {
            view.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.night_default_font_color));
        } else {
            view.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.day_default_font_color));
        }
        return (View)view;
    }

    @NotNull
    public View getDropDownView(int position, @Nullable View convertView, @NotNull ViewGroup parent) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        TextView view = this.createTextView(position);
        if (this.config.isNightMode()) {
            view.setBackgroundResource(R.color.night_background_color);
            view.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.night_default_font_color));
        } else {
            view.setBackgroundResource(R.color.day_background_color);
            view.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.day_default_font_color));
        }
        return (View)view;
    }

    @SuppressLint(value={"ViewHolder", "InflateParams"})
    private final TextView createTextView(int position) {
        Object object = this.getContext().getSystemService("layout_inflater");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.LayoutInflater");
        }
        LayoutInflater inflater = (LayoutInflater)object;
        View view = inflater.inflate(R.layout.item_styled_text, null);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
        }
        TextView view2 = (TextView)view;
        String fontKey = this.fontKeyList.get(position);
        view2.setText((CharSequence)fontKey);
        if (this.userFonts.containsKey(fontKey)) {
            view2.setTypeface(Typeface.createFromFile((File)this.userFonts.get(fontKey)));
        } else if (this.systemFonts.containsKey(fontKey)) {
            view2.setTypeface(Typeface.createFromFile((File)this.systemFonts.get(fontKey)));
        }
        return view2;
    }

    @NotNull
    public final List<String> getFontKeyList() {
        return this.fontKeyList;
    }

    public FontAdapter(@NotNull Config config, @NotNull Context context, @NotNull Map<String, ? extends File> userFonts, @NotNull Map<String, ? extends File> systemFonts, @NotNull List<String> fontKeyList) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(userFonts, (String)"userFonts");
        Intrinsics.checkParameterIsNotNull(systemFonts, (String)"systemFonts");
        Intrinsics.checkParameterIsNotNull(fontKeyList, (String)"fontKeyList");
        super(context, 0x1090009, fontKeyList);
        this.config = config;
        this.userFonts = userFonts;
        this.systemFonts = systemFonts;
        this.fontKeyList = fontKeyList;
    }

    public /* synthetic */ FontAdapter(Config config, Context context, Map map, Map map2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = FontFinder.getUserFonts();
        }
        if ((n & 8) != 0) {
            map2 = FontFinder.getSystemFonts();
        }
        if ((n & 0x10) != 0) {
            Collection $this$toTypedArray$iv = map.keySet();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray2 = stringArray;
            Collection collection = ArraysKt.sorted((Comparable[])((Comparable[])stringArray2));
            $this$toTypedArray$iv = map2.keySet();
            Collection collection2 = new ArrayList(collection);
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
            if (stringArray3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray4 = stringArray3;
            Collection collection3 = ArraysKt.sorted((Comparable[])((Comparable[])stringArray4));
            list = CollectionsKt.plus((Collection)collection2, (Iterable)new ArrayList(collection3));
        }
        this(config, context, map, map2, list);
    }
}

