/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.navigationkit;

import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.jibestream.jmapandroidsdk.astar.ASNode;
import com.jibestream.jmapandroidsdk.astar.PathPerFloor;
import com.jibestream.jmapandroidsdk.components.Floor;
import com.jibestream.jmapandroidsdk.components.Map;
import com.jibestream.jmapandroidsdk.components.Waypoint;
import com.jibestream.jmapandroidsdk.jcontroller.JController;
import com.jibestream.jmapandroidsdk.main.Utilities;
import com.jibestream.jmapandroidsdk.rendering_engine.MapLayer;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.JDrawable;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.JIconDrawable;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.JShapeDrawable;
import com.jibestream.jmapandroidsdk.rendering_engine.moving_objects.UserLocation;
import com.jibestream.jmapandroidsdk.styles.JStyle;
import com.jibestream.navigationkit.NavDirectionPopupDrawable;
import com.jibestream.navigationkit.NavigationKitOptions;
import com.jibestream.navigationkit.instructionfactory.Direction;
import com.jibestream.navigationkit.instructionfactory.Instruction;
import com.jibestream.navigationkit.instructionfactory.InstructionFactory;
import com.jibestream.navigationkit.surroundings.SurroundingDefinition;
import com.jibestream.navigationkit.surroundings.SurroundingElements;
import com.jibestream.navigationkit.surroundings.SurroundingIcon;
import com.jibestream.navigationkit.surroundings.SurroundingItem;
import com.jibestream.navigationkit.surroundings.SurroundingShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class NavigationKit {
    private JController controller;
    private int angleThreshold = 20;
    private InstructionFactory instructionFactory;

    public NavigationKit(@NonNull JController jController) {
        this.controller = jController;
        this.instructionFactory = new InstructionFactory(this, jController);
        this.instructionFactory.addLayerOfInterest("Units");
    }

    public NavigationKit(@NonNull JController object, @Nullable NavigationKitOptions object22) {
        this.controller = object;
        if (object22 == null) {
            new NavigationKit((JController)object);
            return;
        }
        NavigationKit navigationKit = this;
        navigationKit.instructionFactory = new InstructionFactory(this, (JController)object);
        navigationKit.instructionFactory.setVisualLimitLeft(((NavigationKitOptions)object22).getVisualLimitLeft());
        navigationKit.instructionFactory.setVisualLimitRight(((NavigationKitOptions)object22).getVisualLimitRight());
        navigationKit.instructionFactory.setVisualRange(((NavigationKitOptions)object22).getVisualRange());
        if (((NavigationKitOptions)object22).getLayersOfInterest().isEmpty()) {
            this.instructionFactory.addLayerOfInterest("Units");
        } else {
            for (String string : ((NavigationKitOptions)object22).getLayersOfInterest()) {
                this.instructionFactory.addLayerOfInterest(string);
            }
        }
        for (String string : ((NavigationKitOptions)object22).getVisualObstacles()) {
            this.instructionFactory.addVisualObstacles(string);
        }
    }

    private boolean doesSegmentWithPoint(PointF pointF, PointF pointF2, PointF pointF3, float f) {
        boolean bl = this.circleWithCenter(pointF3, f, pointF2);
        if (!this.circleWithCenter(pointF3, f, pointF) && !bl) {
            float f2;
            float f3;
            PointF pointF4;
            PointF pointF5;
            PointF pointF6 = pointF5;
            pointF5 = new PointF(pointF2.x - pointF.x, pointF2.y - pointF.y);
            pointF2 = pointF4;
            PointF pointF7 = pointF6;
            pointF2(pointF.x - pointF3.x, pointF.y - pointF3.y);
            float f4 = this.dotProductOfPoint(pointF7, pointF7);
            float f5 = this.dotProductOfPoint(pointF4, pointF6) * 2.0f;
            PointF pointF8 = pointF2;
            float f6 = f;
            float f7 = this.dotProductOfPoint(pointF8, pointF8) - f6 * f6;
            f7 = f5 * f5 - f4 * 4.0f * f7;
            if (f3 < 0.0f) {
                return false;
            }
            f7 = (float)Math.sqrt(f7);
            float f8 = -f5;
            f5 = (f8 - f7) / (f4 *= 2.0f);
            f7 = (f8 + f7) / f4;
            if (f2 >= 0.0f && f5 <= 1.0f) {
                return true;
            }
            return f7 >= 0.0f && f7 <= 1.0f;
        }
        return true;
    }

    private boolean circleWithCenter(PointF pointF, float f, PointF pointF2) {
        float f2;
        float f3;
        float f4 = pointF2.x;
        float f5 = pointF.x;
        float f6 = pointF.y;
        return (float)Math.sqrt((f4 - f5) * (f4 - f5) + (f3 - f2) * ((f4 = pointF2.y) - f6)) <= f;
    }

    private float dotProductOfPoint(PointF pointF, PointF pointF2) {
        return pointF.x * pointF2.x + pointF.y * pointF2.y;
    }

    private PointF getIntersectionWithRay(ArrayList<PointF> arrayList, ArrayList<PointF> arrayList2) {
        PointF pointF;
        PointF pointF2;
        PointF pointF3;
        PointF pointF4;
        ArrayList<PointF> arrayList3 = arrayList;
        NavigationKit navigationKit = arrayList3.get(0);
        PointF pointF5 = arrayList3.get(arrayList3.size() - 1);
        NavigationKit navigationKit2 = navigationKit;
        float f = ((PointF)navigationKit2).x;
        float f2 = ((PointF)navigationKit2).y;
        float f3 = pointF5.x;
        float f4 = pointF5.y;
        PointF pointF6 = pointF4;
        pointF4 = new PointF(f, f2);
        PointF pointF7 = pointF3;
        ArrayList<PointF> arrayList4 = arrayList2;
        pointF7(f3, f4);
        PointF pointF8 = arrayList4.get(0);
        PointF pointF9 = arrayList4.get(arrayList4.size() - 1);
        PointF pointF10 = pointF8;
        float f5 = pointF10.x;
        float f6 = pointF10.y;
        f3 = pointF9.x;
        f4 = pointF9.y;
        PointF pointF11 = pointF2;
        pointF2 = new PointF(f5, f6);
        PointF pointF12 = pointF;
        pointF = new PointF(f3, f4);
        f6 = pointF3.x;
        f3 = pointF6.x;
        f4 = pointF12.y;
        float f7 = pointF11.y;
        float f8 = pointF7.y;
        float f9 = pointF6.y;
        float f10 = pointF12.x;
        float f11 = pointF11.x;
        float f12 = (f6 - f3) * (f4 - f7) - (f8 - f9) * (f10 - f11);
        if (f12 == 0.0f) {
            return null;
        }
        f10 = ((f11 - f3) * (f4 - f7) - (f7 - f9) * (f10 - f11)) / f12;
        f4 = ((f11 - f3) * (f8 - f9) - (f7 - f9) * (f6 - f3)) / f12;
        double d = f10;
        if (!(d < 0.0) && !(d > 1.0)) {
            d = f4;
            if (!(d < 0.0) && !(d > 1.0)) {
                return new PointF(f3 + f10 * (f6 - f3), f9 + f10 * (f8 - f9));
            }
            return null;
        }
        return null;
    }

    private float distanceBetweenPoint(PointF pointF, PointF pointF2) {
        float f;
        float f2 = pointF2.x - pointF.x;
        float f3 = f = pointF2.y - pointF.y;
        return (float)Math.sqrt(f2 * f2 + f3 * f3);
    }

    private float pointPairToBearingDegrees(PointF pointF, PointF pointF2) {
        float f;
        PointF pointF3;
        NavigationKit navigationKit = pointF3;
        float f2 = new PointF((float)(pointF2.x - pointF.x), (float)(pointF2.y - pointF.y)).y;
        return (float)((f < 0.0f ? Math.atan2(-f2, ((PointF)navigationKit).x) : Math.atan2(f2, -((PointF)navigationKit).x) + Math.PI) * 57.29577951308232);
    }

    private float getRelativeAngleWithDegrees(float f, float f2) {
        float f3;
        float f4 = f2 - f;
        if (Math.abs(f3) > 180.0f) {
            if (f2 > f) {
                double d = f2;
                return (float)Math.abs(360.0 - d + (double)f);
            }
            if (f2 < f) {
                return -Math.abs(360.0f - f + f2);
            }
        } else {
            if (f2 > f) {
                return -f4;
            }
            if (f2 < f) {
                return f - f2;
            }
        }
        return 0.0f;
    }

    private float getPixelsFromInches(float f) {
        return this.getPixelsFromMillimeters((float)((double)f * 25.4));
    }

    private float getPixelsFromMillimeters(float f) {
        return f / this.controller.getCurrentMap().getMmPerPixel();
    }

    private float distanceToSegment(PointF pointF, ArrayList<PointF> pointF2, PointF pointF3) {
        float f;
        PointF pointF4 = pointF2.get(0);
        PointF pointF5 = pointF2;
        pointF2 = pointF5.get(pointF5.size() - 1);
        float f2 = this.distanceBetweenPoint(pointF4, pointF2);
        if (f2 == 0.0f) {
            pointF3.set(pointF2.x, pointF2.y);
            return this.distanceBetweenPoint(pointF, pointF2);
        }
        float f3 = pointF4.x;
        float f4 = pointF2.x;
        float f5 = pointF4.y;
        float f6 = pointF2.y;
        f2 = ((pointF.x - f3) * (f4 - f3) + (pointF.y - f5) * (f6 - f5)) / f2;
        if (f < 0.0f) {
            pointF3.set(f3, f5);
            return this.distanceBetweenPoint(pointF, pointF4);
        }
        if (f2 > 1.0f) {
            pointF3.set(f4, f6);
            return this.distanceBetweenPoint(pointF, pointF2);
        }
        return (float)Math.sqrt(this.distanceBetweenPoint(pointF, new PointF(f3 + f2 * (f4 - f3), f5 + f2 * (f6 - f5))));
    }

    public void setAngleThreshold(int n) {
        this.angleThreshold = n;
    }

    public Instruction[] createInstructionsFromPaths(@NonNull PathPerFloor[] pathPerFloorArray) {
        ArrayList<Instruction> arrayList;
        ArrayList<Instruction> arrayList2 = arrayList;
        arrayList = new ArrayList<Instruction>();
        JController jController = this.controller;
        if (jController != null) {
            jController = jController.getActiveVenue().getMaps();
            int n = 0;
            int n2 = pathPerFloorArray.length;
            for (int i = 0; i < n2; ++i) {
                PathPerFloor pathPerFloor = pathPerFloorArray[i];
                Object object = jController.getById(pathPerFloor.mapId);
                Waypoint waypoint = object.getWaypoints().getById(pathPerFloor.points[pathPerFloor.points.length - 1].id);
                Map map = pathPerFloor.points;
                float f = 0.0f;
                int n3 = 0;
                while (n3 < pathPerFloor.points.length) {
                    Waypoint waypoint2 = object.getWaypoints().getById(pathPerFloor.points[n3].id);
                    Waypoint waypoint3 = null;
                    Waypoint waypoint4 = null;
                    int n4 = n3 + 1;
                    if (n4 < ((ASNode[])map).length) {
                        waypoint3 = object.getWaypoints().getById(pathPerFloor.points[n4].id);
                    }
                    if ((n3 += 2) < ((Map)map).length) {
                        waypoint4 = object.getWaypoints().getById(pathPerFloor.points[n3].id);
                    }
                    if (waypoint2 != null && waypoint3 != null && waypoint4 != null) {
                        Direction direction;
                        Object object2 = direction;
                        if (!new Direction(waypoint2, waypoint3, waypoint4, this.angleThreshold).getValue().equalsIgnoreCase("Forward")) {
                            object2 = this.instructionFactory.createFromDirection((Direction)object2);
                            NavigationKit navigationKit = this;
                            ((Instruction)object2).setPixelDistance(f + ((Instruction)object2).getPixelDistance());
                            f = 0.0f;
                            ((Instruction)object2).setTurnReferenceAngle(navigationKit.getRelativeAngleWithDegrees(navigationKit.pointPairToBearingDegrees(new PointF(waypoint2.getCoordinates()[0].floatValue(), waypoint2.getCoordinates()[1].floatValue()), new PointF(waypoint3.getCoordinates()[0].floatValue(), waypoint3.getCoordinates()[1].floatValue())), this.pointPairToBearingDegrees(new PointF(waypoint2.getCoordinates()[0].floatValue(), waypoint2.getCoordinates()[1].floatValue()), new PointF(waypoint4.getCoordinates()[0].floatValue(), waypoint4.getCoordinates()[1].floatValue()))));
                            arrayList2.add((Instruction)object2);
                        } else {
                            f += this.distanceBetweenPoint(new PointF(waypoint2.getCoordinates()[0].floatValue(), waypoint2.getCoordinates()[1].floatValue()), new PointF(waypoint3.getCoordinates()[0].floatValue(), waypoint3.getCoordinates()[1].floatValue()));
                        }
                    }
                    n3 = n4;
                }
                if (n < pathPerFloorArray.length - 1) {
                    Instruction instruction;
                    NavigationKit navigationKit = this;
                    object = jController.getById(pathPerFloor.mapId);
                    map = jController.getById(pathPerFloorArray[n + 1].mapId);
                    String string = pathPerFloor.pathType.getName();
                    object = navigationKit.controller.getCurrentBuilding().getFloors().getByMap(object);
                    map = navigationKit.controller.getCurrentBuilding().getFloors().getByMap(map);
                    Instruction instruction2 = instruction;
                    instruction = new Instruction();
                    object = map.getLevel() > object.getLevel() ? "up" : "down";
                    Instruction instruction3 = instruction2;
                    Instruction instruction4 = instruction2;
                    instruction4.setDirection((String)object);
                    instruction4.setText("Take the " + string + " " + instruction2.getDirection() + " to " + map.getName());
                    instruction2.setCompletionPoint(waypoint);
                    instruction2.setPathType(pathPerFloor.pathType);
                    instruction3.setNextFloor((Floor)map);
                    arrayList2.add(instruction3);
                } else if (((ASNode[])map).length < 2) {
                    Direction direction;
                    pathPerFloor = object.getWaypoints().getById(map[0].id);
                    object = direction;
                    int n5 = this.angleThreshold;
                    direction = new Direction((Waypoint)pathPerFloor, null, null, n5);
                    Instruction instruction = this.instructionFactory.createFromDirection((Direction)object);
                    instruction.setTurnReferenceAngle(0.0f);
                    instruction.setPixelDistance(0.0f);
                    arrayList2.add(instruction);
                } else {
                    Direction direction;
                    Map map2 = map;
                    pathPerFloor = object.getWaypoints().getById(map2[((ASNode[])map2).length - 2].id);
                    object = direction;
                    direction = new Direction((Waypoint)pathPerFloor, waypoint, null, this.angleThreshold);
                    Instruction instruction = this.instructionFactory.createFromDirection((Direction)object);
                    instruction.setTurnReferenceAngle(Direction.getAngle((Waypoint)pathPerFloor, waypoint));
                    instruction.setPixelDistance(f);
                    arrayList2.add(instruction);
                }
                ++n;
            }
        }
        ArrayList<Instruction> arrayList3 = arrayList2;
        return arrayList3.toArray(new Instruction[arrayList3.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public SurroundingElements getSurroundingElements(@NonNull SurroundingDefinition surroundingDefinition) {
        ArrayList arrayList;
        ArrayList<SurroundingIcon> arrayList2;
        Path path;
        ArrayList arrayList3;
        Path path2;
        ArrayList<PointF> arrayList4;
        ArrayList<Object> arrayList5;
        Object object;
        Region region;
        Region region2;
        HashMap hashMap;
        HashMap<Object, ArrayList> hashMap2;
        SurroundingElements surroundingElements;
        SurroundingDefinition surroundingDefinition2 = surroundingDefinition;
        SurroundingDefinition surroundingDefinition3 = surroundingDefinition;
        float f = surroundingDefinition3.getGazeDirection() - (float)surroundingDefinition.getVisualLimitLeft();
        float f2 = (float)((double)surroundingDefinition3.getPoint().x + (double)surroundingDefinition.getVisualRange() * Math.cos((double)surroundingDefinition.getGazeDirection() * Math.PI / 180.0));
        float f3 = (float)((double)surroundingDefinition3.getPoint().y + (double)surroundingDefinition.getVisualRange() * Math.sin((double)surroundingDefinition.getGazeDirection() * Math.PI / 180.0));
        float f4 = surroundingDefinition3.getGazeDirection() + (float)surroundingDefinition.getVisualLimitRight();
        float f5 = this.pointPairToBearingDegrees(surroundingDefinition3.getPoint(), new PointF(f2, f3));
        SurroundingElements surroundingElements2 = surroundingElements;
        surroundingElements = new SurroundingElements();
        PointF pointF = surroundingDefinition2.getPoint();
        float f6 = surroundingDefinition2.getVisualRange();
        HashMap<Object, ArrayList> object32 = hashMap2;
        hashMap2 = new HashMap<Object, ArrayList>();
        PointF pointF2 = hashMap;
        hashMap = new HashMap();
        Object object2 = region2;
        ((ArrayList)object2)();
        ((ArrayList)object2).addAll(surroundingDefinition.getLayersOfInterest());
        region2.addAll(surroundingDefinition.getVisualObstacles());
        object2 = region;
        region = new ArrayList();
        Iterator<Object> iterator = region2.iterator();
        while (iterator.hasNext()) {
            RectF rectF;
            PointF pointF3;
            PointF pointF4;
            PointF pointF5;
            PointF pointF6;
            Path path3;
            SurroundingDefinition surroundingDefinition4 = surroundingDefinition;
            Object object3 = (String)iterator.next();
            JShapeDrawable[] jShapeDrawableArray = this.controller.getShapesInLayer((String)object3, surroundingDefinition.getMap());
            double d = (double)f * Math.PI / 180.0;
            float f7 = (float)((double)surroundingDefinition4.getPoint().x + (double)surroundingDefinition.getVisualRange() * Math.cos(d));
            float f8 = (float)((double)surroundingDefinition4.getPoint().y + (double)surroundingDefinition.getVisualRange() * Math.sin(d));
            double d2 = (double)f4 * Math.PI / 180.0;
            float f9 = (float)((double)surroundingDefinition4.getPoint().x + (double)surroundingDefinition.getVisualRange() * Math.cos(d2));
            float f10 = (float)((double)surroundingDefinition4.getPoint().y + (double)surroundingDefinition.getVisualRange() * Math.sin(d2));
            object = path3;
            Object object4 = pointF6;
            new Path().moveTo(new PointF((float)surroundingDefinition.getPoint().x, (float)surroundingDefinition.getPoint().y).x, ((PointF)object4).y);
            object4 = pointF5;
            object.lineTo(new PointF((float)f7, (float)f8).x, ((PointF)object4).y);
            object4 = pointF4;
            object.lineTo(new PointF((float)f2, (float)f3).x, ((PointF)object4).y);
            object4 = pointF3;
            object.lineTo(new PointF((float)f9, (float)f10).x, ((PointF)object4).y);
            object.close();
            if (((ArrayList)object2).size() < 1) {
                Region region3 = object2;
                region3.add(surroundingDefinition.getPoint());
                region3.add(new PointF(f7, f8));
                region3.add(new PointF(f2, f3));
                region3.add(new PointF(f9, f10));
            }
            RectF rectF2 = rectF;
            object.computeBounds(new RectF(), true);
            for (JShapeDrawable jShapeDrawable : jShapeDrawableArray) {
                if (!jShapeDrawable.getBounds().intersect(rectF2)) continue;
                object = jShapeDrawable.getSegments().iterator();
                while (object.hasNext()) {
                    ArrayList arrayList6;
                    Object object5 = object4 = (ArrayList)object.next();
                    if (!this.doesSegmentWithPoint((PointF)((ArrayList)object4).get(0), (PointF)((ArrayList)object5).get(((ArrayList)object5).size() - 1), pointF, f6)) continue;
                    if (jShapeDrawable.getClassName().equalsIgnoreCase((String)object3) && surroundingDefinition.getLayersOfInterest().contains(jShapeDrawable.getClassName())) {
                        arrayList6 = (ArrayList)object32.get(object3);
                        if (arrayList6 != null) {
                            arrayList6.add(object4);
                        } else {
                            ArrayList arrayList7;
                            arrayList6 = arrayList7;
                            arrayList7 = new ArrayList();
                        }
                        object32.put(object3, arrayList6);
                        pointF2.put(object4, jShapeDrawable);
                        continue;
                    }
                    arrayList6 = (ArrayList)object32.get("Obstacles");
                    if (arrayList6 != null) {
                        arrayList6.add(object4);
                    } else {
                        ArrayList arrayList8;
                        arrayList6 = arrayList8;
                        arrayList8 = new ArrayList();
                    }
                    object32.put("Obstacles", arrayList6);
                }
            }
        }
        ArrayList<Object> arrayList9 = arrayList5;
        arrayList5 = new ArrayList<Object>();
        Path path4 = null;
        float f11 = Float.MAX_VALUE;
        Iterator<String> iterator2 = arrayList4;
        ((ArrayList)((Object)iterator2))();
        arrayList4.add(surroundingDefinition.getPoint());
        arrayList4.add(new PointF(f2, f3));
        iterator = object32.keySet().iterator();
        while (iterator.hasNext()) {
            for (ArrayList arrayList10 : (ArrayList)object32.get((String)iterator.next())) {
                void var15_37;
                float f12;
                block33: {
                    block32: {
                        float f13;
                        PointF pointF7 = this.getIntersectionWithRay((ArrayList<PointF>)((Object)iterator2), arrayList10);
                        if (pointF7 == null) break block32;
                        f12 = this.distanceBetweenPoint(pointF7, surroundingDefinition.getPoint());
                        if (f13 < f11) break block33;
                    }
                    Path path5 = path4;
                    f12 = f11;
                }
                path4 = var15_37;
                f11 = f12;
            }
        }
        Object object8 = path2;
        object8();
        object8.moveTo(surroundingDefinition.getPoint().x, surroundingDefinition.getPoint().y);
        path2.lineTo(f2, f3);
        object8 = arrayList3;
        arrayList3 = new ArrayList();
        iterator2 = object32.keySet().iterator();
        while (iterator2.hasNext()) {
            block6: for (Object object3 : (ArrayList)object32.get((String)iterator2.next())) {
                float f14;
                JShapeDrawable jShapeDrawable = (JShapeDrawable)pointF2.get(object3);
                Object object6 = false;
                Iterator iterator3 = ((ArrayList)object8).iterator();
                while (iterator3.hasNext()) {
                    if (((SurroundingShape)iterator3.next()).getShape() != jShapeDrawable) continue;
                    object6 = true;
                    break;
                }
                if (((Boolean)object6).booleanValue()) continue;
                if (path4 != null && path4.equals(object3)) {
                    PointF pointF8;
                    SurroundingShape surroundingShape;
                    arrayList9.add(object3);
                    if (jShapeDrawable == null) continue;
                    object6 = surroundingShape;
                    ((SurroundingShape)object6)();
                    ((SurroundingShape)object6).setShape(jShapeDrawable);
                    ((SurroundingItem)object6).setLayerName(jShapeDrawable.getClassName());
                    PointF pointF9 = pointF8;
                    pointF8 = new PointF();
                    ((SurroundingItem)object6).setDistance(this.distanceToSegment(surroundingDefinition.getPoint(), (ArrayList<PointF>)object3, pointF9));
                    surroundingShape.setAngle(this.getRelativeAngleWithDegrees(f5, this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), pointF9)));
                    ((ArrayList)object8).add(surroundingShape);
                    continue;
                }
                boolean bl = false;
                Object object7 = object3;
                float f15 = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), (PointF)((ArrayList)object7).get(((ArrayList)object7).size() - 1));
                float f16 = this.getRelativeAngleWithDegrees(f5, this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), (PointF)((ArrayList)object3).get(0)));
                f15 = this.getRelativeAngleWithDegrees(f5, f15);
                if (f14 < 0.0f && Math.abs(f16) < (float)surroundingDefinition.getVisualLimitLeft()) {
                    bl = true;
                }
                if (f16 > 0.0f && Math.abs(f16) < (float)surroundingDefinition.getVisualLimitRight()) {
                    bl = true;
                }
                if (f15 < 0.0f && Math.abs(f15) < (float)surroundingDefinition.getVisualLimitLeft()) {
                    bl = true;
                }
                if (f15 > 0.0f && Math.abs(f15) < (float)surroundingDefinition.getVisualLimitRight()) {
                    bl = true;
                }
                if (!bl) continue;
                Object object9 = ((ArrayList)object3).iterator();
                block8: while (object9.hasNext()) {
                    PointF pointF10;
                    SurroundingShape surroundingShape;
                    ArrayList<PointF> arrayList11;
                    Object object10 = (PointF)object9.next();
                    ArrayList<PointF> arrayList12 = arrayList11;
                    arrayList12();
                    arrayList12.add(surroundingDefinition.getPoint());
                    arrayList11.add((PointF)object10);
                    boolean bl2 = true;
                    object = object32.keySet().iterator();
                    while (object.hasNext()) {
                        for (ArrayList arrayList6 : (ArrayList)object32.get((String)object.next())) {
                            if (arrayList6 == object3 || (arrayList6 = this.getIntersectionWithRay(arrayList12, arrayList6)) == null || new PointF((float)Math.ceil(((PointF)arrayList6).x), (float)Math.ceil(((PointF)arrayList6).y)).equals((Object)new PointF((float)Math.ceil(((PointF)object10).x), (float)Math.ceil(((PointF)object10).y)))) continue;
                            bl2 = false;
                            break;
                        }
                        if (bl2) continue;
                    }
                    if (!bl2) continue;
                    arrayList9.add(object3);
                    if (jShapeDrawable == null) continue block6;
                    object10 = ((ArrayList)object8).iterator();
                    while (object10.hasNext()) {
                        if (((SurroundingShape)object10.next()).getShape() != jShapeDrawable) continue;
                        continue block8;
                    }
                    object9 = surroundingShape;
                    ((SurroundingShape)object9)();
                    ((SurroundingShape)object9).setShape(jShapeDrawable);
                    ((SurroundingItem)object9).setLayerName(jShapeDrawable.getClassName());
                    PointF pointF11 = pointF10;
                    pointF10 = new PointF();
                    ((SurroundingItem)object9).setDistance(this.distanceToSegment(surroundingDefinition.getPoint(), (ArrayList<PointF>)object3, pointF11));
                    surroundingShape.setAngle(this.getRelativeAngleWithDegrees(f5, this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), pointF11)));
                    ((ArrayList)object8).add(surroundingShape);
                    continue block6;
                }
            }
        }
        Object object11 = object8;
        Collections.sort(object11, new Comparator<SurroundingShape>(){

            @Override
            public int compare(SurroundingShape surroundingShape, SurroundingShape surroundingShape2) {
                return Float.valueOf(surroundingShape.getDistance()).compareTo(Float.valueOf(surroundingShape2.getDistance()));
            }
        });
        surroundingElements2.setShapes(((ArrayList)object11).toArray(new SurroundingShape[((ArrayList)object11).size()]));
        path4 = path;
        path = new Path();
        if (((ArrayList)object2).size() > 0) {
            PointF pointF10 = (PointF)((ArrayList)object2).get(0);
            path4.moveTo(pointF10.x, pointF10.y);
            for (int i = 1; i < ((ArrayList)object2).size(); ++i) {
                object8 = (PointF)((ArrayList)object2).get(i);
                path4.lineTo(((PointF)object8).x, ((PointF)object8).y);
            }
            path4.close();
        }
        ArrayList<SurroundingIcon> arrayList12 = arrayList2;
        arrayList2 = new ArrayList<SurroundingIcon>();
        object8 = arrayList;
        arrayList = new ArrayList();
        for (String surroundingIcon2 : surroundingDefinition.getLayersOfInterest()) {
            ArrayList arrayList13;
            pointF2 = arrayList13;
            arrayList13 = new ArrayList();
            MapLayer mapLayer = this.controller.getMapView().getCurrentMapDrawable().getMapLayer(surroundingIcon2);
            if (mapLayer != null) {
                pointF2.addAll(new ArrayList<JIconDrawable>(Arrays.asList(mapLayer.getIconDrawables())));
            }
            ((ArrayList)object8).addAll(pointF2);
        }
        object8 = ((ArrayList)object8).iterator();
        while (object8.hasNext()) {
            SurroundingIcon surroundingIcon;
            boolean bl;
            ArrayList arrayList14;
            Region region4;
            RectF rectF;
            PointF pointF12;
            JIconDrawable jIconDrawable = (JIconDrawable)object8.next();
            Waypoint waypoint = surroundingDefinition.getMap().getWaypoints().getById(jIconDrawable.getWaypointId());
            if (waypoint == null) continue;
            pointF2 = pointF12;
            pointF12 = new PointF(waypoint.getCoordinates()[0].floatValue(), waypoint.getCoordinates()[1].floatValue());
            RectF rectF3 = rectF;
            path4.computeBounds(new RectF(), true);
            object2 = region4;
            object2();
            object2.setPath(path4, new Region((int)rectF3.left, (int)rectF3.top, (int)rectF3.right, (int)rectF3.bottom));
            if (!region4.contains((int)pointF2.x, (int)pointF2.y)) continue;
            boolean bl3 = true;
            object2 = arrayList14;
            ((ArrayList)object2)();
            ((ArrayList)object2).add(surroundingDefinition.getPoint());
            arrayList14.add(pointF2);
            iterator = arrayList9.iterator();
            while (iterator.hasNext()) {
                if (this.getIntersectionWithRay((ArrayList<PointF>)object2, (ArrayList)iterator.next()) == null) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            SurroundingIcon surroundingIcon2 = surroundingIcon;
            NavigationKit navigationKit = this;
            surroundingIcon2();
            surroundingIcon2.setIcon(jIconDrawable);
            surroundingIcon2.setLayerName(jIconDrawable.getClassName());
            float f17 = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), pointF2);
            surroundingIcon2.setAngle(navigationKit.getRelativeAngleWithDegrees(navigationKit.pointPairToBearingDegrees(surroundingDefinition.getPoint(), new PointF(f2, f3)), f17));
            surroundingIcon.setDistance(this.distanceBetweenPoint(surroundingDefinition.getPoint(), pointF2));
            arrayList12.add(surroundingIcon);
        }
        SurroundingElements surroundingElements3 = surroundingElements2;
        ArrayList<SurroundingIcon> arrayList15 = arrayList12;
        Collections.sort(arrayList15, new Comparator<SurroundingIcon>(){

            @Override
            public int compare(SurroundingIcon surroundingIcon, SurroundingIcon surroundingIcon2) {
                return Float.valueOf(surroundingIcon.getDistance()).compareTo(Float.valueOf(surroundingIcon2.getDistance()));
            }
        });
        surroundingElements3.setIcons(arrayList15.toArray(new SurroundingIcon[arrayList15.size()]));
        return surroundingElements3;
    }

    public void drawPathWithInstructions(@NonNull PathPerFloor[] pathPerFloorArray, @Nullable JStyle jStyle, @Nullable JStyle jStyle2, @Nullable JStyle jStyle3) {
        for (Instruction instruction : this.createInstructionsFromPaths(pathPerFloorArray)) {
            PointF pointF;
            String string = instruction.getText().toLowerCase().contains("arrive") ? "ARRIVE" : instruction.getDirection().toUpperCase();
            NavDirectionPopupDrawable navDirectionPopupDrawable = new NavDirectionPopupDrawable(string, jStyle2, jStyle3);
            if ((instruction = instruction.getDecisionPoint() != null ? instruction.getDecisionPoint() : instruction.getCompletionPoint()) == null || (string = this.controller.getActiveVenue().getMaps().getById(instruction.getMapId())) == null) continue;
            PointF pointF2 = pointF;
            pointF = new PointF(instruction.getCoordinates()[0].floatValue(), instruction.getCoordinates()[1].floatValue());
            this.controller.addComponent((JDrawable)navDirectionPopupDrawable, (Map)string, pointF2, "Wayfind-Layer");
        }
        this.controller.drawWayfindingPath(pathPerFloorArray, jStyle);
    }

    public void setInstructionFactory(@NonNull InstructionFactory instructionFactory) {
        this.instructionFactory = instructionFactory;
    }

    public boolean hasUserVeeredOffRoute(@NonNull PathPerFloor[] pointF, float f) {
        Object object = UserLocation.getInstance();
        int n = ((PathPerFloor[])pointF).length;
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList;
            PointF pointF2;
            PathPerFloor pathPerFloor = pointF[i];
            if (object.getMapId() != pathPerFloor.mapId || pathPerFloor.points.length < 2) continue;
            pointF = pointF2;
            pointF2 = new PointF(object.getX(), object.getY());
            object = arrayList;
            arrayList = new ArrayList();
            n = 0;
            while (true) {
                ASNode[] aSNodeArray = pathPerFloor.points;
                if (n >= pathPerFloor.points.length - 1) break;
                ((ArrayList)object).add(Float.valueOf(Utilities.distanceFromPointToLine((PointF)pointF, (PointF)aSNodeArray[n].asPointF(), (PointF)pathPerFloor.points[++n].asPointF())));
            }
            return ((Float)Collections.min(object)).floatValue() * this.controller.getCurrentMap().getMmPerPixel() > f;
        }
        return false;
    }
}

