/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.navigationkit.instructionfactory;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.jibestream.jmapandroidsdk.components.Floor;
import com.jibestream.jmapandroidsdk.components.PathType;
import com.jibestream.jmapandroidsdk.components.Waypoint;
import com.jibestream.navigationkit.instructionfactory.Direction;
import com.jibestream.navigationkit.surroundings.SurroundingDefinition;
import com.jibestream.navigationkit.surroundings.SurroundingElements;

public class Instruction {
    private String direction;
    private String text;
    private String defaultInstruction;
    private float turnReferenceAngle;
    private float pixelDistance;
    private PathType pathType;
    private Waypoint originPoint;
    private Waypoint decisionPoint;
    private Waypoint completionPoint;
    private Floor nextFloor;
    private SurroundingDefinition surroundingDefinition;
    private SurroundingElements surroundingElements;

    public Instruction() {
    }

    public Instruction(@NonNull Direction direction) {
        this.setDistanceWithDirection(direction);
        this.setPointsWithDirection(direction);
        this.setTextWithDirection(direction);
    }

    public void setDistanceWithDirection(@NonNull Direction direction) {
        if (direction == null || direction.getA() == null || direction.getB() == null) {
            return;
        }
        Float[] floatArray = direction.getA().getCoordinates();
        Float[] floatArray2 = direction.getB().getCoordinates();
        if (floatArray.length > 0 && floatArray2.length > 0) {
            this.pixelDistance = Math.round(Math.sqrt(Math.pow(floatArray2[0].floatValue() - floatArray[0].floatValue(), 2.0) + Math.pow(floatArray2[1].floatValue() - floatArray[1].floatValue(), 2.0)));
        }
    }

    public void setPointsWithDirection(@NonNull Direction direction) {
        this.originPoint = direction.getA();
        this.decisionPoint = direction.getC() != null ? direction.getB() : null;
        this.completionPoint = direction.getC() != null ? direction.getC() : direction.getB();
    }

    public void setTextWithDirection(@NonNull Direction direction) {
        this.direction = direction.getValue();
        this.text = direction.getC() != null ? "Turn " + direction.getValue() : "Arrive at your destination";
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(@NonNull String string) {
        this.direction = string;
    }

    public String getText() {
        return this.text;
    }

    public void setText(@NonNull String string) {
        this.text = string;
    }

    public String getDefaultInstruction() {
        return this.defaultInstruction;
    }

    public void setDefaultInstruction(@NonNull String string) {
        this.defaultInstruction = string;
    }

    public float getTurnReferenceAngle() {
        return this.turnReferenceAngle;
    }

    public void setTurnReferenceAngle(float f) {
        this.turnReferenceAngle = f;
    }

    public float getPixelDistance() {
        return this.pixelDistance;
    }

    public void setPixelDistance(float f) {
        this.pixelDistance = f;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public void setPathType(@Nullable PathType pathType) {
        this.pathType = pathType;
    }

    public Waypoint getOriginPoint() {
        return this.originPoint;
    }

    public void setOriginPoint(@NonNull Waypoint waypoint) {
        this.originPoint = waypoint;
    }

    public Waypoint getDecisionPoint() {
        return this.decisionPoint;
    }

    public void setDecisionPoint(@Nullable Waypoint waypoint) {
        this.decisionPoint = waypoint;
    }

    public Waypoint getCompletionPoint() {
        return this.completionPoint;
    }

    public void setCompletionPoint(@NonNull Waypoint waypoint) {
        this.completionPoint = waypoint;
    }

    public Floor getNextFloor() {
        return this.nextFloor;
    }

    public void setNextFloor(@Nullable Floor floor) {
        this.nextFloor = floor;
    }

    public SurroundingDefinition getSurroundingDefinition() {
        return this.surroundingDefinition;
    }

    public void setSurroundingDefinition(@NonNull SurroundingDefinition surroundingDefinition) {
        this.surroundingDefinition = surroundingDefinition;
    }

    public SurroundingElements getSurroundingElements() {
        return this.surroundingElements;
    }

    public void setSurroundingElements(@NonNull SurroundingElements surroundingElements) {
        this.surroundingElements = surroundingElements;
    }

    public String toString() {
        String string = "";
        string = string + (this.direction != null ? "direction = " + this.direction + "\n" : "");
        string = string + (this.text != null ? "text = " + this.text + "\n" : "");
        string = string + (this.defaultInstruction != null ? "defaultInstruction = " + this.defaultInstruction + "\n" : "");
        string = string + "turnReferenceAngle = " + this.turnReferenceAngle + "\n";
        string = string + "pixelDistance = " + this.pixelDistance + "\n";
        string = string + (this.pathType != null ? "pathType = " + this.pathType.toString() + "\n" : "");
        string = string + (this.originPoint != null ? "originPoint = " + this.originPoint + "\n" : "originPoint = null\n");
        string = string + (this.decisionPoint != null ? "decisionPoint = " + this.decisionPoint + "\n" : "decisionPoint = null\n");
        string = string + (this.completionPoint != null ? "completionPoint = " + this.completionPoint + "\n" : "completionPoint = null\n");
        string = string + (this.nextFloor != null ? "nextFloor = " + this.nextFloor + "\n" : "");
        string = string + (this.surroundingDefinition != null ? "surroundingDefinition = " + this.surroundingDefinition + "\n" : "surroundingDefinition = null\n");
        string = string + (this.surroundingElements != null ? "surroundingElements = " + this.surroundingElements.getShapes().length + "\n" : "surroundingElements = null");
        return string;
    }
}

