/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.navigationkit;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.JDrawable;
import com.jibestream.jmapandroidsdk.styles.JStyle;

class NavDirectionPopupDrawable
extends JDrawable {
    private final float STROKE_WIDTH = 0.5f;
    private final int BOX_PADDING = 2;
    private final float TEXT_SIZE = 5.0f;
    private final int RECT_CORNER_RADIUS = 3;
    private Paint textPaint;
    private Paint bgPaint;
    private Paint bgPaintStroke;
    private Rect textBounds;
    private RectF box;
    private String text;

    NavDirectionPopupDrawable(String string, JStyle jStyle, JStyle jStyle2) {
        if (jStyle2 == null) {
            this.textPaint = new Paint();
            this.textPaint.setAntiAlias(true);
            this.textPaint.setColor(-1);
            this.textPaint.setTextAlign(Paint.Align.CENTER);
            this.textPaint.setTextSize(5.0f);
        } else {
            this.textPaint = jStyle2;
            this.textPaint.setTextAlign(Paint.Align.CENTER);
        }
        if (jStyle == null) {
            this.bgPaint = new Paint();
            this.bgPaint.setAntiAlias(true);
            this.bgPaint.setColor(-65536);
            this.bgPaintStroke = new Paint();
            this.bgPaintStroke.setStyle(Paint.Style.STROKE);
            this.bgPaintStroke.setAntiAlias(true);
            this.bgPaintStroke.setColor(-1);
            this.bgPaintStroke.setStrokeWidth(0.5f);
        } else {
            this.bgPaint = jStyle;
            this.bgPaint.setStyle(Paint.Style.FILL);
            this.bgPaintStroke = new Paint();
            this.bgPaintStroke.setStyle(Paint.Style.STROKE);
            this.bgPaintStroke.setAntiAlias(true);
            this.bgPaintStroke.setColor(jStyle.getStrokeColor() != 0 ? jStyle.getStrokeColor() : 0);
            this.bgPaintStroke.setStrokeWidth(jStyle.getStrokeWidth() > 0.0f ? jStyle.getStrokeWidth() : 0.0f);
        }
        this.setText(string);
        this.setVisible(true);
        this.setHeadsUp(true);
    }

    public void draw(Canvas canvas) {
        canvas.drawRoundRect(this.box, 3.0f, 3.0f, this.bgPaint);
        canvas.drawRoundRect(this.box, 3.0f, 3.0f, this.bgPaintStroke);
        canvas.drawText(this.text, this.box.centerX(), this.box.centerY() - 0.5f + (float)this.textBounds.height() / 2.0f, this.textPaint);
    }

    public void setText(String string) {
        this.textBounds = new Rect();
        this.textPaint.getTextBounds(string, 0, string.length(), this.textBounds);
        this.calculateBounds();
        this.text = string;
    }

    public void setX(float f) {
        super.setX(f);
        this.calculateBounds();
    }

    public void setY(float f) {
        super.setY(f);
        this.calculateBounds();
    }

    private void calculateBounds() {
        this.box = new RectF(this.getX() - (float)(this.textBounds.width() / 2) - 2.0f, this.getY() - (float)(this.textBounds.height() / 2) - 2.0f, this.getX() + (float)(this.textBounds.width() / 2) + 2.0f, this.getY() + (float)(this.textBounds.height() / 2) + 2.0f);
    }
}

