package com.jibestream.navigationkit;

import android.support.annotation.NonNull;

import java.util.ArrayList;

/**
 * Created by louieyuen on 2017-10-05.
 */

public class NavigationKitOptions {
    private int visualLimitRight;
    private int visualLimitLeft;
    private int visualRange;
    private ArrayList<String> layersOfInterest;
    private ArrayList<String> visualObstacles;

    /**
     * NavigationKitOptions Constructor
     */
    public NavigationKitOptions() {
        //Set default values
        this.visualLimitLeft = 60;
        this.visualLimitRight = 60;
        this.visualRange = 250;
        this.layersOfInterest = new ArrayList<String>();
        this.visualObstacles = new ArrayList<String>();
    }

    public int getVisualLimitRight() {
        return visualLimitRight;
    }

    public void setVisualLimitRight(int visualLimitRight) {
        this.visualLimitRight = visualLimitRight;
    }

    public int getVisualLimitLeft() {
        return visualLimitLeft;
    }

    public void setVisualLimitLeft(int visualLimitLeft) {
        this.visualLimitLeft = visualLimitLeft;
    }

    public int getVisualRange() {
        return visualRange;
    }

    public void setVisualRange(int visualRange) {
        this.visualRange = visualRange;
    }

    public void addLayerOfInterest(@NonNull String layerName) {
        this.layersOfInterest.add(layerName);
    }

    public ArrayList<String> getLayersOfInterest() {
        return this.layersOfInterest;
    }

    public void removeLayerOfInterest(@NonNull String layerName) {
        this.layersOfInterest.remove(layerName);
    }

    public ArrayList<String> getVisualObstacles() {
        return this.visualObstacles;
    }

    public void addVisualObstacles(@NonNull String layerName) {
        this.visualObstacles.add(layerName);
    }

    public void removeVisualObstacles(@NonNull String layerName) {
        this.visualObstacles.remove(layerName);
    }
}
