/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.navigationkit.instructionfactory;

import com.jibestream.jmapandroidsdk.components.PathType;
import com.jibestream.jmapandroidsdk.components.Waypoint;
import com.jibestream.navigationkit.instructionfactory.Direction;
import com.jibestream.navigationkit.surroundings.SurroundingDefinition;
import com.jibestream.navigationkit.surroundings.SurroundingElements;

public class Instruction {
    private String direction;
    private String text;
    private String defaultInstruction;
    private float turnReferenceAngle;
    private float pixelDistance;
    private PathType pathType;
    private Waypoint originPoint;
    private Waypoint decisionPoint;
    private Waypoint completionPoint;
    private SurroundingDefinition surroundingDefinition;
    private SurroundingElements surroundingElements;

    public Instruction() {
    }

    public Instruction(Direction direction) {
        this.setDistanceWithDirection(direction);
        this.setPointsWithDirection(direction);
        this.setTextWithDirection(direction);
    }

    public void setDistanceWithDirection(Direction direction) {
        Float[] aCoords = direction.getA().getCoordinates();
        Float[] bCoords = direction.getB().getCoordinates();
        if (aCoords.length > 0 && bCoords.length > 0) {
            this.pixelDistance = Math.round(Math.sqrt(Math.pow(bCoords[0].floatValue() - aCoords[0].floatValue(), 2.0) + Math.pow(bCoords[1].floatValue() - aCoords[1].floatValue(), 2.0)));
        }
    }

    public void setPointsWithDirection(Direction direction) {
        this.originPoint = direction.getA();
        this.decisionPoint = direction.getC() != null ? direction.getB() : null;
        this.completionPoint = direction.getC() != null ? direction.getC() : direction.getB();
    }

    public void setTextWithDirection(Direction direction) {
        this.direction = direction.getValue();
        this.text = direction.getC() != null ? "Turn " + direction.getValue() : "Arrive at your destination";
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getDefaultInstruction() {
        return this.defaultInstruction;
    }

    public void setDefaultInstruction(String defaultInstruction) {
        this.defaultInstruction = defaultInstruction;
    }

    public float getTurnReferenceAngle() {
        return this.turnReferenceAngle;
    }

    public void setTurnReferenceAngle(float turnReferenceAngle) {
        this.turnReferenceAngle = turnReferenceAngle;
    }

    public float getPixelDistance() {
        return this.pixelDistance;
    }

    public void setPixelDistance(float pixelDistance) {
        this.pixelDistance = pixelDistance;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public void setPathType(PathType pathType) {
        this.pathType = pathType;
    }

    public Waypoint getOriginPoint() {
        return this.originPoint;
    }

    public void setOriginPoint(Waypoint originPoint) {
        this.originPoint = originPoint;
    }

    public Waypoint getDecisionPoint() {
        return this.decisionPoint;
    }

    public void setDecisionPoint(Waypoint decisionPoint) {
        this.decisionPoint = decisionPoint;
    }

    public Waypoint getCompletionPoint() {
        return this.completionPoint;
    }

    public void setCompletionPoint(Waypoint completionPoint) {
        this.completionPoint = completionPoint;
    }

    public SurroundingDefinition getSurroundingDefinition() {
        return this.surroundingDefinition;
    }

    public void setSurroundingDefinition(SurroundingDefinition surroundingDefinition) {
        this.surroundingDefinition = surroundingDefinition;
    }

    public SurroundingElements getSurroundingElements() {
        return this.surroundingElements;
    }

    public void setSurroundingElements(SurroundingElements surroundingElements) {
        this.surroundingElements = surroundingElements;
    }

    public String toString() {
        String instructionString = "";
        instructionString = instructionString + (this.direction != null ? "direction = " + this.direction + "\n" : "");
        instructionString = instructionString + (this.text != null ? "text = " + this.text + "\n" : "");
        instructionString = instructionString + (this.defaultInstruction != null ? "defaultInstruction = " + this.defaultInstruction + "\n" : "");
        instructionString = instructionString + "turnReferenceAngle = " + this.turnReferenceAngle + "\n";
        instructionString = instructionString + "pixelDistance = " + this.pixelDistance + "\n";
        instructionString = instructionString + (this.pathType != null ? "pathType = " + this.pathType.toString() + "\n" : "");
        instructionString = instructionString + (this.originPoint != null ? "originPoint = " + this.originPoint + "\n" : "originPoint = null");
        instructionString = instructionString + (this.decisionPoint != null ? "decisionPoint = " + this.decisionPoint + "\n" : "decisionPoint = null");
        instructionString = instructionString + (this.completionPoint != null ? "completionPoint = " + this.completionPoint + "\n" : "completionPoint = null");
        instructionString = instructionString + (this.surroundingDefinition != null ? "surroundingDefinition = " + this.surroundingDefinition + "\n" : "surroundingDefinition = null");
        instructionString = instructionString + (this.surroundingElements != null ? "surroundingElements = " + this.surroundingElements.getShapes().length + "\n" : "surroundingElements = null");
        return instructionString;
    }
}

