package com.jibestream.navigationkit.surroundings;

import android.graphics.PointF;

import com.jibestream.jmapandroidsdk.components.Map;

import java.util.ArrayList;

/**
 * Created by Andrew Adams on 2017-05-15.
 */
public class SurroundingDefinition {

    private Map map;
    private PointF point;
    private float gazeDirection;

    private int visualLimitRight;
    private int visualLimitLeft;
    private int visualRange;

    private int degreesOfPrecision;
    private ArrayList<String> layersOfInterest;
    private ArrayList<String> visualObstacles;

    public SurroundingDefinition(Map map, PointF point) {
        this.map = map;
        this.point = point;

        this.visualLimitLeft = 60;
        this.visualLimitRight = 60;
        this.visualRange = 250;
        this.degreesOfPrecision = 5;

        this.layersOfInterest = new ArrayList<>();
        this.visualObstacles = new ArrayList<>();
    }

    public Map getMap() {
        return map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public PointF getPoint() {
        return point;
    }

    public void setPoint(PointF point) {
        this.point = point;
    }

    public float getGazeDirection() {
        return gazeDirection;
    }

    public void setGazeDirection(float gazeDirection) {
        this.gazeDirection = gazeDirection;
    }

    public int getVisualLimitRight() {
        return visualLimitRight;
    }

    public void setVisualLimitRight(int visualLimitRight) {
        this.visualLimitRight = visualLimitRight;
    }

    public int getVisualLimitLeft() {
        return visualLimitLeft;
    }

    public void setVisualLimitLeft(int visualLimitLeft) {
        this.visualLimitLeft = visualLimitLeft;
    }

    public int getVisualRange() {
        return visualRange;
    }

    public void setVisualRange(int visualRange) {
        this.visualRange = visualRange;
    }

    public int getDegreesOfPrecision() {
        return degreesOfPrecision;
    }

    public void setDegreesOfPrecision(int degreesOfPrecision) {
        this.degreesOfPrecision = degreesOfPrecision;
    }

    public ArrayList<String> getLayersOfInterest() {
        return layersOfInterest;
    }

    public void addLayerOfInterest(String layerName) {
        this.layersOfInterest.add(layerName);
    }

    public void addAllLayersOfInterest(ArrayList<String> layerNames) {
        this.layersOfInterest.addAll(layerNames);
    }

    public void removeLayerOfInterest(String layerName) {
        this.layersOfInterest.remove(layerName);
    }

    public ArrayList<String> getVisualObstacles() {
        return visualObstacles;
    }

    public void addVisualObstacles(String visualObstacleName) {
        this.visualObstacles.add(visualObstacleName);
    }

    public void addAllVisualObstacles(ArrayList<String> visualObstacleName) {
        this.visualObstacles.addAll(visualObstacleName);
    }

    public void removeVisualObstacles(String visualObstacleName) {
        this.visualObstacles.remove(visualObstacleName);
    }
}
