/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.geofencekit;

import android.graphics.Color;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jibestream.geofencekit.Geofence;
import com.jibestream.geofencekit.GeofenceCollection;
import com.jibestream.geofencekit.GeofenceInstance;
import com.jibestream.geofencekit.GeofenceInstancesResponse;
import com.jibestream.jmapandroidsdk.components.Amenity;
import com.jibestream.jmapandroidsdk.components.Destination;
import com.jibestream.jmapandroidsdk.components.Map;
import com.jibestream.jmapandroidsdk.components.PathType;
import com.jibestream.jmapandroidsdk.components.Waypoint;
import com.jibestream.jmapandroidsdk.http.HttpClient;
import com.jibestream.jmapandroidsdk.jcontroller.JController;
import com.jibestream.jmapandroidsdk.jcore.JCore;
import com.jibestream.jmapandroidsdk.main.Polygon;
import com.jibestream.jmapandroidsdk.rendering_engine.MapLayer;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.JShapeDrawable;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.MapDrawable;
import com.jibestream.jmapandroidsdk.rendering_engine.moving_objects.MovingObject;
import com.jibestream.jmapandroidsdk.styles.JStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GeofenceKit {
    private static final String LAYER_GEOFENCES = "Geofences";
    public GeofenceCollection geofenceCollection;
    private JCore core;
    private JController controller;
    private ArrayList<GeofenceInstance> geofenceInstanceArrayList;
    private HashMap<GeofenceInstance, Polygon> geofenceInstancePolygons;
    private HashMap<MovingObject, ArrayList<GeofenceInstance>> watchedMovingObjects;

    public GeofenceKit(@NonNull JCore core, @NonNull JController controller) {
        this.core = core;
        this.controller = controller;
        this.watchedMovingObjects = new HashMap();
        this.geofenceInstancePolygons = new HashMap();
    }

    public synchronized void drawPolygonsOfGeofence(@NonNull Geofence geofence, @Nullable Map map, @Nullable JStyle style) {
        if (geofence == null) {
            return;
        }
        if (style == null) {
            style = new JStyle();
            try {
                String BLACK_HEX_COLOR = "#000000";
                style.setColor(Color.parseColor((String)(geofence.getColor() != null ? geofence.getColor() : BLACK_HEX_COLOR)));
            }
            catch (IllegalArgumentException iae) {
                style.setColor(-16777216);
            }
        }
        for (GeofenceInstance geofenceInstance : geofence.getGeofenceInstances()) {
            if (map != null && geofenceInstance.getFloor().getMap().getId() != map.getId()) continue;
            this.drawPolygonOfGeofenceInstance(geofenceInstance, style);
        }
    }

    public synchronized void drawPolygonOfGeofenceInstance(@NonNull GeofenceInstance geofenceInstance, @Nullable JStyle style) {
        JShapeDrawable[] geofenceShapes;
        if (geofenceInstance == null) {
            return;
        }
        if (style == null) {
            style = new JStyle();
            try {
                String BLACK_HEX_COLOR = "#000000";
                style.setColor(Color.parseColor((String)(geofenceInstance.parent.getColor() != null ? geofenceInstance.parent.getColor() : BLACK_HEX_COLOR)));
            }
            catch (IllegalArgumentException iae) {
                style.setColor(-16777216);
            }
        }
        String geofenceInstanceId = geofenceInstance.floor.getMap().id + "0" + geofenceInstance.id;
        for (JShapeDrawable geofenceShape : geofenceShapes = this.controller.getShapesInLayer(LAYER_GEOFENCES, geofenceInstance.floor.getMap())) {
            if (geofenceShape.getId() != Integer.valueOf(geofenceInstanceId).intValue()) continue;
            geofenceShape.setStyle(style);
            return;
        }
        Polygon geofencePolygon = this.getPolygonOfGeofenceInstance(geofenceInstance);
        if (geofencePolygon != null) {
            Path polygonPath = geofencePolygon.getPolygonPath();
            this.controller.drawShapeOnMap(polygonPath, geofenceInstance.floor.getMap(), style, Integer.valueOf(geofenceInstanceId).intValue(), geofenceInstance.name, LAYER_GEOFENCES);
        }
    }

    public synchronized void removePolygonsOfGeofence(@NonNull Geofence geofence, @Nullable Map map) {
        if (geofence == null) {
            return;
        }
        for (GeofenceInstance geofenceInstance : geofence.getGeofenceInstances()) {
            if (map != null && geofenceInstance.getFloor().getMap().getId() != map.getId()) continue;
            this.removePolygonOfGeofenceInstance(geofenceInstance);
        }
    }

    public synchronized void removePolygonOfGeofenceInstance(@NonNull GeofenceInstance geofenceInstance) {
        if (geofenceInstance == null) {
            return;
        }
        String geofenceInstanceId = geofenceInstance.floor.getMap().id + "0" + geofenceInstance.id;
        for (MapDrawable mapDrawable : this.controller.getMapDrawables()) {
            MapLayer geofenceMapLayer = mapDrawable.getMapLayer(LAYER_GEOFENCES);
            if (geofenceMapLayer == null) continue;
            for (JShapeDrawable shapeDrawable : geofenceMapLayer.getShapeDrawables()) {
                if (shapeDrawable.getId() != Integer.valueOf(geofenceInstanceId).intValue()) continue;
                geofenceMapLayer.removeComponent((Object)shapeDrawable);
                return;
            }
        }
    }

    public synchronized RectF getBoundsOfGeofenceOnMap(@NonNull Geofence geofence, @NonNull Map map) {
        RectF bounds = new RectF();
        if (geofence != null && map != null) {
            for (GeofenceInstance geofenceInstance : geofence.getGeofenceInstances()) {
                if (geofenceInstance.getFloor().getMap().getId() != map.getId()) continue;
                if (bounds.isEmpty()) {
                    bounds = geofenceInstance.getBounds();
                    continue;
                }
                bounds.union(geofenceInstance.getBounds());
            }
        }
        return bounds;
    }

    public synchronized Polygon[] getPolygonsOfGeofenceOnMap(@NonNull Geofence geofence, @NonNull Map map) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        if (geofence != null && map != null) {
            for (GeofenceInstance geofenceInstance : geofence.getGeofenceInstances()) {
                Polygon polygon;
                if (geofenceInstance.getFloor().getMap().getId() != map.getId() || (polygon = this.getPolygonOfGeofenceInstance(geofenceInstance)) == null) continue;
                polygons.add(polygon);
            }
        }
        return polygons.toArray(new Polygon[polygons.size()]);
    }

    public synchronized void watchMovingObject(final @NonNull MovingObject movingObject, final @NonNull OnMovingObjectListener onMovingObjectListener) {
        if (movingObject == null || onMovingObjectListener == null) {
            return;
        }
        if (!this.watchedMovingObjects.containsKey(movingObject)) {
            this.watchedMovingObjects.put(movingObject, new ArrayList());
        }
        this.geofenceInstanceArrayList = this.watchedMovingObjects.get(movingObject);
        movingObject.setWatchMovingObjectCallback(new MovingObject.MovingObjectCallback(){

            public void onLocationChanged(PointF location) {
            }

            public void onAnimationComplete(PointF location) {
                GeofenceInstance[] geofenceInstancesExited;
                GeofenceInstance[] geofencesInstancesEntered = this.getGeofenceInstancesEntered(movingObject, location);
                if (geofencesInstancesEntered.length > 0) {
                    onMovingObjectListener.onEnteredGeofence(movingObject, geofencesInstancesEntered);
                }
                if ((geofenceInstancesExited = this.getGeofenceInstancesExited(movingObject, location)).length > 0) {
                    onMovingObjectListener.onExitedGeofence(movingObject, geofenceInstancesExited);
                }
            }

            private GeofenceInstance[] getGeofenceInstancesEntered(MovingObject movingObject2, PointF location) {
                ArrayList<GeofenceInstance> geofenceInstances = new ArrayList<GeofenceInstance>();
                block0: for (Geofence geofence : GeofenceKit.this.geofenceCollection.getAll()) {
                    for (GeofenceInstance geofenceInstance : geofence.getGeofenceInstances()) {
                        Polygon polygon;
                        if (GeofenceKit.this.geofenceInstanceArrayList.contains(geofenceInstance) || geofenceInstance.getFloor().getMap().getId() != movingObject2.getMapId() || (polygon = geofenceInstance.getPolygon()) == null || !polygon.contains(location.x, location.y)) continue;
                        geofenceInstances.add(geofenceInstance);
                        continue block0;
                    }
                }
                GeofenceKit.this.geofenceInstanceArrayList.addAll(geofenceInstances);
                return geofenceInstances.toArray(new GeofenceInstance[geofenceInstances.size()]);
            }

            private GeofenceInstance[] getGeofenceInstancesExited(MovingObject movingObject2, PointF location) {
                ArrayList<GeofenceInstance> geofenceInstances = new ArrayList<GeofenceInstance>();
                for (Geofence geofence : GeofenceKit.this.geofenceCollection.getAll()) {
                    for (GeofenceInstance geofenceInstance : geofence.getGeofenceInstances()) {
                        Polygon polygon;
                        if (!GeofenceKit.this.geofenceInstanceArrayList.contains(geofenceInstance) || geofenceInstance.getFloor().getMap().getId() != movingObject2.getMapId() || (polygon = geofenceInstance.getPolygon()) == null || polygon.contains(location.x, location.y)) continue;
                        geofenceInstances.add(geofenceInstance);
                    }
                }
                GeofenceKit.this.geofenceInstanceArrayList.removeAll(geofenceInstances);
                return geofenceInstances.toArray(new GeofenceInstance[geofenceInstances.size()]);
            }
        });
    }

    public synchronized void unwatchMovingObjects() {
        for (MapDrawable mapDrawable : this.controller.getMapDrawables()) {
            for (MapLayer mapLayer : mapDrawable.getAllMapLayers()) {
                for (MovingObject movingObject : mapLayer.getMovingObjects()) {
                    this.watchedMovingObjects.remove(movingObject);
                    movingObject.setWatchMovingObjectCallback(null);
                }
            }
        }
    }

    public GeofenceInstance[] getGeofenceInstancesByPoint(@NonNull PointF point) {
        ArrayList<GeofenceInstance> geofenceInstanceArrayList = new ArrayList<GeofenceInstance>();
        for (Geofence geofence : this.geofenceCollection.getAll()) {
            for (GeofenceInstance geofenceInstance : geofence.getGeofenceInstances()) {
                if (!geofenceInstance.getPolygon().contains(point.x, point.y) || geofenceInstance.floor.getMap().getId() != this.controller.getCurrentMap().getId()) continue;
                geofenceInstanceArrayList.add(geofenceInstance);
            }
        }
        return geofenceInstanceArrayList.toArray(new GeofenceInstance[geofenceInstanceArrayList.size()]);
    }

    public GeofenceInstance[] getGeofenceInstancesByWaypoint(@NonNull Waypoint waypoint) {
        Float[] coordinates = waypoint.getCoordinates();
        return this.getGeofenceInstancesByPoint(new PointF(coordinates[0].floatValue(), coordinates[1].floatValue()));
    }

    public Waypoint[] getWaypointsInGeofenceInstance(@NonNull GeofenceInstance geofenceInstance) {
        ArrayList<Waypoint> waypointArrayList = new ArrayList<Waypoint>();
        Map map = this.controller.getActiveVenue().getMaps().getById(geofenceInstance.getFloor().getMap().getId());
        for (Waypoint waypoint : map.getWaypoints().getAll()) {
            if (waypointArrayList.contains(waypoint) || !geofenceInstance.getPolygon().contains(waypoint.getCoordinates()[0].floatValue(), waypoint.getCoordinates()[1].floatValue())) continue;
            waypointArrayList.add(waypoint);
        }
        return waypointArrayList.toArray(new Waypoint[waypointArrayList.size()]);
    }

    public Waypoint[] getWaypointsInGeofence(@NonNull Geofence geofence, @Nullable Map map) {
        ArrayList<Waypoint> waypointArrayList = new ArrayList<Waypoint>();
        for (GeofenceInstance geofenceInstance : geofence.getGeofenceInstances()) {
            if (map != null && map.getId() != geofenceInstance.getFloor().getMap().getId()) continue;
            for (Waypoint waypoint : this.getWaypointsInGeofenceInstance(geofenceInstance)) {
                if (waypointArrayList.contains(waypoint) || !geofenceInstance.getPolygon().contains(waypoint.getCoordinates()[0].floatValue(), waypoint.getCoordinates()[1].floatValue())) continue;
                waypointArrayList.add(waypoint);
            }
        }
        return waypointArrayList.toArray(new Waypoint[waypointArrayList.size()]);
    }

    public Destination[] getDestinationsInGeofenceInstance(@NonNull GeofenceInstance geofenceInstance) {
        Destination[] destinations;
        ArrayList<Destination> destinationArrayList = new ArrayList<Destination>();
        block0: for (Destination destination : destinations = this.controller.getActiveVenue().getDestinations().getByMap(geofenceInstance.getFloor().getMap())) {
            for (Waypoint waypoint : destination.getWaypoints()) {
                if (destinationArrayList.contains(destination) || !geofenceInstance.getPolygon().contains(waypoint.getCoordinates()[0].floatValue(), waypoint.getCoordinates()[1].floatValue())) continue;
                destinationArrayList.add(destination);
                continue block0;
            }
        }
        return destinationArrayList.toArray(new Destination[destinationArrayList.size()]);
    }

    public Destination[] getDestinationsInGeofence(@NonNull Geofence geofence, @Nullable Map map) {
        ArrayList<Destination> destinationArrayList = new ArrayList<Destination>();
        for (GeofenceInstance geofenceInstance : geofence.getGeofenceInstances()) {
            Destination[] destinations;
            if (map != null && map.getId() != geofenceInstance.getFloor().getMap().getId()) continue;
            block1: for (Destination destination : destinations = this.controller.getActiveVenue().getDestinations().getByMap(geofenceInstance.getFloor().getMap())) {
                for (Waypoint waypoint : destination.getWaypoints()) {
                    if (destinationArrayList.contains(destination) || !geofenceInstance.getPolygon().contains(waypoint.getCoordinates()[0].floatValue(), waypoint.getCoordinates()[1].floatValue())) continue;
                    destinationArrayList.add(destination);
                    continue block1;
                }
            }
        }
        return destinationArrayList.toArray(new Destination[destinationArrayList.size()]);
    }

    public Amenity[] getAmenitiesInGeofenceInstance(@NonNull GeofenceInstance geofenceInstance) {
        Amenity[] amenities;
        ArrayList<Amenity> amenityArrayList = new ArrayList<Amenity>();
        block0: for (Amenity amenity : amenities = this.controller.getActiveVenue().getAmenities().getByMap(geofenceInstance.getFloor().getMap())) {
            for (Waypoint waypoint : amenity.getWaypoints()) {
                if (amenityArrayList.contains(amenity) || !geofenceInstance.getPolygon().contains(waypoint.getCoordinates()[0].floatValue(), waypoint.getCoordinates()[1].floatValue())) continue;
                amenityArrayList.add(amenity);
                continue block0;
            }
        }
        return amenityArrayList.toArray(new Amenity[amenityArrayList.size()]);
    }

    public Amenity[] getAmenitiesInGeofence(@NonNull Geofence geofence, @Nullable Map map) {
        ArrayList<Amenity> amenityArrayList = new ArrayList<Amenity>();
        for (GeofenceInstance geofenceInstance : geofence.getGeofenceInstances()) {
            Amenity[] amenities;
            if (map != null && map.getId() != geofenceInstance.getFloor().getMap().getId()) continue;
            block1: for (Amenity amenity : amenities = this.controller.getActiveVenue().getAmenities().getByMap(geofenceInstance.getFloor().getMap())) {
                for (Waypoint waypoint : amenity.getWaypoints()) {
                    if (amenityArrayList.contains(amenity) || !geofenceInstance.getPolygon().contains(waypoint.getCoordinates()[0].floatValue(), waypoint.getCoordinates()[1].floatValue())) continue;
                    amenityArrayList.add(amenity);
                    continue block1;
                }
            }
        }
        return amenityArrayList.toArray(new Amenity[amenityArrayList.size()]);
    }

    public PathType[] getPathTypesInGeofenceInstance(@NonNull GeofenceInstance geofenceInstance) {
        PathType[] pathTypes;
        ArrayList<PathType> pathTypeArrayList = new ArrayList<PathType>();
        block0: for (PathType pathType : pathTypes = this.controller.getActiveVenue().getPathTypes().getByMap(geofenceInstance.getFloor().getMap())) {
            for (Waypoint waypoint : pathType.getWaypoints()) {
                if (pathTypeArrayList.contains(pathType) || !geofenceInstance.getPolygon().contains(waypoint.getCoordinates()[0].floatValue(), waypoint.getCoordinates()[1].floatValue())) continue;
                pathTypeArrayList.add(pathType);
                continue block0;
            }
        }
        return pathTypeArrayList.toArray(new PathType[pathTypeArrayList.size()]);
    }

    public PathType[] getPathTypesInGeofence(@NonNull Geofence geofence, @Nullable Map map) {
        ArrayList<PathType> pathTypeArrayList = new ArrayList<PathType>();
        for (GeofenceInstance geofenceInstance : geofence.getGeofenceInstances()) {
            PathType[] pathTypes;
            if (map != null && map.getId() != geofenceInstance.getFloor().getMap().getId()) continue;
            block1: for (PathType pathType : pathTypes = this.controller.getActiveVenue().getPathTypes().getByMap(geofenceInstance.getFloor().getMap())) {
                for (Waypoint waypoint : pathType.getWaypoints()) {
                    if (pathTypeArrayList.contains(pathType) || !geofenceInstance.getPolygon().contains(waypoint.getCoordinates()[0].floatValue(), waypoint.getCoordinates()[1].floatValue())) continue;
                    pathTypeArrayList.add(pathType);
                    continue block1;
                }
            }
        }
        return pathTypeArrayList.toArray(new PathType[pathTypeArrayList.size()]);
    }

    public MovingObject[] getMovingObjectsInGeofenceInstance(@NonNull GeofenceInstance geofenceInstance) {
        ArrayList allMovingObjects = new ArrayList();
        for (MapDrawable mapDrawable : this.controller.getMapDrawables()) {
            if (mapDrawable.getId() != geofenceInstance.getFloor().getMap().getId()) continue;
            for (MapLayer mapLayer : mapDrawable.getAllMapLayers()) {
                allMovingObjects.addAll(mapLayer.getMovingObjects());
            }
        }
        ArrayList<MovingObject> movingObjectArrayList = new ArrayList<MovingObject>();
        for (MovingObject movingObject : allMovingObjects) {
            if (!geofenceInstance.getPolygon().contains(movingObject.getX(), movingObject.getY())) continue;
            movingObjectArrayList.add(movingObject);
        }
        return movingObjectArrayList.toArray(new MovingObject[movingObjectArrayList.size()]);
    }

    public MovingObject[] getMovingObjectsInGeofence(@NonNull Geofence geofence, @Nullable Map map) {
        ArrayList<MovingObject> movingObjectArrayList = new ArrayList<MovingObject>();
        for (GeofenceInstance geofenceInstance : geofence.getGeofenceInstances()) {
            if (map != null && map.getId() != geofenceInstance.getFloor().getMap().getId()) continue;
            movingObjectArrayList.addAll(Arrays.asList(this.getMovingObjectsInGeofenceInstance(geofenceInstance)));
        }
        return movingObjectArrayList.toArray(new MovingObject[movingObjectArrayList.size()]);
    }

    public Waypoint getClosestWaypointInGeofenceInstance(@NonNull PointF point, @NonNull GeofenceInstance geofenceInstance) {
        Waypoint[] waypoints = this.getWaypointsInGeofenceInstance(geofenceInstance);
        return this.getClosestWaypointFromPoint(point, waypoints);
    }

    public Waypoint getClosestWaypointInGeofence(@NonNull PointF point, @NonNull Geofence geofence, @Nullable Map map) {
        Waypoint[] waypoints = this.getWaypointsInGeofence(geofence, map);
        return this.getClosestWaypointFromPoint(point, waypoints);
    }

    public synchronized void getGeofences(final @NonNull OnGeofencesReadyCallback onGeofencesReadyCallback) {
        if (onGeofencesReadyCallback == null) {
            Log.e((String)"JMap Error", (String)"Callback cannot be null. Please pass a valid callback object and try again.");
            return;
        }
        String url = this.getGeofenceParentsCallUrl(this.core.getHostUrl(), this.core.getCustomerId(), this.controller.getActiveVenue().getId());
        this.core.getRequest(url, new HttpClient.DownloadCallbacks(){

            public void onSuccess(String response) {
                Gson gson = new GsonBuilder().serializeNulls().create();
                String regex = "\\{\"items\":.*]\\}";
                Pattern pattern = Pattern.compile("\\{\"items\":.*]\\}");
                Matcher matcher = pattern.matcher(response);
                matcher.find();
                String geofenceParentsResponse = matcher.group(0);
                GeofenceKit.this.geofenceCollection = (GeofenceCollection)gson.fromJson(geofenceParentsResponse, GeofenceCollection.class);
                String url = GeofenceKit.this.getGeofenceInstancesCallUrl(GeofenceKit.this.core.getHostUrl(), GeofenceKit.this.core.getCustomerId(), GeofenceKit.this.controller.getActiveVenue().getId());
                GeofenceKit.this.core.getRequest(url, new HttpClient.DownloadCallbacks(){

                    public void onSuccess(String response) {
                        Gson gson = new GsonBuilder().serializeNulls().create();
                        GeofenceInstancesResponse geofenceInstancesResponse = (GeofenceInstancesResponse)gson.fromJson(response, GeofenceInstancesResponse.class);
                        for (GeofenceInstancesResponse.Feature feature : geofenceInstancesResponse.features) {
                            Geofence geofence = GeofenceKit.this.geofenceCollection.getById(feature.properties.parent.id);
                            if (geofence == null) continue;
                            geofence.addInstance(feature, GeofenceKit.this.controller.getActiveVenue());
                        }
                        onGeofencesReadyCallback.onSuccess(GeofenceKit.this.geofenceCollection);
                    }

                    public void onError(String message) {
                        onGeofencesReadyCallback.onError(message);
                    }
                });
            }

            public void onError(String message) {
                onGeofencesReadyCallback.onError(message);
            }
        });
    }

    public synchronized GeofenceInstance getGeofenceInstanceByIdWithMapId(int geofenceInstanceId, int mapId) {
        Map map = this.controller.getActiveVenue().getMaps().getById(mapId);
        if (map == null) {
            return null;
        }
        for (Geofence geofence : this.geofenceCollection.getAll()) {
            for (GeofenceInstance geofenceInstance : geofence.getGeofenceInstances()) {
                if (geofenceInstance.getId() != geofenceInstanceId || geofenceInstance.floor.getMap().getId() != mapId) continue;
                return geofenceInstance;
            }
        }
        return null;
    }

    private String getGeofenceParentsCallUrl(String url, int customerId, int venueId) {
        return url + "/JACS/api/customer/" + customerId + "/venue/" + venueId + "/geofence/full";
    }

    private String getGeofenceInstancesCallUrl(String url, int customerId, int venueId) {
        return url + "/JACS/api/customer/" + customerId + "/venue/" + venueId + "/geofence-instance/full";
    }

    private Polygon getPolygonOfGeofenceInstance(GeofenceInstance geofenceInstance) {
        return this.geofenceInstancePolygons.containsKey(geofenceInstance) ? this.geofenceInstancePolygons.get(geofenceInstance) : geofenceInstance.getPolygon();
    }

    private Waypoint getClosestWaypointFromPoint(PointF point, Waypoint[] waypoints) {
        Waypoint waypoint = this.controller.getActiveVenue().getClosestWaypointToCoordinate(point);
        return this.controller.getActiveVenue().getClosestWaypointInArrayToWaypoint(waypoint, waypoints);
    }

    public static interface OnMovingObjectListener {
        public void onEnteredGeofence(MovingObject var1, GeofenceInstance[] var2);

        public void onExitedGeofence(MovingObject var1, GeofenceInstance[] var2);
    }

    public static interface OnGeofencesReadyCallback {
        public void onSuccess(GeofenceCollection var1);

        public void onError(String var1);
    }
}

