/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.geofencekit;

import android.graphics.RectF;
import com.jibestream.geofencekit.Geofence;
import com.jibestream.jmapandroidsdk.components.Floor;
import com.jibestream.jmapandroidsdk.main.PointD;
import com.jibestream.jmapandroidsdk.main.Polygon;
import com.jibestream.jmapandroidsdk.main.Utilities;
import java.util.ArrayList;

public class GeofenceInstance {
    int id;
    double[][][] coordinates;
    double[][][] localCoordinates;
    String name;
    Floor floor;
    Geofence parent;

    public Geofence getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public Floor getFloor() {
        return this.floor;
    }

    public PointD getCentroid() {
        Polygon polygon = this.getPolygon();
        return Utilities.getCentroidOfPolygon((Polygon)polygon);
    }

    public RectF getBounds() {
        RectF bounds = new RectF();
        Polygon polygon = this.getPolygon();
        polygon.getPolygonPath().computeBounds(bounds, true);
        return bounds;
    }

    public Polygon getPolygon() {
        return Utilities.getPolygonFromPoints((PointD[])this.getLocalCoordinatePoints());
    }

    public double[][] getCoordinates() {
        Object c = new double[][]{};
        int i = 0;
        for (double[][] c1 : this.coordinates) {
            c = new double[c1.length][2];
            for (double[] c2 : c1) {
                c[i][0] = c2[0];
                c[i][1] = c2[1];
                ++i;
            }
        }
        return c;
    }

    public double[][] getLocalCoordinates() {
        Object lc = new double[][]{};
        int i = 0;
        for (double[][] c1 : this.localCoordinates) {
            lc = new double[c1.length][2];
            for (double[] c2 : c1) {
                lc[i][0] = c2[0];
                lc[i][1] = c2[1];
                ++i;
            }
        }
        return lc;
    }

    PointD[] getLocalCoordinatePoints() {
        ArrayList<PointD> lcp = new ArrayList<PointD>();
        double[][][] dArray = this.localCoordinates;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[][] c1;
            for (double[] c2 : c1 = dArray[i]) {
                lcp.add(new PointD(c2[0], c2[1]));
            }
        }
        return lcp.toArray(new PointD[lcp.size()]);
    }
}

