/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.geofencekit;

import com.jibestream.geofencekit.Geofence;
import com.jibestream.geofencekit.GeofenceInstance;
import com.jibestream.jmapandroidsdk.collections.BaseCollection;
import com.jibestream.jmapandroidsdk.components.Map;
import java.util.ArrayList;

public class GeofenceCollection
implements BaseCollection {
    private Geofence[] items;

    public Geofence[] getByName(String name) {
        if (name == null || name.isEmpty()) {
            return new Geofence[0];
        }
        ArrayList<Geofence> geofenceArrayList = new ArrayList<Geofence>();
        for (Geofence geofence : this.getAll()) {
            if (!geofence.getName().equalsIgnoreCase(name)) continue;
            geofenceArrayList.add(geofence);
        }
        return geofenceArrayList.toArray(new Geofence[geofenceArrayList.size()]);
    }

    public Geofence[] getByMap(Map map) {
        if (map == null) {
            return null;
        }
        ArrayList<Geofence> geofenceArrayList = new ArrayList<Geofence>();
        for (Geofence geofence : this.items) {
            for (GeofenceInstance geofenceInstance : geofence.getGeofenceInstances()) {
                if (map.getId() != geofenceInstance.getFloor().getMap().getId()) continue;
                geofenceArrayList.add(geofence);
            }
        }
        return geofenceArrayList.toArray(new Geofence[geofenceArrayList.size()]);
    }

    public int getCount() {
        return this.getAll().length;
    }

    public Geofence[] getAll() {
        if (this.items != null) {
            return this.items;
        }
        return new Geofence[0];
    }

    public Geofence[] getByExternalId(String externalId) {
        if (externalId == null || externalId.isEmpty()) {
            return new Geofence[0];
        }
        ArrayList<Geofence> geofenceArrayList = new ArrayList<Geofence>();
        for (Geofence geofence : this.getAll()) {
            if (geofence.getExternalId() == null || !geofence.getExternalId().equalsIgnoreCase(externalId)) continue;
            geofenceArrayList.add(geofence);
        }
        return geofenceArrayList.toArray(new Geofence[geofenceArrayList.size()]);
    }

    public Geofence getById(int id) {
        for (Geofence geofence : this.getAll()) {
            if (geofence.getId() != id) continue;
            return geofence;
        }
        return null;
    }
}

