/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.geofencekit;

import com.jibestream.geofencekit.GeofenceInstance;
import com.jibestream.geofencekit.GeofenceInstancesResponse;
import com.jibestream.jmapandroidsdk.components.ActiveVenue;
import com.jibestream.jmapandroidsdk.components.BaseModel;
import com.jibestream.jmapandroidsdk.main.PointD;
import com.jibestream.jmapandroidsdk.main.Utilities;
import java.util.ArrayList;
import java.util.Arrays;

public class Geofence
extends BaseModel {
    private String name;
    private String color;
    private GeofenceInstance[] geofenceInstances = new GeofenceInstance[0];

    public String getName() {
        return this.name;
    }

    public String getColor() {
        return this.color;
    }

    public GeofenceInstance[] getGeofenceInstances() {
        return this.geofenceInstances;
    }

    void addInstance(GeofenceInstancesResponse.Feature feature, ActiveVenue activeVenue) {
        ArrayList<GeofenceInstance> geofenceInstanceArrayList = new ArrayList<GeofenceInstance>(Arrays.asList(this.geofenceInstances));
        GeofenceInstance geofenceInstance = new GeofenceInstance();
        geofenceInstance.parent = this;
        geofenceInstance.id = feature.properties.instanceId;
        geofenceInstance.name = feature.properties.instanceName;
        double[][][] coordinates = feature.geometry.coordinates;
        for (int i = 0; i < coordinates.length; ++i) {
            geofenceInstance.localCoordinates = new double[coordinates.length][coordinates[i].length][2];
            for (int j = 0; j < coordinates[i].length; ++j) {
                double[] coordinate = coordinates[i][j];
                PointD point = new PointD(coordinate[0], coordinate[1]);
                Utilities.convertCoordinate((PointD)point, (String)"EPSG:4326", (String)"jmap:local", (ActiveVenue)activeVenue);
                geofenceInstance.localCoordinates[i][j][0] = point.x;
                geofenceInstance.localCoordinates[i][j][1] = point.y;
            }
        }
        geofenceInstance.coordinates = feature.geometry.coordinates;
        geofenceInstance.floor = activeVenue.getBuildings().getById(feature.properties.buildingId).getFloors().getById(feature.properties.floorId);
        geofenceInstanceArrayList.add(geofenceInstance);
        this.geofenceInstances = geofenceInstanceArrayList.toArray(new GeofenceInstance[geofenceInstanceArrayList.size()]);
    }
}

