package com.jibestream.geofencekit;

import com.jibestream.jmapandroidsdk.collections.BaseCollection;
import com.jibestream.jmapandroidsdk.components.Map;

import java.util.ArrayList;

/**
 * Created by Ken Pangilinan on 2018-02-26.
 */

public class GeofenceCollection implements BaseCollection {
    private Geofence[] items;

    public Geofence[] getByName(String name) {
        if (name == null || name.isEmpty()) {
            return new Geofence[0];
        }

        ArrayList<Geofence> geofenceArrayList = new ArrayList<>();
        for (Geofence geofence : getAll()) {
            if (geofence.getName().equalsIgnoreCase(name)) {
                geofenceArrayList.add(geofence);
            }
        }
        return geofenceArrayList.toArray(new Geofence[geofenceArrayList.size()]);
    }

    public Geofence[] getByMap(Map map) {
        if (map == null) {
            return null;
        }
        ArrayList<Geofence> geofenceArrayList = new ArrayList<>();
        for (Geofence geofence : items) {
            for (GeofenceInstance geofenceInstance : geofence.getGeofenceInstances()) {
                if (map.getId() == geofenceInstance.getFloor().getMap().getId()) {
                    geofenceArrayList.add(geofence);
                }
            }
        }
        return geofenceArrayList.toArray(new Geofence[geofenceArrayList.size()]);
    }

    @Override
    public int getCount() {
        return getAll().length;
    }

    @Override
    public Geofence[] getAll() {
        if (items != null) {
            return items;
        } else {
            return new Geofence[0];
        }
    }

    @Override
    public Geofence[] getByExternalId(String externalId) {
        if (externalId == null || externalId.isEmpty()) {
            return new Geofence[0];
        }

        ArrayList<Geofence> geofenceArrayList = new ArrayList<>();
        for (Geofence geofence : getAll()) {
            if (geofence.getExternalId() != null && geofence.getExternalId().equalsIgnoreCase(externalId)) {
                geofenceArrayList.add(geofence);
            }
        }
        return geofenceArrayList.toArray(new Geofence[geofenceArrayList.size()]);
    }

    @Override
    public Geofence getById(int id) {
        for (Geofence geofence : getAll()) {
            if (geofence.getId() == id) {
                return geofence;
            }
        }
        return null;
    }
}
