package com.jibestream.geofencekit;

import android.graphics.PointF;

import com.jibestream.jmapandroidsdk.components.ActiveVenue;
import com.jibestream.jmapandroidsdk.components.BaseModel;
import com.jibestream.jmapandroidsdk.main.PointD;
import com.jibestream.jmapandroidsdk.main.Utilities;

import java.util.ArrayList;
import java.util.Arrays;

/**
 * Created by Ken Pangilinan on 2018-02-26.
 */

public class Geofence extends BaseModel {
    private String name;
    private String color;
    private GeofenceInstance[] geofenceInstances = new GeofenceInstance[0];

    /**
     * @return Name of geofence. ie. "Food Court"
     */
    public String getName() {
        return name;
    }

    /**
     * @return Color of geofence. ie. "#B00B00"
     */
    public String getColor() {
        return color;
    }

    /**
     * @return Array of geofence instances associated to the geofence.
     */
    public GeofenceInstance[] getGeofenceInstances() {
        return geofenceInstances;
    }

    void addInstance(GeofenceInstancesResponse.Feature feature, ActiveVenue activeVenue) {
        ArrayList<GeofenceInstance> geofenceInstanceArrayList = new ArrayList<>(Arrays.asList(geofenceInstances));

        GeofenceInstance geofenceInstance = new GeofenceInstance();
        geofenceInstance.parent = this;
        geofenceInstance.id = feature.properties.instanceId;
        geofenceInstance.name = feature.properties.instanceName;

        double[][][] coordinates = feature.geometry.coordinates;
        for (int i = 0; i < coordinates.length; i++) {
            geofenceInstance.localCoordinates = new double[coordinates.length][coordinates[i].length][2];
            for (int j = 0; j < coordinates[i].length; j++) {
                double[] coordinate = coordinates[i][j];
                PointD point = new PointD(coordinate[0], coordinate[1]);
                Utilities.convertCoordinate(point,
                        Utilities.PROJ_EPSG_4326, Utilities.PROJ_JMAP_LOCAL, activeVenue);
                geofenceInstance.localCoordinates[i][j][0] = point.x;
                geofenceInstance.localCoordinates[i][j][1] = point.y;
            }
        }

        geofenceInstance.coordinates = feature.geometry.coordinates;
        geofenceInstance.floor = activeVenue.getBuildings().getById(feature.properties.buildingId)
                .getFloors().getById(feature.properties.floorId);

        geofenceInstanceArrayList.add(geofenceInstance);

        geofenceInstances = geofenceInstanceArrayList.toArray(new GeofenceInstance[geofenceInstanceArrayList.size()]);
    }
}
