/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.assetkit;

import android.graphics.PointF;
import android.os.Handler;
import android.util.Log;
import android.util.SparseArray;
import com.jibestream.assetkit.Asset;
import com.jibestream.jmapandroidsdk.astar.ASNode;
import com.jibestream.jmapandroidsdk.astar.PathPerFloor;
import com.jibestream.jmapandroidsdk.astar.Point;
import com.jibestream.jmapandroidsdk.components.Map;
import com.jibestream.jmapandroidsdk.components.Waypoint;
import com.jibestream.jmapandroidsdk.jcontroller.JController;
import com.jibestream.jmapandroidsdk.rendering_engine.moving_objects.MovingObject;
import com.jibestream.jmapandroidsdk.rendering_engine.moving_objects.UserLocation;
import java.util.ArrayList;
import java.util.Iterator;

public class AssetKit {
    private SparseArray<Asset> assets = new SparseArray();
    private JController controller;
    private Asset wayfindingAsset;
    private int rerouteInterval;
    private Runnable autoRerouteRunnable;
    private Handler handler;

    public AssetKit(JController controller) {
        this.controller = controller;
        this.rerouteInterval = 0;
        this.handler = new Handler();
    }

    public void updateAssetWithPosition(Asset assetToUpdate, PointF position, Map map) {
        Asset asset = this.getAssetById(assetToUpdate.getId());
        PointF newPosition = new PointF(position.x, position.y);
        if (asset == null) {
            this.controller.addMovingObject((MovingObject)assetToUpdate, map, newPosition, "Moving-Objects");
            this.assets.append(assetToUpdate.getId(), (Object)assetToUpdate);
        } else {
            if (asset != assetToUpdate) {
                Log.i((String)"AssetKit", (String)("Attempted to add asset with duplicate ID: " + asset.getId()));
                return;
            }
            this.controller.updateMovingObject((MovingObject)assetToUpdate, map, newPosition, true);
        }
    }

    public Asset getNearestAssetOfTypeToPoint(String type, Point point) {
        Asset closestAsset = null;
        float closestDistance = Float.MAX_VALUE;
        for (Asset asset : this.getAssetsByType(type)) {
            float distance;
            if (asset.getMapId() != (int)point.z || !asset.getType().equals(type) || !((distance = this.distanceBetweenPoints(new PointF((float)point.x, (float)point.y), asset.getPosition())) < closestDistance)) continue;
            closestDistance = distance;
            closestAsset = asset;
        }
        return closestAsset;
    }

    public void showAssetOfType(String type) {
        for (int i = 0; i < this.assets.size(); ++i) {
            if (!((Asset)((Object)this.assets.valueAt(i))).getType().equalsIgnoreCase(type)) continue;
            ((Asset)((Object)this.assets.valueAt(i))).setVisible(true);
        }
    }

    public void hideAssetOfType(String type) {
        for (int i = 0; i < this.assets.size(); ++i) {
            if (!((Asset)((Object)this.assets.valueAt(i))).getType().equalsIgnoreCase(type)) continue;
            ((Asset)((Object)this.assets.valueAt(i))).setVisible(false);
        }
    }

    public void removeAsset(Asset asset) {
        this.assets.remove(asset.getId());
    }

    public Asset getAssetById(int id) {
        return (Asset)((Object)this.assets.get(id));
    }

    public Asset[] getAssetsByType(String type) {
        ArrayList<Object> assetArrayList = new ArrayList<Object>();
        for (int i = 0; i < this.assets.size(); ++i) {
            if (!((Asset)((Object)this.assets.valueAt(i))).getType().equalsIgnoreCase(type)) continue;
            assetArrayList.add(this.assets.valueAt(i));
        }
        return assetArrayList.toArray(new Asset[assetArrayList.size()]);
    }

    public void clearWayfindingPath() {
        this.rerouteInterval = 0;
        this.wayfindingAsset = null;
        this.controller.clearWayfindingPath();
    }

    public void wayfindToAssetFromPoint(Asset asset, Point point) {
        this.wayfindingAsset = asset;
        Point assetPoint = new Point((double)asset.getX(), (double)asset.getY(), (double)asset.getMapId());
        Waypoint fromWp = this.controller.getNearestWaypointToPoint(point);
        Waypoint toWp = this.controller.getNearestWaypointToPoint(assetPoint);
        this.controller.clearWayfindingPath();
        if (fromWp != null && toWp != null) {
            PathPerFloor[] pathsPerFloor = this.controller.wayfindBetweenWaypoints(fromWp, toWp);
            this.controller.drawWayfindingPath(pathsPerFloor);
        } else if (fromWp == null) {
            Log.d((String)"assetkit", (String)"Unable to get nearest waypoint to point.");
        } else {
            Log.d((String)"assetkit", (String)"Unable to get nearest waypoint to asset.");
        }
    }

    public void wayfindFromUserLocationToAssetWithAutoReroute(final Asset asset, final int rerouteInterval) {
        this.rerouteInterval = rerouteInterval > 0 ? rerouteInterval : 0;
        this.controller.clearWayfindingPath();
        Point userPoint = new Point((double)UserLocation.getInstance().getPosition().x, (double)UserLocation.getInstance().getPosition().y, (double)UserLocation.getInstance().getMapId());
        this.wayfindToAssetFromPoint(asset, userPoint);
        if (this.rerouteInterval >= 0) {
            this.autoRerouteRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        AssetKit.this.controller.clearWayfindingPath();
                        Point userPoint = new Point((double)UserLocation.getInstance().getPosition().x, (double)UserLocation.getInstance().getPosition().y, (double)UserLocation.getInstance().getMapId());
                        AssetKit.this.wayfindToAssetFromPoint(asset, userPoint);
                    }
                    finally {
                        AssetKit.this.handler.postDelayed(AssetKit.this.autoRerouteRunnable, (long)rerouteInterval);
                    }
                }
            };
            this.autoRerouteRunnable.run();
        }
    }

    public void stopAutoReroute() {
        if (this.autoRerouteRunnable != null) {
            this.handler.removeCallbacks(this.autoRerouteRunnable);
        }
    }

    public Asset wayfindToNearestAssetOfType(String type, Point point) {
        Asset[] assetsArray = this.getAssetsByType(type);
        Asset wayfindToAsset = null;
        if (assetsArray.length > 0) {
            ArrayList<Asset> assetsOnFloor = new ArrayList<Asset>();
            ArrayList<Asset> assetsNotOnFloor = new ArrayList<Asset>();
            for (Asset asset : assetsArray) {
                if (asset.getMapId() == (int)point.z) {
                    assetsOnFloor.add(asset);
                    continue;
                }
                assetsNotOnFloor.add(asset);
            }
            if (assetsOnFloor.size() > 0) {
                if (assetsOnFloor.size() == 1) {
                    this.wayfindToAssetFromPoint((Asset)((Object)assetsOnFloor.get(0)), point);
                    return (Asset)((Object)assetsOnFloor.get(0));
                }
                float closestDistance = Float.MAX_VALUE;
                Iterator iterator = assetsOnFloor.iterator();
                while (iterator.hasNext()) {
                    PointF pointFrom = new PointF((float)point.x, (float)point.y);
                    Asset asset = (Asset)((Object)iterator.next());
                    float distance = this.distanceBetweenPoints(pointFrom, asset.getPosition());
                    if (!(distance < closestDistance)) continue;
                    closestDistance = distance;
                    wayfindToAsset = asset;
                }
                if (wayfindToAsset != null) {
                    this.wayfindToAssetFromPoint(wayfindToAsset, point);
                }
                return wayfindToAsset;
            }
            if (assetsNotOnFloor.size() == 1) {
                this.wayfindToAssetFromPoint((Asset)((Object)assetsNotOnFloor.get(0)), point);
                return (Asset)((Object)assetsNotOnFloor.get(0));
            }
            float closestDistance = Float.MAX_VALUE;
            PathPerFloor[] lowestPathPerFloorArray = null;
            for (Asset asset : assetsNotOnFloor) {
                Point pointTo = new Point((double)asset.getPosition().x, (double)asset.getPosition().y, (double)asset.getMapId());
                Waypoint waypointFrom = this.controller.getNearestWaypointToPoint(point);
                Waypoint waypointTo = this.controller.getNearestWaypointToPoint(pointTo);
                if (waypointFrom == null || waypointTo == null) continue;
                PathPerFloor[] pathPerFloorArray = this.controller.wayfindBetweenWaypoints(waypointFrom, waypointTo);
                float totalDistance = 0.0f;
                for (PathPerFloor ppf : pathPerFloorArray) {
                    totalDistance += this.totalWayfindPathDistance(ppf.points);
                }
                if (!(totalDistance < closestDistance)) continue;
                closestDistance = totalDistance;
                lowestPathPerFloorArray = pathPerFloorArray;
                wayfindToAsset = asset;
            }
            if (lowestPathPerFloorArray.length > 0) {
                this.controller.drawWayfindingPath(lowestPathPerFloorArray);
            }
            return wayfindToAsset;
        }
        System.out.println("Could not find asset of given type: " + type);
        return wayfindToAsset;
    }

    private float totalWayfindPathDistance(ASNode[] points) {
        float totalDistance = 0.0f;
        if (points.length == 0) {
            return totalDistance;
        }
        if (points.length > 1) {
            for (int i = 1; i < points.length; ++i) {
                PointF prevPoint = new PointF((float)points[i - 1].x, (float)points[i - 1].y);
                PointF currentPoint = new PointF((float)points[i].x, (float)points[i].y);
                totalDistance += this.distanceBetweenPoints(prevPoint, currentPoint);
            }
        }
        return totalDistance;
    }

    private float distanceBetweenPoints(PointF point1, PointF point2) {
        float xDistance = point2.x - point1.x;
        float yDistance = point2.y - point1.y;
        return (float)Math.sqrt(Math.pow(xDistance, 2.0) + Math.pow(yDistance, 2.0));
    }
}

