/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.analyticskit;

import com.jibestream.jmapandroidsdk.analytics_kit.AnalyticsEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AnalyticsKit {
    public static final String EVENT_ENDPOINT = "end_point";
    public static final String EVENT_REQUEST_START_TIME = "start_time";
    public static final String EVENT_REQUEST_END_TIME = "end_time";
    public static final String EVENT_TIME = "event_time";
    public static final String EVENT_DURATION = "duration";
    public static final String EVENT_ID = "id";
    public static final String EVENT_ERROR = "error";
    public static final String EVENT_COORDINATES = "coordinates";
    public static final String EVENT_ICON_TYPE = "type";
    public static final String EVENT_SHAPE_TYPE = "type";
    public static final String EVENT_WAYPOINT_ID = "waypoint_id";
    public static final String EVENT_WAYFIND_START_WAYPOINT_ID = "wayfind_start";
    public static final String EVENT_WAYFIND_END_WAYPOINT_ID = "wayfind_end";
    public static final String EVENT_TYPE = "event_type";
    public static final String EVENT_TYPE_API_CALL = "api_call";
    public static final String EVENT_TYPE_PARSE_MAP = "parse_map";
    public static final String EVENT_TYPE_SHOW_MAP = "show_map";
    public static final String EVENT_TYPE_GENERATE_WAYFIND = "generate_wayfind";
    public static final String EVENT_TYPE_TAP_MAP = "tap_map";
    public static final String EVENT_TYPE_TAP_ICON = "tap_icon";
    public static final String EVENT_TYPE_TAP_SHAPE = "tap_shape";
    private static AnalyticsKit ourInstance = new AnalyticsKit();
    private Date serverRequestStart;
    private Date parseMapStart;
    private OnJMapEventListener onJMapEventListener;

    public static AnalyticsKit getInstance() {
        return ourInstance;
    }

    private AnalyticsKit() {
    }

    public void onEvent(AnalyticsEvent analyticsEvent) {
        switch (analyticsEvent.getKey()) {
            case "JMAP_CORE_SERVER_REQUEST_START": {
                this.serverRequestStart = this.getCurrentDateAndTime();
                break;
            }
            case "JMAP_CORE_SERVER_REQUEST_SUCCESS": 
            case "JMAP_CORE_SERVER_REQUEST_FAILED": {
                String string = analyticsEvent.getData("endpoint");
                if (string == null) break;
                String string2 = "";
                if (string.contains("building")) {
                    string2 = ".*building\\/(\\d*)";
                } else if (string.contains("venue")) {
                    string2 = ".*venue\\/(\\d*)";
                } else if (string.contains("customer")) {
                    string2 = ".*customer\\/(\\d*)";
                }
                Pattern pattern = Pattern.compile(string2);
                Matcher matcher = pattern.matcher(string);
                String string3 = null;
                while (matcher.find()) {
                    string3 = matcher.group(1);
                }
                if (string3 == null) break;
                Date date = this.getCurrentDateAndTime();
                String string4 = this.getCurrentDateAndTimeFormatted(this.serverRequestStart);
                String string5 = this.getCurrentDateAndTimeFormatted(date);
                String string6 = this.getDuration(this.serverRequestStart, date);
                String string7 = analyticsEvent.getData(EVENT_ERROR);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(EVENT_TYPE, EVENT_TYPE_API_CALL);
                hashMap.put(EVENT_ID, string3);
                hashMap.put(EVENT_ENDPOINT, string);
                hashMap.put(EVENT_REQUEST_START_TIME, string4);
                hashMap.put(EVENT_REQUEST_END_TIME, string5);
                hashMap.put(EVENT_DURATION, string6);
                if (string7 != null) {
                    hashMap.put(EVENT_ERROR, string7);
                }
                this.onJMapEventListener.onEvent(hashMap);
                break;
            }
            case "JMAP_ENGINE_PARSING_START": {
                this.parseMapStart = this.getCurrentDateAndTime();
                break;
            }
            case "JMAP_ENGINE_PARSING_SUCCESS": 
            case "JMAP_ENGINE_PARSING_FAILED": {
                String string = analyticsEvent.getData("mapId");
                if (string == null) break;
                Date date = this.getCurrentDateAndTime();
                String string8 = this.getCurrentDateAndTimeFormatted(this.parseMapStart);
                String string9 = this.getCurrentDateAndTimeFormatted(date);
                String string10 = this.getDuration(this.parseMapStart, date);
                String string11 = analyticsEvent.getData(EVENT_ERROR);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(EVENT_TYPE, EVENT_TYPE_PARSE_MAP);
                hashMap.put(EVENT_ID, string);
                hashMap.put(EVENT_REQUEST_START_TIME, string8);
                hashMap.put(EVENT_REQUEST_END_TIME, string9);
                hashMap.put(EVENT_DURATION, string10);
                if (string11 != null) {
                    hashMap.put(EVENT_ERROR, string11);
                }
                this.onJMapEventListener.onEvent(hashMap);
                break;
            }
            case "JMAP_CONTROLLER_MAP_SHOW": {
                String string = analyticsEvent.getData("mapId");
                if (string == null) break;
                String string12 = this.getCurrentDateAndTimeFormatted();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(EVENT_TYPE, EVENT_TYPE_SHOW_MAP);
                hashMap.put(EVENT_ID, string);
                hashMap.put(EVENT_TIME, string12);
                this.onJMapEventListener.onEvent(hashMap);
                break;
            }
            case "JMAP_CONTROLLER_GENERATE_WAYPATH": {
                String string = this.getCurrentDateAndTimeFormatted();
                String string13 = analyticsEvent.getData("waypointStartId");
                String string14 = analyticsEvent.getData("waypointEndId");
                String string15 = analyticsEvent.getData(EVENT_ERROR);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(EVENT_TYPE, EVENT_TYPE_GENERATE_WAYFIND);
                hashMap.put(EVENT_WAYFIND_START_WAYPOINT_ID, string13);
                hashMap.put(EVENT_WAYFIND_END_WAYPOINT_ID, string14);
                hashMap.put(EVENT_TIME, string);
                if (string15 != null) {
                    hashMap.put(EVENT_ERROR, string15);
                }
                this.onJMapEventListener.onEvent(hashMap);
                break;
            }
            case "JMAP_VIEW_TAP": {
                String string = analyticsEvent.getData("mapId");
                if (string == null) break;
                String string16 = analyticsEvent.getData(EVENT_COORDINATES);
                String string17 = this.getCurrentDateAndTimeFormatted();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(EVENT_TYPE, EVENT_TYPE_TAP_MAP);
                hashMap.put(EVENT_ID, string);
                hashMap.put(EVENT_TIME, string17);
                hashMap.put(EVENT_COORDINATES, string16);
                this.onJMapEventListener.onEvent(hashMap);
                break;
            }
            case "JMAP_VIEW_TAP_ICON": {
                String string = analyticsEvent.getData("iconId");
                String string18 = analyticsEvent.getData("iconType");
                String string19 = analyticsEvent.getData("waypointId");
                String string20 = this.getCurrentDateAndTimeFormatted();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(EVENT_TYPE, EVENT_TYPE_TAP_ICON);
                hashMap.put(EVENT_ID, string);
                hashMap.put("type", string18);
                hashMap.put(EVENT_WAYPOINT_ID, string19);
                hashMap.put(EVENT_TIME, string20);
                this.onJMapEventListener.onEvent(hashMap);
                break;
            }
            case "JMAP_VIEW_TAP_SHAPE": {
                String string = analyticsEvent.getData("shapeId");
                String string21 = analyticsEvent.getData("shapeType");
                String string22 = analyticsEvent.getData("waypointIds");
                String string23 = this.getCurrentDateAndTimeFormatted();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(EVENT_TYPE, EVENT_TYPE_TAP_SHAPE);
                hashMap.put(EVENT_ID, string);
                hashMap.put("type", string21);
                hashMap.put(EVENT_WAYPOINT_ID, string22);
                hashMap.put(EVENT_TIME, string23);
                this.onJMapEventListener.onEvent(hashMap);
                break;
            }
        }
    }

    private Date getCurrentDateAndTime() {
        return new Date();
    }

    private String getCurrentDateAndTimeFormatted() {
        return this.getCurrentDateAndTimeFormatted(new Date());
    }

    private String getCurrentDateAndTimeFormatted(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    private String getDuration(Date date, Date date2) {
        long l = date2.getTime() - date.getTime();
        return String.valueOf(l);
    }

    public void setOnJMapEventListener(OnJMapEventListener onJMapEventListener) {
        this.onJMapEventListener = onJMapEventListener;
    }

    public static interface OnJMapEventListener {
        public void onEvent(HashMap<String, String> var1);
    }
}

