/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog;

import com.jfrog.GradleDependencyTree;
import java.util.Map;
import java.util.stream.Collectors;

public class Utils {
    public static String toJsonString(GradleDependencyTree dependencyTree) {
        return Utils.toJsonString(dependencyTree, "");
    }

    private static String toJsonString(GradleDependencyTree dependencyTree, String baseIndentation) {
        StringBuilder results = new StringBuilder("{").append(System.lineSeparator());
        String keyIndentation = baseIndentation + "  ";
        results.append(keyIndentation).append(Utils.quotedKey("unresolved")).append(dependencyTree.isUnresolved()).append(",").append(System.lineSeparator());
        results.append(keyIndentation).append(Utils.quotedKey("configurations")).append(Utils.configurationsToJson(dependencyTree)).append(",").append(System.lineSeparator());
        results.append(keyIndentation).append(Utils.quotedKey("children")).append("{");
        if (dependencyTree.getChildren().isEmpty()) {
            results.append("}");
        } else {
            String childIndentation = keyIndentation + "  ";
            for (Map.Entry<String, GradleDependencyTree> child : dependencyTree.getChildren().entrySet()) {
                results.append(System.lineSeparator()).append(childIndentation).append(Utils.quotedKey(child.getKey())).append(Utils.toJsonString(child.getValue(), childIndentation)).append(",");
            }
            results.deleteCharAt(results.length() - 1).append(System.lineSeparator()).append(keyIndentation).append("}");
        }
        return results + System.lineSeparator() + baseIndentation + "}";
    }

    private static String quotedKey(String str) {
        return "\"" + str + "\": ";
    }

    private static String configurationsToJson(GradleDependencyTree dependencyTree) {
        return dependencyTree.getConfigurations().stream().sorted().map(configuration -> "\"" + configuration + "\"").collect(Collectors.joining(", ", "[", "]"));
    }
}

