/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog;

import com.jfrog.GradleDependencyTree;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;

public class GradleDependencyTreeUtils {
    public static void addConfiguration(GradleDependencyTree root, Configuration configuration) {
        if (configuration.isCanBeResolved()) {
            GradleDependencyTreeUtils.addResolvedConfiguration(root, configuration);
        } else {
            GradleDependencyTreeUtils.addUnresolvedConfiguration(root, configuration);
        }
    }

    private static void addResolvedConfiguration(GradleDependencyTree root, Configuration configuration) {
        root.getConfigurations().add(configuration.getName());
        ResolvedComponentResult componentResult = configuration.getIncoming().getResolutionResult().getRoot();
        for (DependencyResult dependency : componentResult.getDependencies()) {
            GradleDependencyTreeUtils.populateTree(root, configuration.getName(), dependency, new HashSet<String>());
        }
    }

    private static void addUnresolvedConfiguration(GradleDependencyTree node, Configuration configuration) {
        for (Dependency dependency : configuration.getDependencies()) {
            GradleDependencyTree child = new GradleDependencyTree(configuration.getName());
            child.setUnresolved(true);
            if (dependency.getVersion() == null) continue;
            GradleDependencyTreeUtils.addChild(node, String.join((CharSequence)":", dependency.getGroup(), dependency.getName(), dependency.getVersion()), child);
        }
    }

    private static void populateTree(GradleDependencyTree node, String configurationName, DependencyResult dependency, Set<String> addedChildren) {
        GradleDependencyTree child = new GradleDependencyTree(configurationName);
        if (dependency instanceof UnresolvedDependencyResult) {
            child.setUnresolved(true);
            GradleDependencyTreeUtils.addChild(node, dependency.getRequested().getDisplayName(), child);
            return;
        }
        ResolvedDependencyResult resolvedDependency = (ResolvedDependencyResult)dependency;
        ModuleVersionIdentifier moduleVersion = resolvedDependency.getSelected().getModuleVersion();
        if (moduleVersion == null) {
            return;
        }
        if (!addedChildren.add(moduleVersion.toString())) {
            return;
        }
        GradleDependencyTreeUtils.addChild(node, moduleVersion.toString(), child);
        for (DependencyResult dependencyResult : resolvedDependency.getSelected().getDependencies()) {
            GradleDependencyTreeUtils.populateTree(child, configurationName, dependencyResult, new HashSet<String>(addedChildren));
        }
    }

    static void addChild(GradleDependencyTree parent, String id, GradleDependencyTree childToAdd) {
        if (parent.getChildren().containsKey(id)) {
            GradleDependencyTree child = parent.getChildren().get(id);
            child.getConfigurations().addAll(childToAdd.getConfigurations());
            child.setUnresolved(child.isUnresolved() && childToAdd.isUnresolved());
        } else {
            parent.getChildren().put(id, childToAdd);
        }
    }
}

