/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.bintray.client.impl.model;

import com.jfrog.bintray.client.api.ObjectMapperHelper;
import com.jfrog.bintray.client.api.details.PackageDetails;
import com.jfrog.bintray.client.api.model.Pkg;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageImpl
implements Pkg {
    private static final Logger log = LoggerFactory.getLogger(PackageImpl.class);
    private String name;
    private String repository;
    private String owner;
    private String description;
    private List<String> labels;
    private List<String> attributeNames;
    private Integer rating;
    private Integer ratingCount;
    private Integer followersCount;
    private DateTime created;
    private List<String> versions;
    private String latestVersion;
    private DateTime updated;
    private List<String> linkedToRepos;
    private List<String> systemIds;
    private List<String> licenses;
    private String vcsUrl;
    private Map<String, Object> other;

    public PackageImpl(PackageDetails packageDetails) {
        this.name = packageDetails.getName();
        this.repository = packageDetails.getRepo();
        this.owner = packageDetails.getOwner();
        this.description = packageDetails.getDescription();
        this.labels = packageDetails.getLabels();
        this.attributeNames = packageDetails.getAttributeNames();
        this.ratingCount = packageDetails.getRatingCount();
        this.followersCount = packageDetails.getFollowersCount();
        this.created = packageDetails.getCreated();
        this.versions = packageDetails.getVersions();
        this.latestVersion = packageDetails.getLatestVersion();
        this.updated = packageDetails.getUpdated();
        this.linkedToRepos = packageDetails.getLinkedRepos();
        this.systemIds = packageDetails.getSystemIds();
        this.licenses = packageDetails.getLicenses();
        this.vcsUrl = packageDetails.getVcsUrl();
        this.other = packageDetails.other();
    }

    public PackageImpl(String name, String repository, String owner, String description, List<String> labels, List<String> attributeNames, Integer rating, Integer ratingCount, Integer followersCount, DateTime created, List<String> versions, String latestVersion, DateTime updated, List<String> linkedToRepos, List<String> systemIds) {
        this.name = name;
        this.repository = repository;
        this.owner = owner;
        this.description = description;
        this.labels = labels;
        this.attributeNames = attributeNames;
        this.rating = rating;
        this.ratingCount = ratingCount;
        this.followersCount = followersCount;
        this.created = created;
        this.versions = versions;
        this.latestVersion = latestVersion;
        this.updated = updated;
        this.linkedToRepos = linkedToRepos;
        this.systemIds = systemIds;
    }

    public static String getCreateUpdateJson(PackageDetails packageDetails) throws IOException {
        String jsonContent;
        ObjectMapper mapper = ObjectMapperHelper.get();
        try {
            jsonContent = mapper.writeValueAsString((Object)packageDetails);
        }
        catch (IOException e) {
            log.error("Can't process the json file: " + e.getMessage());
            throw e;
        }
        return jsonContent;
    }

    public String name() {
        return this.name;
    }

    public String repository() {
        return this.repository;
    }

    public String owner() {
        return this.owner;
    }

    public String description() {
        return this.description;
    }

    public List<String> labels() {
        return this.labels;
    }

    public List<String> attributeNames() {
        return this.attributeNames;
    }

    public Integer rating() {
        return this.rating;
    }

    public Integer ratingCount() {
        return this.ratingCount;
    }

    public Integer followersCount() {
        return this.followersCount;
    }

    public DateTime created() {
        return this.created;
    }

    public List<String> versions() {
        return this.versions;
    }

    public String latestVersion() {
        return this.latestVersion;
    }

    public DateTime updated() {
        return this.updated;
    }

    public List<String> linkedToRepos() {
        return this.linkedToRepos;
    }

    public List<String> systemIds() {
        return this.systemIds;
    }

    public List<String> licenses() {
        return this.licenses;
    }

    public String vcsUrl() {
        return this.vcsUrl;
    }

    public Object getFieldByKey(String key) {
        return this.other.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageImpl aPackage = (PackageImpl)o;
        return this.name.equals(aPackage.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Package{getName='" + this.name + '\'' + ", repository='" + this.repository + '\'' + ", owner='" + this.owner + '\'' + ", description='" + this.description + '\'' + ", labels=" + this.labels + ", attributeNames=" + this.attributeNames + ", rating=" + this.rating + ", ratingCount=" + this.ratingCount + ", followersCount=" + this.followersCount + ", created=" + this.created + ", versions=" + this.versions + ", latestVersion='" + this.latestVersion + '\'' + ", updated=" + this.updated + ", linkedToRepos='" + this.linkedToRepos + '\'' + ", systemIds=" + this.systemIds + '}';
    }
}

