/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.bintray.client.impl.handle;

import com.jfrog.bintray.client.api.BintrayCallException;
import com.jfrog.bintray.client.api.ObjectMapperHelper;
import com.jfrog.bintray.client.api.details.ProductDetails;
import com.jfrog.bintray.client.api.details.RepositoryDetails;
import com.jfrog.bintray.client.api.details.SubjectDetails;
import com.jfrog.bintray.client.api.handle.ProductHandle;
import com.jfrog.bintray.client.api.handle.RepositoryHandle;
import com.jfrog.bintray.client.api.handle.SubjectHandle;
import com.jfrog.bintray.client.api.model.Subject;
import com.jfrog.bintray.client.impl.handle.BintrayImpl;
import com.jfrog.bintray.client.impl.handle.ProductHandleImpl;
import com.jfrog.bintray.client.impl.handle.RepositoryHandleImpl;
import com.jfrog.bintray.client.impl.model.RepositoryImpl;
import com.jfrog.bintray.client.impl.model.SubjectImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubjectHandleImpl
implements SubjectHandle {
    private static final Logger log = LoggerFactory.getLogger(SubjectHandleImpl.class);
    private BintrayImpl bintrayHandle;
    private String subject;

    SubjectHandleImpl(BintrayImpl bintrayHandle, String subject) {
        this.bintrayHandle = bintrayHandle;
        this.subject = subject;
    }

    public String name() {
        return this.subject;
    }

    public RepositoryHandle repository(String repoName) {
        return new RepositoryHandleImpl(this.bintrayHandle, this, repoName);
    }

    public RepositoryHandle createRepo(RepositoryDetails repoDetails) throws IOException, BintrayCallException {
        HashMap<String, String> headers = new HashMap<String, String>();
        String jsonContent = RepositoryImpl.getCreateJson(repoDetails);
        BintrayImpl.addContentTypeJsonHeader(headers);
        this.bintrayHandle.post(this.getRepoUri(repoDetails), headers, IOUtils.toInputStream((String)jsonContent));
        return new RepositoryHandleImpl(this.bintrayHandle, this, repoDetails.getName());
    }

    public ProductHandle product(String name) {
        return new ProductHandleImpl(this.bintrayHandle, this, name);
    }

    public ProductHandle createProduct(ProductDetails productDetails) throws IOException, BintrayCallException {
        HashMap<String, String> headers = new HashMap<String, String>();
        String jsonContent = ObjectMapperHelper.get().writeValueAsString((Object)productDetails);
        BintrayImpl.addContentTypeJsonHeader(headers);
        this.bintrayHandle.post(this.getProductUri(), headers, IOUtils.toInputStream((String)jsonContent));
        return new ProductHandleImpl(this.bintrayHandle, this, productDetails.getName());
    }

    public Subject get() throws IOException, BintrayCallException {
        SubjectDetails subjectDetails;
        HttpResponse response = this.bintrayHandle.get("users/" + this.subject, null);
        InputStream jsonContentStream = response.getEntity().getContent();
        ObjectMapper mapper = ObjectMapperHelper.get();
        try {
            subjectDetails = (SubjectDetails)mapper.readValue(jsonContentStream, SubjectDetails.class);
        }
        catch (IOException e) {
            log.error("Can't process the json file: " + e.getMessage());
            throw e;
        }
        return new SubjectImpl(subjectDetails);
    }

    private String getRepoUri(RepositoryDetails repoDetails) {
        return String.format("repos/%s/%s", this.subject, repoDetails.getName());
    }

    private String getProductUri() {
        return "products//" + this.subject;
    }
}

