/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.bintray.client.impl.handle;

import com.jfrog.bintray.client.api.BintrayCallException;
import com.jfrog.bintray.client.api.ObjectMapperHelper;
import com.jfrog.bintray.client.api.details.ProductDetails;
import com.jfrog.bintray.client.api.handle.ProductHandle;
import com.jfrog.bintray.client.api.handle.SubjectHandle;
import com.jfrog.bintray.client.api.model.Product;
import com.jfrog.bintray.client.impl.handle.BintrayImpl;
import com.jfrog.bintray.client.impl.handle.SubjectHandleImpl;
import com.jfrog.bintray.client.impl.model.ProductImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProductHandleImpl
implements ProductHandle {
    private static final Logger log = LoggerFactory.getLogger(ProductHandleImpl.class);
    private BintrayImpl bintrayHandle;
    private SubjectHandleImpl owner;
    private String name;

    public ProductHandleImpl(BintrayImpl bintrayHandle, SubjectHandleImpl owner, String productName) {
        this.bintrayHandle = bintrayHandle;
        this.owner = owner;
        this.name = productName;
    }

    public String name() {
        return this.name;
    }

    public SubjectHandle owner() {
        return this.owner;
    }

    public Product get() throws IOException, BintrayCallException {
        ProductDetails productDetails = this.getProductDetails();
        return new ProductImpl(productDetails);
    }

    public ProductHandle update(ProductDetails productDetails) throws IOException, BintrayCallException {
        HashMap<String, String> headers = new HashMap<String, String>();
        String jsonContent = ObjectMapperHelper.get().writeValueAsString((Object)productDetails);
        BintrayImpl.addContentTypeJsonHeader(headers);
        this.bintrayHandle.patch(this.getProductUri(), headers, IOUtils.toInputStream((String)jsonContent));
        return this;
    }

    public ProductHandle addPackages(List<String> packages) throws IOException, BintrayCallException {
        ProductDetails details = this.getProductDetails();
        packages.addAll(details.getPackages());
        details.setPackages(packages);
        this.update(details);
        return this;
    }

    public ProductHandle delete() throws BintrayCallException {
        this.bintrayHandle.delete(this.getProductUri(), null);
        return this;
    }

    public boolean exists() throws BintrayCallException {
        try {
            this.bintrayHandle.get(this.getProductUri(), null);
        }
        catch (BintrayCallException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
        return true;
    }

    private ProductDetails getProductDetails() throws IOException {
        ProductDetails productDetails;
        HttpResponse response = this.bintrayHandle.get(this.getProductUri(), null);
        InputStream jsonContentStream = response.getEntity().getContent();
        ObjectMapper mapper = ObjectMapperHelper.get();
        try {
            productDetails = (ProductDetails)mapper.readValue(jsonContentStream, ProductDetails.class);
        }
        catch (IOException e) {
            log.error("Can't parse the json file: " + e.getMessage());
            throw e;
        }
        return productDetails;
    }

    private String getProductUri() {
        return String.format("products/%s/%s", this.owner.name(), this.name);
    }
}

