/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.bintray.client.impl.handle;

import com.jfrog.bintray.client.api.BintrayCallException;
import com.jfrog.bintray.client.api.ObjectMapperHelper;
import com.jfrog.bintray.client.api.details.Attribute;
import com.jfrog.bintray.client.api.details.PackageDetails;
import com.jfrog.bintray.client.api.details.VersionDetails;
import com.jfrog.bintray.client.api.handle.PackageHandle;
import com.jfrog.bintray.client.api.handle.RepositoryHandle;
import com.jfrog.bintray.client.api.handle.VersionHandle;
import com.jfrog.bintray.client.api.model.Pkg;
import com.jfrog.bintray.client.api.model.Version;
import com.jfrog.bintray.client.impl.handle.AttributesSearchQueryImpl;
import com.jfrog.bintray.client.impl.handle.BintrayImpl;
import com.jfrog.bintray.client.impl.handle.VersionHandleImpl;
import com.jfrog.bintray.client.impl.model.PackageImpl;
import com.jfrog.bintray.client.impl.model.VersionImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PackageHandleImpl
implements PackageHandle {
    private static final Logger log = LoggerFactory.getLogger(PackageHandleImpl.class);
    private BintrayImpl bintrayHandle;
    private RepositoryHandle repositoryHandle;
    private String name;
    private AttributesSearchQueryImpl searchQuery = null;

    PackageHandleImpl(BintrayImpl bintrayHandle, RepositoryHandle repositoryHandle, String name) {
        this.bintrayHandle = bintrayHandle;
        this.repositoryHandle = repositoryHandle;
        this.name = name;
    }

    public RepositoryHandle repository() {
        return this.repositoryHandle;
    }

    public VersionHandle version(String versionName) {
        return new VersionHandleImpl(this.bintrayHandle, this, versionName);
    }

    public Pkg get() throws IOException, BintrayCallException {
        PackageDetails pkgDetails;
        HttpResponse response = this.bintrayHandle.get(this.getCurrentPackageUri(), null);
        String jsonContentStream = IOUtils.toString((InputStream)response.getEntity().getContent());
        ObjectMapper mapper = ObjectMapperHelper.get();
        try {
            pkgDetails = (PackageDetails)mapper.readValue(jsonContentStream, PackageDetails.class);
        }
        catch (IOException e) {
            log.error("Can't parse the json file: " + e.getMessage());
            throw e;
        }
        return new PackageImpl(pkgDetails);
    }

    public PackageHandle update(PackageDetails packageDetails) throws IOException, BintrayCallException {
        HashMap<String, String> headers = new HashMap<String, String>();
        String jsonContent = PackageImpl.getCreateUpdateJson(packageDetails);
        BintrayImpl.addContentTypeJsonHeader(headers);
        this.bintrayHandle.patch(this.getCurrentPackageUri(), headers, IOUtils.toInputStream((String)jsonContent));
        return this.updateAttributes(packageDetails);
    }

    public PackageHandle delete() throws BintrayCallException {
        this.bintrayHandle.delete(this.getCurrentPackageUri(), null);
        return this;
    }

    public boolean exists() throws BintrayCallException {
        try {
            this.bintrayHandle.head(this.getCurrentPackageUri(), null);
        }
        catch (BintrayCallException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public VersionHandle createVersion(VersionDetails versionDetails) throws IOException, BintrayCallException {
        HashMap<String, String> headers = new HashMap<String, String>();
        String jsonContent = VersionImpl.getCreateUpdateJson(versionDetails);
        BintrayImpl.addContentTypeJsonHeader(headers);
        this.bintrayHandle.post(this.getCurrentPackageUri() + "/versions", headers, IOUtils.toInputStream((String)jsonContent));
        return new VersionHandleImpl(this.bintrayHandle, this, versionDetails.getName()).setAttributes(versionDetails);
    }

    public PackageHandle setAttributes(PackageDetails packageDetails) throws IOException, BintrayCallException {
        return this.setAttributes(packageDetails.getAttributes());
    }

    public PackageHandle setAttributes(List<Attribute> attributes) throws IOException, BintrayCallException {
        if (attributes == null) {
            return this;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        String jsonContent = Attribute.getJsonFromAttributeList(attributes);
        BintrayImpl.addContentTypeJsonHeader(headers);
        this.bintrayHandle.post(this.getCurrentPackageUri() + "/attributes", headers, IOUtils.toInputStream((String)jsonContent));
        return this;
    }

    public PackageHandle updateAttributes(PackageDetails packageDetails) throws IOException, BintrayCallException {
        return this.updateAttributes(packageDetails.getAttributes());
    }

    public PackageHandle updateAttributes(List<Attribute> attributes) throws IOException, BintrayCallException {
        if (attributes == null) {
            return this;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        String jsonContent = Attribute.getJsonFromAttributeList(attributes);
        BintrayImpl.addContentTypeJsonHeader(headers);
        this.bintrayHandle.patch(this.getCurrentPackageUri() + "/attributes", headers, IOUtils.toInputStream((String)jsonContent));
        return this;
    }

    public void addQuery(AttributesSearchQueryImpl query) {
        this.searchQuery = query;
    }

    public List<Version> attributeSearch() throws BintrayCallException {
        ObjectMapper mapper = ObjectMapperHelper.get();
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue((Writer)writer, (Object)this.searchQuery);
        }
        catch (IOException e) {
            log.error("Error writing search query to json: ", (Throwable)e);
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        HttpResponse response = this.bintrayHandle.post("/search/attributes/" + this.repositoryHandle.owner().name() + "/" + this.repositoryHandle.name() + "/" + this.name + "/versions", headers, IOUtils.toInputStream((String)writer.toString()));
        List answer = new ArrayList();
        try {
            answer = (List)mapper.readValue(response.getEntity().getContent(), (TypeReference)new TypeReference<List<VersionDetails>>(){});
        }
        catch (IOException e) {
            log.error("Error parsing query response");
        }
        ArrayList<Version> packages = new ArrayList<Version>();
        for (VersionDetails verDetails : answer) {
            packages.add(new VersionImpl(verDetails));
        }
        this.searchQuery = null;
        return packages;
    }

    public String getCurrentPackageUri() {
        return String.format("packages/%s/%s/%s", this.repositoryHandle.owner().name(), this.repositoryHandle.name(), this.name);
    }

    public String name() {
        return this.name;
    }
}

