/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.bintray.client.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientConfigurator {
    private static final Logger log = LoggerFactory.getLogger(HttpClientConfigurator.class);
    private HttpClientBuilder builder = HttpClients.custom();
    private RequestConfig.Builder config = RequestConfig.custom();
    private String host;
    private BasicCredentialsProvider credsProvider;
    private int maxConnectionsPerRoute = 30;
    private int maxTotalConnections = 50;

    public HttpClientConfigurator() {
        this.builder.setUserAgent("BintrayJavaClient/0.9.2-SNAPSHOT");
        this.credsProvider = new BasicCredentialsProvider();
    }

    public CloseableHttpClient getClient() {
        if (this.hasCredentials()) {
            this.builder.setDefaultCredentialsProvider((CredentialsProvider)this.credsProvider);
        }
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
        cm.setMaxTotal(this.maxTotalConnections);
        this.builder.setConnectionManager((HttpClientConnectionManager)cm);
        return this.builder.setDefaultRequestConfig(this.config.build()).build();
    }

    public HttpClientConfigurator hostFromUrl(String urlStr) throws IllegalArgumentException {
        if (StringUtils.isNotBlank((String)urlStr)) {
            try {
                URL url = new URL(urlStr);
                this.host(url.getHost());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Cannot parse the url " + urlStr, e);
            }
        }
        return this;
    }

    public HttpClientConfigurator host(String host) {
        if (StringUtils.isNotBlank((String)host)) {
            this.host = host;
            this.builder.setRoutePlanner((HttpRoutePlanner)new DefaultHostRoutePlanner(host));
        }
        return this;
    }

    public HttpClientConfigurator defaultMaxConnectionsPerHost(int maxConnectionsPerHost) {
        this.builder.setMaxConnPerRoute(maxConnectionsPerHost);
        this.maxConnectionsPerRoute = maxConnectionsPerHost;
        return this;
    }

    public HttpClientConfigurator maxTotalConnections(int maxTotalConnections) {
        this.builder.setMaxConnTotal(maxTotalConnections);
        this.maxTotalConnections = maxTotalConnections;
        return this;
    }

    public HttpClientConfigurator connectionTimeout(int connectionTimeout) {
        this.config.setConnectTimeout(connectionTimeout);
        return this;
    }

    public HttpClientConfigurator soTimeout(int soTimeout) {
        this.config.setSocketTimeout(soTimeout);
        return this;
    }

    public HttpClientConfigurator noCookies() {
        this.builder.disableCookieManagement();
        return this;
    }

    public HttpClientConfigurator staleCheckingEnabled(boolean staleCheckingEnabled) {
        this.config.setStaleConnectionCheckEnabled(staleCheckingEnabled);
        return this;
    }

    public HttpClientConfigurator noRetry() {
        return this.retry(0, false);
    }

    public HttpClientConfigurator retry(int retryCount, boolean requestSentRetryEnabled) {
        if (retryCount == 0) {
            this.builder.disableAutomaticRetries();
        } else {
            this.builder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(retryCount, requestSentRetryEnabled));
        }
        return this;
    }

    public HttpClientConfigurator localAddress(String localAddress) {
        if (StringUtils.isNotBlank((String)localAddress)) {
            try {
                InetAddress address = InetAddress.getByName(localAddress);
                this.config.setLocalAddress(address);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid local address: " + localAddress, e);
            }
        }
        return this;
    }

    public HttpClientConfigurator authentication(UsernamePasswordCredentials creds) {
        if (creds != null) {
            this.authentication(creds.getUserName(), creds.getPassword());
        }
        return this;
    }

    public HttpClientConfigurator authentication(String username, String password) {
        if (StringUtils.isNotBlank((String)username)) {
            if (StringUtils.isBlank((String)this.host)) {
                throw new IllegalStateException("Cannot configure authentication when host is not set.");
            }
            this.credsProvider.setCredentials(new AuthScope(this.host, -1, AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(username, password));
            this.builder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthInterceptor());
        }
        return this;
    }

    public HttpClientConfigurator proxy(ProxyConfig proxyConfig) {
        this.configureProxy(proxyConfig);
        return this;
    }

    private void configureProxy(ProxyConfig proxy) {
        if (proxy != null) {
            this.config.setProxy(new HttpHost(proxy.getHost(), proxy.getPort()));
            if (proxy.getUserName() != null) {
                UsernamePasswordCredentials creds = null;
                if (proxy.getNtDomain() == null) {
                    creds = new UsernamePasswordCredentials(proxy.getUserName(), proxy.getPassword());
                    List<String> authPrefs = Arrays.asList("Digest", "Basic", "NTLM");
                    this.config.setProxyPreferredAuthSchemes(authPrefs);
                    this.builder.addInterceptorFirst((HttpRequestInterceptor)new ProxyPreemptiveAuthInterceptor());
                } else {
                    try {
                        String ntHost = StringUtils.isBlank((String)proxy.getNtHost()) ? InetAddress.getLocalHost().getHostName() : proxy.getNtHost();
                        creds = new NTCredentials(proxy.getUserName(), proxy.getPassword(), ntHost, proxy.getNtDomain());
                    }
                    catch (UnknownHostException e) {
                        log.error("Failed to determine required local hostname for NTLM credentials.", (Throwable)e);
                    }
                }
                if (creds != null) {
                    this.credsProvider.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort(), AuthScope.ANY_REALM), (Credentials)creds);
                    if (proxy.getRedirectToHosts() != null) {
                        for (String hostName : proxy.getRedirectToHosts()) {
                            this.credsProvider.setCredentials(new AuthScope(hostName, -1, AuthScope.ANY_REALM), (Credentials)creds);
                        }
                    }
                }
            }
        }
    }

    private boolean hasCredentials() {
        return this.credsProvider.getCredentials(AuthScope.ANY) != null;
    }

    public static class ProxyConfig {
        String host;
        int port;
        String userName;
        String password;
        String ntHost;
        String ntDomain;
        List<String> redirectToHosts;

        public String getHost() {
            return this.host;
        }

        public ProxyConfig host(String host) {
            this.host = host;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public ProxyConfig port(int port) {
            this.port = port;
            return this;
        }

        public String getUserName() {
            return this.userName;
        }

        public ProxyConfig userName(String userName) {
            this.userName = userName;
            return this;
        }

        public String getPassword() {
            return this.password;
        }

        public ProxyConfig password(String password) {
            this.password = password;
            return this;
        }

        public String getNtHost() {
            return this.ntHost;
        }

        public ProxyConfig ntHost(String ntHost) {
            this.ntHost = ntHost;
            return this;
        }

        public String getNtDomain() {
            return this.ntDomain;
        }

        public ProxyConfig ntDomain(String ntDomain) {
            this.ntDomain = ntDomain;
            return this;
        }

        public List<String> getRedirectToHosts() {
            return this.redirectToHosts;
        }

        public ProxyConfig redirectToHosts(List<String> redirectToHosts) {
            this.redirectToHosts = redirectToHosts;
            return this;
        }
    }

    static class ProxyPreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        ProxyPreemptiveAuthInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            AuthState proxyAuthState = clientContext.getProxyAuthState();
            if (proxyAuthState.getAuthScheme() == null) {
                CredentialsProvider credsProvider = clientContext.getCredentialsProvider();
                RouteInfo route = clientContext.getHttpRoute();
                if (route == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("No route found for {}", (Object)clientContext.getTargetHost());
                    }
                    return;
                }
                HttpHost proxyHost = route.getProxyHost();
                if (proxyHost == null) {
                    log.warn("No proxy host found in route {} for host {}", (Object)route, (Object)clientContext.getTargetHost());
                    return;
                }
                Credentials creds = credsProvider.getCredentials(new AuthScope(proxyHost.getHostName(), proxyHost.getPort()));
                if (creds == null) {
                    log.info("No credentials found for proxy: " + proxyHost);
                    return;
                }
                proxyAuthState.update((AuthScheme)new BasicScheme(ChallengeState.PROXY), creds);
            }
        }
    }

    static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        PreemptiveAuthInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            AuthState authState = clientContext.getTargetAuthState();
            if (authState.getAuthScheme() == null) {
                HttpHost targetHost;
                CredentialsProvider credsProvider = clientContext.getCredentialsProvider();
                Credentials creds = credsProvider.getCredentials(new AuthScope((targetHost = clientContext.getTargetHost()).getHostName(), targetHost.getPort()));
                if (creds == null) {
                    throw new HttpException("No credentials for preemptive authentication");
                }
                authState.update((AuthScheme)new BasicScheme(), creds);
            }
        }
    }

    static class DefaultHostRoutePlanner
    extends DefaultRoutePlanner {
        private final HttpHost defaultHost;

        public DefaultHostRoutePlanner(String defaultHost) {
            super((SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
            this.defaultHost = new HttpHost(defaultHost);
        }

        public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
            if (host == null) {
                host = this.defaultHost;
            }
            return super.determineRoute(host, request, context);
        }

        public HttpHost getDefaultHost() {
            return this.defaultHost;
        }
    }
}

