/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.bintray.client.impl;

import com.jfrog.bintray.client.api.handle.Bintray;
import com.jfrog.bintray.client.impl.HttpClientConfigurator;
import com.jfrog.bintray.client.impl.handle.BintrayImpl;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.CloseableHttpClient;

public class BintrayClient {
    public static final int DEFAULT_TIMEOUT = 150000;
    public static final String BINTRAY_API_URL = "https://api.bintray.com";
    public static final String USER_AGENT = "BintrayJavaClient/0.9.2-SNAPSHOT";
    private static final int DEFAULT_THREAD_POOL_SIZE = 5;
    private static final int DEFAULT_SIGN_REQUEST_TIMEOUT_PER_FILE = 90000;

    public static Bintray create(CloseableHttpClient preConfiguredClient, String url, int threadPoolSize, int signRequestTimeoutPerFile) {
        return new BintrayImpl(preConfiguredClient, url, threadPoolSize, signRequestTimeoutPerFile);
    }

    public static Bintray create(String userName, String apiKey) {
        return BintrayClient.create(BINTRAY_API_URL, userName, apiKey);
    }

    public static Bintray create(String url, String userName, String apiKey) {
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(userName, apiKey);
        return new BintrayImpl(BintrayClient.createClient(creds, null, url), url, 5, 90000);
    }

    public static Bintray create(UsernamePasswordCredentials creds, HttpClientConfigurator.ProxyConfig proxyConfig) {
        return new BintrayImpl(BintrayClient.createClient(creds, proxyConfig, BINTRAY_API_URL), BINTRAY_API_URL, 5, 90000);
    }

    public static Bintray create(String bintrayUserName, String bintrayApiKey, HttpClientConfigurator.ProxyConfig proxyConfig, String url) {
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(bintrayUserName, bintrayApiKey);
        return new BintrayImpl(BintrayClient.createClient(creds, proxyConfig, url), url, 5, 90000);
    }

    private static CloseableHttpClient createClient(UsernamePasswordCredentials creds, HttpClientConfigurator.ProxyConfig proxyConfig, String url) {
        return new HttpClientConfigurator().hostFromUrl(url).soTimeout(150000).connectionTimeout(150000).noRetry().proxy(proxyConfig).authentication(creds).maxTotalConnections(50).defaultMaxConnectionsPerHost(30).getClient();
    }
}

