/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.fse.serializer.extra;

import com.jfireframework.fse.CycleFlagSerializer;
import com.jfireframework.fse.FseContext;
import com.jfireframework.fse.FseSerializer;
import com.jfireframework.fse.InternalByteArray;
import com.jfireframework.fse.SerializerFactory;
import java.util.HashSet;

public class HashSetSerializer
extends CycleFlagSerializer
implements FseSerializer {
    @Override
    public void init(Class<?> type, SerializerFactory serializerFactory) {
    }

    @Override
    public void doWriteToBytes(Object o, InternalByteArray byteArray, FseContext fseContext, int depth) {
        HashSet set = (HashSet)o;
        byteArray.writePositive(set.size());
        for (Object each : set) {
            if (each == null) {
                byteArray.writeVarInt(0);
                continue;
            }
            fseContext.serialize(each, byteArray, depth);
        }
    }

    @Override
    public Object readBytes(InternalByteArray byteArray, FseContext fseContext) {
        int size = byteArray.readPositive();
        HashSet<Object> set = new HashSet<Object>();
        fseContext.collectObject(set);
        for (int i = 0; i < size; ++i) {
            int result = byteArray.readVarInt();
            if (result == 0) {
                set.add(null);
                continue;
            }
            if (result > 0) {
                Object element = fseContext.getClassRegistry(result).getSerializer().readBytes(byteArray, fseContext);
                set.add(element);
                continue;
            }
            set.add(fseContext.getObjectByIndex(0 - result));
        }
        return set;
    }
}

