/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.fse.serializer.extra;

import com.jfireframework.baseutil.reflect.ReflectUtil;
import com.jfireframework.fse.CycleFlagSerializer;
import com.jfireframework.fse.FseContext;
import com.jfireframework.fse.FseSerializer;
import com.jfireframework.fse.InternalByteArray;
import com.jfireframework.fse.SerializerFactory;
import java.util.HashMap;
import java.util.Map;

public class ClassSerializer
extends CycleFlagSerializer
implements FseSerializer {
    private Map<String, Class> nameToClass = new HashMap<String, Class>();

    public ClassSerializer() {
        this.nameToClass.put("void", Void.TYPE);
    }

    @Override
    public void init(Class<?> type, SerializerFactory serializerFactory) {
    }

    @Override
    public void writeToBytes(Object o, int classIndex, InternalByteArray byteArray, FseContext fseContext, int depth) {
        byteArray.writeVarInt(classIndex);
        byteArray.writeString(((Class)o).getName());
    }

    @Override
    public Object readBytes(InternalByteArray byteArray, FseContext fseContext) {
        String className = byteArray.readString();
        Class<?> ckass = this.nameToClass.get(className);
        if (ckass != null) {
            return ckass;
        }
        try {
            ckass = Class.forName(className);
            this.nameToClass.put(className, ckass);
            return ckass;
        }
        catch (ClassNotFoundException e) {
            ReflectUtil.throwException((Throwable)e);
            return null;
        }
    }
}

