/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.fse.serializer.extra;

import com.jfireframework.fse.CycleFlagSerializer;
import com.jfireframework.fse.FseContext;
import com.jfireframework.fse.FseSerializer;
import com.jfireframework.fse.InternalByteArray;
import com.jfireframework.fse.SerializerFactory;
import java.util.ArrayList;

public class ArrayListSerializer
extends CycleFlagSerializer
implements FseSerializer {
    @Override
    public void init(Class<?> type, SerializerFactory serializerFactory) {
    }

    @Override
    public void doWriteToBytes(Object o, InternalByteArray byteArray, FseContext fseContext, int depth) {
        byteArray.writePositive(((ArrayList)o).size());
        for (Object each : (ArrayList)o) {
            fseContext.serialize(each, byteArray, depth);
        }
    }

    @Override
    public Object readBytes(InternalByteArray byteArray, FseContext fseContext) {
        int size = byteArray.readPositive();
        return this.readArrayList(byteArray, fseContext, size);
    }

    private Object readArrayList(InternalByteArray byteArray, FseContext fseContext, int size) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        fseContext.collectObject(arrayList);
        for (int i = 0; i < size; ++i) {
            int result = byteArray.readVarInt();
            if (result == 0) {
                arrayList.add(null);
                continue;
            }
            if (result > 0) {
                Object element = fseContext.getClassRegistry(result).getSerializer().readBytes(byteArray, fseContext);
                arrayList.add(element);
                continue;
            }
            arrayList.add(fseContext.getObjectByIndex(0 - result));
        }
        return arrayList;
    }
}

