/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.fse.serializer.array;

import com.jfireframework.fse.CycleFlagSerializer;
import com.jfireframework.fse.FseContext;
import com.jfireframework.fse.FseSerializer;
import com.jfireframework.fse.InternalByteArray;
import com.jfireframework.fse.SerializerFactory;

public class ShortArraySerializer
extends CycleFlagSerializer
implements FseSerializer {
    private final boolean primitive;

    public ShortArraySerializer(boolean primitive) {
        this.primitive = primitive;
    }

    @Override
    public void init(Class<?> type, SerializerFactory serializerFactory) {
    }

    @Override
    public void writeToBytes(Object o, int classIndex, InternalByteArray byteArray, FseContext fseContext, int depth) {
        byteArray.writeVarInt(classIndex);
        this.writeElement(o, byteArray);
    }

    private void writeElement(Object o, InternalByteArray byteArray) {
        if (this.primitive) {
            short[] array = (short[])o;
            byteArray.writePositive(array.length);
            for (short v : array) {
                byteArray.writeShort(v);
            }
        } else {
            Short[] array = (Short[])o;
            byteArray.writePositive(array.length);
            for (Short v : array) {
                if (v == null) {
                    byteArray.put((byte)0);
                    continue;
                }
                byteArray.put((byte)1);
                byteArray.writeShort(v);
            }
        }
    }

    @Override
    public Object readBytes(InternalByteArray byteArray, FseContext fseContext) {
        int len = byteArray.readPositive();
        return this.readElement(byteArray, len);
    }

    private Object readElement(InternalByteArray byteArray, int len) {
        if (this.primitive) {
            short[] array = new short[len];
            for (int i = 0; i < len; ++i) {
                array[i] = byteArray.readShort();
            }
            return array;
        }
        Short[] array = new Short[len];
        for (int i = 0; i < len; ++i) {
            array[i] = byteArray.get() == 0 ? null : Short.valueOf(byteArray.readShort());
        }
        return array;
    }
}

