/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.fse.serializer;

import com.jfireframework.baseutil.reflect.UNSAFE;
import com.jfireframework.baseutil.reflect.ValueAccessor;
import com.jfireframework.fse.CycleFlagSerializer;
import com.jfireframework.fse.FseContext;
import com.jfireframework.fse.FseIgnore;
import com.jfireframework.fse.FseSerializer;
import com.jfireframework.fse.InternalByteArray;
import com.jfireframework.fse.SerializerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ObjectSerializer
extends CycleFlagSerializer
implements FseSerializer {
    Entry[] entries;
    private Class<?> type;

    @Override
    public void init(Class<?> type, SerializerFactory serializerFactory) {
        this.type = type;
        List<Field> list = this.getAllFields(type);
        this.entries = new Entry[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Entry entry;
            this.entries[i] = entry = this.buildEntry(serializerFactory, list.get(i));
        }
    }

    private Entry buildEntry(SerializerFactory serializerFactory, Field field) {
        Entry entry = new Entry();
        entry.field = field;
        entry.fieldType = field.getType();
        entry.accessor = new ValueAccessor(field);
        Class<?> fieldType = field.getType();
        if (fieldType.isArray()) {
            entry.array = true;
            entry.finalType = true;
            entry.serializer = serializerFactory.getSerializer(fieldType);
        } else {
            entry.type = this.getType(fieldType);
            if (entry.type == BuildInType.OBJECT && !entry.fieldType.isInterface() && !Modifier.isAbstract(entry.fieldType.getModifiers())) {
                FseSerializer serializer;
                if (Modifier.isFinal(fieldType.getModifiers())) {
                    entry.finalType = true;
                }
                entry.serializer = serializer = serializerFactory.getSerializer(fieldType);
            }
        }
        return entry;
    }

    private List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> list = new ArrayList<Field>();
        while (type != Object.class) {
            for (Field each : type.getDeclaredFields()) {
                int modifiers;
                if (each.isAnnotationPresent(FseIgnore.class) || Modifier.isStatic(modifiers = each.getModifiers())) continue;
                list.add(each);
            }
            type = type.getSuperclass();
        }
        Collections.sort(list, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return list;
    }

    private BuildInType getType(Class<?> fieldType) {
        if (!fieldType.isPrimitive()) {
            return BuildInType.OBJECT;
        }
        if (fieldType == Integer.TYPE) {
            return BuildInType.INT;
        }
        if (fieldType == Byte.TYPE) {
            return BuildInType.BYTE;
        }
        if (fieldType == Character.TYPE) {
            return BuildInType.CHAR;
        }
        if (fieldType == Boolean.TYPE) {
            return BuildInType.BOOLEAN;
        }
        if (fieldType == Float.TYPE) {
            return BuildInType.FLOAT;
        }
        if (fieldType == Long.TYPE) {
            return BuildInType.LONG;
        }
        if (fieldType == Short.TYPE) {
            return BuildInType.SHORT;
        }
        if (fieldType == Double.TYPE) {
            return BuildInType.DOUBLE;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void doWriteToBytes(Object o, InternalByteArray byteArray, FseContext fseContext, int depth) {
        for (Entry entry : this.entries) {
            if (!entry.array) {
                this.serializeProperty(o, byteArray, fseContext, entry, depth);
                continue;
            }
            Object property = entry.accessor.get(o);
            if (property == null) {
                byteArray.put((byte)0);
                continue;
            }
            entry.serializer.writeToBytes(entry.accessor.get(o), 1, byteArray, fseContext, depth);
        }
    }

    @Override
    public Object readBytes(InternalByteArray byteArray, FseContext fseContext) {
        Object instance = UNSAFE.allocateInstance(this.type);
        fseContext.collectObject(instance);
        for (Entry entry : this.entries) {
            if (!entry.array) {
                this.deSerializeProperty(byteArray, fseContext, instance, entry);
                continue;
            }
            int flag = byteArray.readVarInt();
            Object result = flag == 0 ? null : (flag == 1 ? entry.serializer.readBytes(byteArray, fseContext) : (flag < 0 ? fseContext.getObjectByIndex(0 - flag) : fseContext.getClassRegistry(flag).getSerializer().readBytes(byteArray, fseContext)));
            entry.accessor.setObject(instance, result);
        }
        return instance;
    }

    private void deSerializeProperty(InternalByteArray byteArray, FseContext fseContext, Object instance, Entry entry) {
        switch (entry.type) {
            case INT: {
                entry.accessor.set(instance, byteArray.readVarInt());
                break;
            }
            case BYTE: {
                entry.accessor.set(instance, byteArray.get());
                break;
            }
            case CHAR: {
                entry.accessor.set(instance, byteArray.readVarChar());
                break;
            }
            case LONG: {
                entry.accessor.set(instance, byteArray.readVarLong());
                break;
            }
            case FLOAT: {
                entry.accessor.set(instance, byteArray.readFloat());
                break;
            }
            case SHORT: {
                entry.accessor.set(instance, byteArray.readShort());
                break;
            }
            case DOUBLE: {
                entry.accessor.set(instance, byteArray.readDouble());
                break;
            }
            case BOOLEAN: {
                if (byteArray.get() == 0) {
                    entry.accessor.set(instance, true);
                    break;
                }
                entry.accessor.set(instance, false);
                break;
            }
            case OBJECT: {
                int flag = byteArray.readVarInt();
                Object result = flag == 0 ? null : (flag == 1 ? entry.serializer.readBytes(byteArray, fseContext) : (flag < 0 ? fseContext.getObjectByIndex(0 - flag) : fseContext.getClassRegistry(flag).getSerializer().readBytes(byteArray, fseContext)));
                entry.accessor.setObject(instance, result);
            }
        }
    }

    private void serializeProperty(Object o, InternalByteArray byteArray, FseContext fseContext, Entry entry, int depth) {
        switch (entry.type) {
            case INT: {
                byteArray.writeVarInt(entry.accessor.getInt(o));
                break;
            }
            case BYTE: {
                byteArray.put(entry.accessor.getByte(o));
                break;
            }
            case CHAR: {
                byteArray.writeVarChar(entry.accessor.getChar(o));
                break;
            }
            case LONG: {
                byteArray.writeVarLong(entry.accessor.getLong(o));
                break;
            }
            case FLOAT: {
                byteArray.writeFloat(entry.accessor.getFloat(o));
                break;
            }
            case SHORT: {
                byteArray.writeShort(entry.accessor.getShort(o));
                break;
            }
            case DOUBLE: {
                byteArray.writeDouble(entry.accessor.getDouble(o));
                break;
            }
            case BOOLEAN: {
                if (entry.accessor.getBoolean(o)) {
                    byteArray.put((byte)0);
                    break;
                }
                byteArray.put((byte)1);
                break;
            }
            case OBJECT: {
                Object property = entry.accessor.get(o);
                if (property == null) {
                    byteArray.put((byte)0);
                    break;
                }
                if (entry.finalType || property.getClass() == entry.fieldType) {
                    entry.serializer.writeToBytes(property, 1, byteArray, fseContext, depth);
                    break;
                }
                fseContext.serialize(property, byteArray, depth);
            }
        }
    }

    class Entry {
        Field field;
        Class fieldType;
        boolean array = false;
        boolean finalType = false;
        BuildInType type;
        ValueAccessor accessor;
        FseSerializer serializer;

        Entry() {
        }
    }

    static enum BuildInType {
        INT,
        BYTE,
        CHAR,
        BOOLEAN,
        FLOAT,
        LONG,
        SHORT,
        DOUBLE,
        OBJECT;

    }
}

