/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.fse.serializer;

import com.jfireframework.fse.CycleFlagSerializer;
import com.jfireframework.fse.FseContext;
import com.jfireframework.fse.FseSerializer;
import com.jfireframework.fse.Helper;
import com.jfireframework.fse.InternalByteArray;
import com.jfireframework.fse.SerializerFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;

public class ArraySerializer
extends CycleFlagSerializer
implements FseSerializer {
    private boolean componentTypeFinal = false;
    private FseSerializer serializer;
    private Class<?> componentType;

    @Override
    public void init(Class<?> type, SerializerFactory serializerFactory) {
        this.componentType = type.getComponentType();
        if (Modifier.isFinal(this.componentType.getModifiers())) {
            this.componentTypeFinal = true;
            this.serializer = serializerFactory.getSerializer(this.componentType);
        }
    }

    @Override
    public void doWriteToBytes(Object o, InternalByteArray byteArray, FseContext fseContext, int depth) {
        int length = ((Object[])o).length;
        byteArray.writePositive(length);
        this.writeElement((Object[])o, byteArray, fseContext, depth);
    }

    private void writeElement(Object[] o, InternalByteArray byteArray, FseContext fseContext, int depth) {
        if (this.componentTypeFinal) {
            for (Object each : o) {
                if (each == null) {
                    byteArray.put((byte)0);
                    continue;
                }
                this.serializer.writeToBytes(each, 1, byteArray, fseContext, depth);
            }
        } else {
            for (Object each : o) {
                fseContext.serialize(each, byteArray, depth);
            }
        }
    }

    @Override
    public Object readBytes(InternalByteArray byteArray, FseContext fseContext) {
        int len = byteArray.readPositive();
        return this.readElement(byteArray, fseContext, len);
    }

    private Object readElement(InternalByteArray byteArray, FseContext fseContext, int len) {
        Object[] instance = (Object[])Array.newInstance(this.componentType, len);
        fseContext.collectObject(instance);
        if (this.componentTypeFinal) {
            for (int i = 0; i < len; ++i) {
                int flag = byteArray.readVarInt();
                if (flag == 0) {
                    instance[i] = null;
                    continue;
                }
                if (flag == 1) {
                    instance[i] = this.serializer.readBytes(byteArray, fseContext);
                    continue;
                }
                if (flag < 0) {
                    instance[i] = fseContext.getObjectByIndex(0 - flag);
                    continue;
                }
                throw new IllegalStateException("\u4e0d\u5e94\u8be5\u51fa\u73b0\u6b64\u79cd\u60c5\u51b5");
            }
        } else {
            for (int i = 0; i < len; ++i) {
                instance[i] = Helper.deSerialize(byteArray, fseContext);
            }
        }
        return instance;
    }
}

