/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.fse;

import com.jfireframework.fse.FseSerializer;
import com.jfireframework.fse.serializer.ArraySerializer;
import com.jfireframework.fse.serializer.CompileObjectSerializer;
import com.jfireframework.fse.serializer.ObjectSerializer;
import com.jfireframework.fse.serializer.array.BooleanArraySerializer;
import com.jfireframework.fse.serializer.array.ByteArraySerializer;
import com.jfireframework.fse.serializer.array.CharArraySerializer;
import com.jfireframework.fse.serializer.array.DoubleArraySerializer;
import com.jfireframework.fse.serializer.array.FloatArraySerializer;
import com.jfireframework.fse.serializer.array.IntArraySerializer;
import com.jfireframework.fse.serializer.array.LongArraySerializer;
import com.jfireframework.fse.serializer.array.ShortArraySerializer;
import com.jfireframework.fse.serializer.array.StringArraySerializer;
import com.jfireframework.fse.serializer.base.BooleanSerializer;
import com.jfireframework.fse.serializer.base.ByteSerializer;
import com.jfireframework.fse.serializer.base.CharSserializer;
import com.jfireframework.fse.serializer.base.DoubleSerializer;
import com.jfireframework.fse.serializer.base.FloatSerializer;
import com.jfireframework.fse.serializer.base.IntegerSerializer;
import com.jfireframework.fse.serializer.base.LongSerializer;
import com.jfireframework.fse.serializer.base.ShortSerializer;
import com.jfireframework.fse.serializer.base.StringSerializer;
import com.jfireframework.fse.serializer.extra.ArrayListSerializer;
import com.jfireframework.fse.serializer.extra.CalendarSerializer;
import com.jfireframework.fse.serializer.extra.ClassSerializer;
import com.jfireframework.fse.serializer.extra.EnumSetSerialzer;
import com.jfireframework.fse.serializer.extra.HashMapSerializer;
import com.jfireframework.fse.serializer.extra.HashSetSerializer;
import com.jfireframework.fse.serializer.extra.LinkedListSerializer;
import com.jfireframework.fse.serializer.extra.MethodSerializer;
import com.jfireframework.fse.serializer.extra.UtilDateSerializer;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;

public class SerializerFactory {
    private Map<Class, FseSerializer> serializerMap = new IdentityHashMap<Class, FseSerializer>();
    private boolean useCompile = false;

    public SerializerFactory() {
        this.serializerMap.put(int[].class, new IntArraySerializer(true));
        this.serializerMap.put(Integer[].class, new IntArraySerializer(false));
        this.serializerMap.put(short[].class, new ShortArraySerializer(true));
        this.serializerMap.put(Short[].class, new ShortArraySerializer(false));
        this.serializerMap.put(byte[].class, new ByteArraySerializer(true));
        this.serializerMap.put(Byte[].class, new ByteArraySerializer(false));
        this.serializerMap.put(float[].class, new FloatArraySerializer(true));
        this.serializerMap.put(Float[].class, new FloatArraySerializer(false));
        this.serializerMap.put(double[].class, new DoubleArraySerializer(true));
        this.serializerMap.put(Double[].class, new DoubleArraySerializer(false));
        this.serializerMap.put(long[].class, new LongArraySerializer(true));
        this.serializerMap.put(Long[].class, new LongArraySerializer(false));
        this.serializerMap.put(char[].class, new CharArraySerializer(true));
        this.serializerMap.put(Character[].class, new CharArraySerializer(false));
        this.serializerMap.put(boolean[].class, new BooleanArraySerializer(true));
        this.serializerMap.put(Boolean[].class, new BooleanArraySerializer(false));
        this.serializerMap.put(String[].class, new StringArraySerializer());
        this.serializerMap.put(Integer.class, new IntegerSerializer());
        this.serializerMap.put(Short.class, new ShortSerializer());
        this.serializerMap.put(Byte.class, new ByteSerializer());
        this.serializerMap.put(Long.class, new LongSerializer());
        this.serializerMap.put(Float.class, new FloatSerializer());
        this.serializerMap.put(Character.class, new CharSserializer());
        this.serializerMap.put(Double.class, new DoubleSerializer());
        this.serializerMap.put(Boolean.class, new BooleanSerializer());
        this.serializerMap.put(String.class, new StringSerializer());
        this.serializerMap.put(ArrayList.class, new ArrayListSerializer());
        this.serializerMap.put(Calendar.class, new CalendarSerializer());
        this.serializerMap.put(Class.class, new ClassSerializer());
        this.serializerMap.put(HashMap.class, new HashMapSerializer());
        this.serializerMap.put(HashSet.class, new HashSetSerializer());
        this.serializerMap.put(LinkedList.class, new LinkedListSerializer());
        this.serializerMap.put(java.util.Date.class, new UtilDateSerializer());
        this.serializerMap.put(Date.class, new UtilDateSerializer());
        this.serializerMap.put(Object.class, new ObjectSerializer());
        this.serializerMap.put(Calendar.getInstance().getClass(), new CalendarSerializer());
        this.serializerMap.put(Method.class, new MethodSerializer());
    }

    public FseSerializer getSerializer(Class type) {
        FseSerializer fseSerializer = this.serializerMap.get(type);
        if (fseSerializer != null) {
            return fseSerializer;
        }
        fseSerializer = EnumSet.class.isAssignableFrom(type) ? new EnumSetSerialzer() : (type.isArray() ? new ArraySerializer() : (this.useCompile ? new CompileObjectSerializer() : new ObjectSerializer()));
        this.serializerMap.put(type, fseSerializer);
        fseSerializer.init(type, this);
        return fseSerializer;
    }

    public void setUseCompile(boolean useCompile) {
        this.useCompile = useCompile;
    }

    public void register(Class ckass, FseSerializer fseSerializer) {
        this.serializerMap.put(ckass, fseSerializer);
    }
}

