/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.fse;

import com.jfireframework.fse.ByteArray;

public class InternalByteArray
extends ByteArray {
    public InternalByteArray(int size) {
        super(size);
    }

    public InternalByteArray(byte[] array) {
        super(array);
    }

    public void writeVarInt(int i) {
        if (i >= -120 && i <= 127) {
            this.ensureCapacity(1);
            this.array[this.writePosi] = (byte)i;
            ++this.writePosi;
        } else {
            int head = -120;
            if (i < 0) {
                i ^= 0xFFFFFFFF;
                head = -124;
            }
            if (i <= 255) {
                this.ensureCapacity(2);
                this.array[this.writePosi] = (byte)(head - 1);
                this.array[this.writePosi + 1] = (byte)i;
                this.writePosi += 2;
            } else if (i <= 65535) {
                this.ensureCapacity(3);
                this.array[this.writePosi] = (byte)(head - 2);
                this.array[this.writePosi + 1] = (byte)(i >>> 8);
                this.array[this.writePosi + 2] = (byte)i;
                this.writePosi += 3;
            } else if (i <= 0xFFFFFF) {
                this.ensureCapacity(4);
                this.array[this.writePosi] = (byte)(head - 3);
                this.array[this.writePosi + 1] = (byte)(i >>> 16);
                this.array[this.writePosi + 2] = (byte)(i >>> 8);
                this.array[this.writePosi + 3] = (byte)i;
                this.writePosi += 4;
            } else {
                this.ensureCapacity(5);
                this.array[this.writePosi] = (byte)(head - 4);
                this.array[this.writePosi + 1] = (byte)(i >>> 24);
                this.array[this.writePosi + 2] = (byte)(i >>> 16);
                this.array[this.writePosi + 3] = (byte)(i >>> 8);
                this.array[this.writePosi + 4] = (byte)i;
                this.writePosi += 5;
            }
        }
    }

    public int readVarInt() {
        byte b;
        if ((b = this.array[this.readIndex++]) >= -120 && b <= 127) {
            return b;
        }
        switch (b) {
            case -128: {
                return ~((this.array[this.readIndex++] & 0xFF) << 24 | (this.array[this.readIndex++] & 0xFF) << 16 | (this.array[this.readIndex++] & 0xFF) << 8 | this.array[this.readIndex++] & 0xFF);
            }
            case -127: {
                return ~((this.array[this.readIndex++] & 0xFF) << 16 | (this.array[this.readIndex++] & 0xFF) << 8 | this.array[this.readIndex++] & 0xFF);
            }
            case -126: {
                return ~((this.array[this.readIndex++] & 0xFF) << 8 | this.array[this.readIndex++] & 0xFF);
            }
            case -125: {
                return ~(this.array[this.readIndex++] & 0xFF);
            }
            case -124: {
                return (this.array[this.readIndex++] & 0xFF) << 24 | (this.array[this.readIndex++] & 0xFF) << 16 | (this.array[this.readIndex++] & 0xFF) << 8 | this.array[this.readIndex++] & 0xFF;
            }
            case -123: {
                return (this.array[this.readIndex++] & 0xFF) << 16 | (this.array[this.readIndex++] & 0xFF) << 8 | this.array[this.readIndex++] & 0xFF;
            }
            case -122: {
                return (this.array[this.readIndex++] & 0xFF) << 8 | this.array[this.readIndex++] & 0xFF;
            }
            case -121: {
                return this.array[this.readIndex++] & 0xFF;
            }
        }
        throw new IllegalArgumentException("not here");
    }

    public void writeVarLong(long i) {
        if (i >= -112L && i <= 127L) {
            this.ensureCapacity(1);
            this.array[this.writePosi] = (byte)i;
            ++this.writePosi;
        } else {
            int head = -112;
            if (i < 0L) {
                i ^= 0xFFFFFFFFFFFFFFFFL;
                head = -120;
            }
            if (i <= 255L) {
                this.ensureCapacity(2);
                this.array[this.writePosi] = (byte)(head - 1);
                this.array[this.writePosi + 1] = (byte)i;
                this.writePosi += 2;
            } else if (i <= 65535L) {
                this.ensureCapacity(3);
                this.array[this.writePosi] = (byte)(head - 2);
                this.array[this.writePosi + 1] = (byte)(i >>> 8);
                this.array[this.writePosi + 2] = (byte)i;
                this.writePosi += 3;
            } else if (i <= 0xFFFFFFL) {
                this.ensureCapacity(4);
                this.array[this.writePosi] = (byte)(head - 3);
                this.array[this.writePosi + 1] = (byte)(i >>> 16);
                this.array[this.writePosi + 2] = (byte)(i >>> 8);
                this.array[this.writePosi + 3] = (byte)i;
                this.writePosi += 4;
            } else if (i <= -1L) {
                this.ensureCapacity(5);
                this.array[this.writePosi] = (byte)(head - 4);
                this.array[this.writePosi + 1] = (byte)(i >>> 24);
                this.array[this.writePosi + 2] = (byte)(i >>> 16);
                this.array[this.writePosi + 3] = (byte)(i >>> 8);
                this.array[this.writePosi + 4] = (byte)i;
                this.writePosi += 5;
            } else if (i <= 0xFFFFFFFFFFL) {
                this.ensureCapacity(6);
                this.array[this.writePosi] = (byte)(head - 5);
                this.array[this.writePosi + 1] = (byte)(i >>> 32);
                this.array[this.writePosi + 2] = (byte)(i >>> 24);
                this.array[this.writePosi + 3] = (byte)(i >>> 16);
                this.array[this.writePosi + 4] = (byte)(i >>> 8);
                this.array[this.writePosi + 5] = (byte)i;
                this.writePosi += 6;
            } else if (i <= 0xFFFFFFFFFFFFL) {
                this.ensureCapacity(7);
                this.array[this.writePosi] = (byte)(head - 6);
                this.array[this.writePosi + 1] = (byte)(i >>> 40);
                this.array[this.writePosi + 2] = (byte)(i >>> 32);
                this.array[this.writePosi + 3] = (byte)(i >>> 24);
                this.array[this.writePosi + 4] = (byte)(i >>> 16);
                this.array[this.writePosi + 5] = (byte)(i >>> 8);
                this.array[this.writePosi + 6] = (byte)i;
                this.writePosi += 7;
            } else if (i <= 0xFFFFFFFFFFFFFFL) {
                this.ensureCapacity(8);
                this.array[this.writePosi] = (byte)(head - 7);
                this.array[this.writePosi + 1] = (byte)(i >>> 48);
                this.array[this.writePosi + 2] = (byte)(i >>> 40);
                this.array[this.writePosi + 3] = (byte)(i >>> 32);
                this.array[this.writePosi + 4] = (byte)(i >>> 24);
                this.array[this.writePosi + 5] = (byte)(i >>> 16);
                this.array[this.writePosi + 6] = (byte)(i >>> 8);
                this.array[this.writePosi + 7] = (byte)i;
                this.writePosi += 8;
            } else {
                this.ensureCapacity(9);
                this.array[this.writePosi] = (byte)(head - 8);
                this.array[this.writePosi + 1] = (byte)(i >>> 56);
                this.array[this.writePosi + 2] = (byte)(i >>> 48);
                this.array[this.writePosi + 3] = (byte)(i >>> 40);
                this.array[this.writePosi + 4] = (byte)(i >>> 32);
                this.array[this.writePosi + 5] = (byte)(i >>> 24);
                this.array[this.writePosi + 6] = (byte)(i >>> 16);
                this.array[this.writePosi + 7] = (byte)(i >>> 8);
                this.array[this.writePosi + 8] = (byte)i;
                this.writePosi += 9;
            }
        }
    }

    public long readVarLong() {
        byte b;
        if ((b = this.array[this.readIndex++]) >= -112 && b <= 127) {
            return b;
        }
        switch (b) {
            case -128: {
                return (((long)this.array[this.readIndex++] & 0xFFL) << 56 | ((long)this.array[this.readIndex++] & 0xFFL) << 48 | ((long)this.array[this.readIndex++] & 0xFFL) << 40 | ((long)this.array[this.readIndex++] & 0xFFL) << 32 | ((long)this.array[this.readIndex++] & 0xFFL) << 24 | ((long)this.array[this.readIndex++] & 0xFFL) << 16 | ((long)this.array[this.readIndex++] & 0xFFL) << 8 | (long)this.array[this.readIndex++] & 0xFFL) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case -127: {
                return (((long)this.array[this.readIndex++] & 0xFFL) << 48 | ((long)this.array[this.readIndex++] & 0xFFL) << 40 | ((long)this.array[this.readIndex++] & 0xFFL) << 32 | ((long)this.array[this.readIndex++] & 0xFFL) << 24 | ((long)this.array[this.readIndex++] & 0xFFL) << 16 | ((long)this.array[this.readIndex++] & 0xFFL) << 8 | (long)this.array[this.readIndex++] & 0xFFL) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case -126: {
                return (((long)this.array[this.readIndex++] & 0xFFL) << 40 | ((long)this.array[this.readIndex++] & 0xFFL) << 32 | ((long)this.array[this.readIndex++] & 0xFFL) << 24 | ((long)this.array[this.readIndex++] & 0xFFL) << 16 | ((long)this.array[this.readIndex++] & 0xFFL) << 8 | (long)this.array[this.readIndex++] & 0xFFL) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case -125: {
                return (((long)this.array[this.readIndex++] & 0xFFL) << 32 | ((long)this.array[this.readIndex++] & 0xFFL) << 24 | ((long)this.array[this.readIndex++] & 0xFFL) << 16 | ((long)this.array[this.readIndex++] & 0xFFL) << 8 | (long)this.array[this.readIndex++] & 0xFFL) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case -124: {
                return (((long)this.array[this.readIndex++] & 0xFFL) << 24 | ((long)this.array[this.readIndex++] & 0xFFL) << 16 | ((long)this.array[this.readIndex++] & 0xFFL) << 8 | (long)this.array[this.readIndex++] & 0xFFL) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case -123: {
                return (((long)this.array[this.readIndex++] & 0xFFL) << 16 | ((long)this.array[this.readIndex++] & 0xFFL) << 8 | (long)this.array[this.readIndex++] & 0xFFL) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case -122: {
                return (((long)this.array[this.readIndex++] & 0xFFL) << 8 | (long)this.array[this.readIndex++] & 0xFFL) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case -121: {
                return (long)this.array[this.readIndex++] & 0xFFL ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case -120: {
                return ((long)this.array[this.readIndex++] & 0xFFL) << 56 | ((long)this.array[this.readIndex++] & 0xFFL) << 48 | ((long)this.array[this.readIndex++] & 0xFFL) << 40 | ((long)this.array[this.readIndex++] & 0xFFL) << 32 | ((long)this.array[this.readIndex++] & 0xFFL) << 24 | ((long)this.array[this.readIndex++] & 0xFFL) << 16 | ((long)this.array[this.readIndex++] & 0xFFL) << 8 | (long)this.array[this.readIndex++] & 0xFFL;
            }
            case -119: {
                return ((long)this.array[this.readIndex++] & 0xFFL) << 48 | ((long)this.array[this.readIndex++] & 0xFFL) << 40 | ((long)this.array[this.readIndex++] & 0xFFL) << 32 | ((long)this.array[this.readIndex++] & 0xFFL) << 24 | ((long)this.array[this.readIndex++] & 0xFFL) << 16 | ((long)this.array[this.readIndex++] & 0xFFL) << 8 | (long)this.array[this.readIndex++] & 0xFFL;
            }
            case -118: {
                return ((long)this.array[this.readIndex++] & 0xFFL) << 40 | ((long)this.array[this.readIndex++] & 0xFFL) << 32 | ((long)this.array[this.readIndex++] & 0xFFL) << 24 | ((long)this.array[this.readIndex++] & 0xFFL) << 16 | ((long)this.array[this.readIndex++] & 0xFFL) << 8 | (long)this.array[this.readIndex++] & 0xFFL;
            }
            case -117: {
                return ((long)this.array[this.readIndex++] & 0xFFL) << 32 | ((long)this.array[this.readIndex++] & 0xFFL) << 24 | ((long)this.array[this.readIndex++] & 0xFFL) << 16 | ((long)this.array[this.readIndex++] & 0xFFL) << 8 | (long)this.array[this.readIndex++] & 0xFFL;
            }
            case -116: {
                return ((long)this.array[this.readIndex++] & 0xFFL) << 24 | ((long)this.array[this.readIndex++] & 0xFFL) << 16 | ((long)this.array[this.readIndex++] & 0xFFL) << 8 | (long)this.array[this.readIndex++] & 0xFFL;
            }
            case -115: {
                return ((long)this.array[this.readIndex++] & 0xFFL) << 16 | ((long)this.array[this.readIndex++] & 0xFFL) << 8 | (long)this.array[this.readIndex++] & 0xFFL;
            }
            case -114: {
                return ((long)this.array[this.readIndex++] & 0xFFL) << 8 | (long)this.array[this.readIndex++] & 0xFFL;
            }
            case -113: {
                return (long)this.array[this.readIndex++] & 0xFFL;
            }
        }
        throw new IllegalArgumentException("not here");
    }

    public void writeVarCharWithoutCheck(char c) {
        if (c <= '\u00fb') {
            this.array[this.writePosi] = (byte)c;
            ++this.writePosi;
        } else if (c <= '\u00ff') {
            this.array[this.writePosi] = -4;
            this.array[this.writePosi + 1] = (byte)c;
            this.writePosi += 2;
        } else if (c <= '\uffff') {
            this.array[this.writePosi] = -3;
            this.array[this.writePosi + 1] = (byte)(c >>> 8);
            this.array[this.writePosi + 2] = (byte)c;
            this.writePosi += 3;
        }
    }

    public void writeVarChar(char c) {
        if (c <= '\u00fb') {
            this.ensureCapacity(1);
            this.array[this.writePosi] = (byte)c;
            ++this.writePosi;
        } else if (c <= '\u00ff') {
            this.ensureCapacity(2);
            this.array[this.writePosi] = -4;
            this.array[this.writePosi + 1] = (byte)c;
            this.writePosi += 2;
        } else if (c <= '\uffff') {
            this.ensureCapacity(3);
            this.array[this.writePosi] = -3;
            this.array[this.writePosi + 1] = (byte)(c >>> 8);
            this.array[this.writePosi + 2] = (byte)c;
            this.writePosi += 3;
        }
    }

    public char readVarChar() {
        int length;
        if ((length = this.array[this.readIndex++] & 0xFF) <= 251) {
            return (char)length;
        }
        if (length == 252) {
            length = this.array[this.readIndex++] & 0xFF;
            return (char)length;
        }
        if (length == 253) {
            length = (this.array[this.readIndex++] & 0xFF) << 8;
            return (char)(length |= this.array[this.readIndex++] & 0xFF);
        }
        throw new IllegalArgumentException("not here");
    }

    public void writePositive(int positive) {
        if (positive < 0) {
            throw new UnsupportedOperationException();
        }
        if (positive <= 251) {
            this.ensureCapacity(1);
            this.array[this.writePosi] = (byte)positive;
            ++this.writePosi;
        } else if (positive <= 255) {
            this.ensureCapacity(2);
            this.array[this.writePosi] = -4;
            this.array[this.writePosi + 1] = (byte)positive;
            this.writePosi += 2;
        } else if (positive <= 65535) {
            this.ensureCapacity(3);
            this.array[this.writePosi] = -3;
            this.array[this.writePosi + 1] = (byte)(positive >>> 8);
            this.array[this.writePosi + 2] = (byte)positive;
            this.writePosi += 3;
        } else if (positive <= 0xFFFFFF) {
            this.ensureCapacity(4);
            this.array[this.writePosi] = -2;
            this.array[this.writePosi + 1] = (byte)(positive >>> 16);
            this.array[this.writePosi + 2] = (byte)(positive >>> 8);
            this.array[this.writePosi + 3] = (byte)positive;
            this.writePosi += 4;
        } else {
            this.ensureCapacity(5);
            this.array[this.writePosi] = -1;
            this.array[this.writePosi + 1] = (byte)(positive >>> 24);
            this.array[this.writePosi + 2] = (byte)(positive >>> 16);
            this.array[this.writePosi + 3] = (byte)(positive >>> 8);
            this.array[this.writePosi + 4] = (byte)positive;
            this.writePosi += 5;
        }
    }

    public int readPositive() {
        int length;
        if ((length = this.array[this.readIndex++] & 0xFF) <= 251) {
            return length;
        }
        if (length == 252) {
            length = this.array[this.readIndex++] & 0xFF;
            return length;
        }
        if (length == 253) {
            length = (this.array[this.readIndex++] & 0xFF) << 8;
            return length |= this.array[this.readIndex++] & 0xFF;
        }
        if (length == 254) {
            length = (this.array[this.readIndex++] & 0xFF) << 16;
            length |= (this.array[this.readIndex++] & 0xFF) << 8;
            return length |= this.array[this.readIndex++] & 0xFF;
        }
        if (length == 255) {
            length = (this.array[this.readIndex++] & 0xFF) << 24;
            length |= (this.array[this.readIndex++] & 0xFF) << 16;
            length |= (this.array[this.readIndex++] & 0xFF) << 8;
            return length |= this.array[this.readIndex++] & 0xFF;
        }
        throw new RuntimeException("wrong data");
    }

    public void writeInt(int i) {
        this.ensureCapacity(4);
        this.array[this.writePosi] = (byte)(i >> 24);
        this.array[this.writePosi + 1] = (byte)(i >> 16);
        this.array[this.writePosi + 2] = (byte)(i >> 8);
        this.array[this.writePosi + 3] = (byte)i;
        this.writePosi += 4;
    }

    public void writeShort(short s) {
        this.ensureCapacity(2);
        this.array[this.writePosi] = (byte)(s >> 8);
        this.array[this.writePosi + 1] = (byte)s;
        this.writePosi += 2;
    }

    public void writeLong(long l) {
        this.ensureCapacity(8);
        this.array[this.writePosi] = (byte)(l >> 56);
        this.array[this.writePosi + 1] = (byte)(l >> 48);
        this.array[this.writePosi + 2] = (byte)(l >> 40);
        this.array[this.writePosi + 3] = (byte)(l >> 32);
        this.array[this.writePosi + 4] = (byte)(l >> 24);
        this.array[this.writePosi + 5] = (byte)(l >> 16);
        this.array[this.writePosi + 6] = (byte)(l >> 8);
        this.array[this.writePosi + 7] = (byte)l;
        this.writePosi += 8;
    }

    public int readInt() {
        int i = (this.array[this.readIndex] & 0xFF) << 24;
        i |= (this.array[this.readIndex + 1] & 0xFF) << 16;
        i |= (this.array[this.readIndex + 2] & 0xFF) << 8;
        this.readIndex += 4;
        return i |= this.array[this.readIndex + 3] & 0xFF;
    }

    public short readShort() {
        short s = (short)((this.array[this.readIndex] & 0xFF) << 8);
        s = (short)(s | this.array[this.readIndex + 1] & 0xFF);
        this.readIndex += 2;
        return s;
    }

    public long readLong() {
        long l = (long)this.array[this.readIndex] << 56 | ((long)this.array[this.readIndex + 1] & 0xFFL) << 48 | ((long)this.array[this.readIndex + 2] & 0xFFL) << 40 | ((long)this.array[this.readIndex + 3] & 0xFFL) << 32 | ((long)this.array[this.readIndex + 4] & 0xFFL) << 24 | ((long)this.array[this.readIndex + 5] & 0xFFL) << 16 | ((long)this.array[this.readIndex + 6] & 0xFFL) << 8 | (long)this.array[this.readIndex + 7] & 0xFFL;
        this.readIndex += 8;
        return l;
    }

    public void writeFloat(float f) {
        this.writeInt(Float.floatToRawIntBits(f));
    }

    public void writeDouble(double d) {
        this.writeLong(Double.doubleToRawLongBits(d));
    }

    public float readFloat() {
        int i = this.readInt();
        return Float.intBitsToFloat(i);
    }

    public double readDouble() {
        long l = this.readLong();
        return Double.longBitsToDouble(l);
    }

    public void skipWrite(int len) {
        this.ensureCapacity(len);
        this.writePosi += len;
    }

    public void writeString(String value) {
        if (value == null) {
            this.writeVarInt(-1);
        } else {
            int length = value.length();
            this.writeVarInt(length);
            this.ensureCapacity(3 * length);
            for (int i = 0; i < length; ++i) {
                this.writeVarCharWithoutCheck(value.charAt(i));
            }
        }
    }

    public String readString() {
        int length = this.readVarInt();
        if (length == -1) {
            return null;
        }
        char[] src = new char[length];
        for (int i = 0; i < length; ++i) {
            src[i] = this.readVarChar();
        }
        return new String(src);
    }

    public boolean remainRead() {
        return this.readIndex < this.writePosi;
    }
}

