/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.fse;

import com.jfireframework.baseutil.reflect.ReflectUtil;
import com.jfireframework.fse.FseSerializer;
import com.jfireframework.fse.InternalByteArray;
import com.jfireframework.fse.SerializerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public class ClassRegistry {
    private Entry[] entries = new Entry[64];
    private final int startIndex = 2;
    private int sequence = 2;
    private int buildInIndex = 2;
    private SerializerFactory serializerFactory;
    private Map<String, Class> nameToClass = new HashMap<String, Class>();

    public ClassRegistry(SerializerFactory serializerFactory) {
        this.serializerFactory = serializerFactory;
        this.processBuildIn();
    }

    private void processBuildIn() {
        LinkedList<Class<Method>> buildIn = new LinkedList<Class<Method>>();
        buildIn.add(int[].class);
        buildIn.add(byte[].class);
        buildIn.add(char[].class);
        buildIn.add(short[].class);
        buildIn.add(long[].class);
        buildIn.add(double[].class);
        buildIn.add(float[].class);
        buildIn.add(boolean[].class);
        buildIn.add(String.class);
        buildIn.add(Integer.class);
        buildIn.add(Float.class);
        buildIn.add(Double.class);
        buildIn.add(Short.class);
        buildIn.add(Byte.class);
        buildIn.add(Character.class);
        buildIn.add(Boolean.class);
        buildIn.add(Long.class);
        buildIn.add(Object.class);
        buildIn.add(LinkedList.class);
        buildIn.add(ArrayList.class);
        buildIn.add(HashSet.class);
        buildIn.add(HashMap.class);
        buildIn.add(Method.class);
        for (Class clazz : buildIn) {
            this.register(clazz);
        }
    }

    public void register(Class<?> ckass) {
        if (this.sequence != this.buildInIndex) {
            throw new IllegalStateException();
        }
        int id = this.getEntry(ckass).getId();
        if (id < 0) {
            throw new IllegalArgumentException("\u8be5\u5bf9\u8c61\u5df2\u7ecf\u6ce8\u518c\u8fc7");
        }
        if (this.sequence != this.buildInIndex + 1) {
            throw new IllegalArgumentException("\u4e0d\u80fd\u5728\u6536\u96c6\u4e86\u81ea\u5b9a\u4e49\u5bf9\u8c61\u540e\u6ce8\u518c\u5bf9\u8c61");
        }
        ++this.buildInIndex;
    }

    public Entry getEntry(int id) {
        return this.entries[id];
    }

    public Entry getEntry(Class<?> src) {
        for (int i = 2; i < this.sequence; ++i) {
            Entry entry = this.entries[i];
            if (entry.ckass != src) continue;
            return entry;
        }
        if (this.sequence == this.entries.length) {
            Entry[] tmp = new Entry[this.entries.length << 1];
            System.arraycopy(this.entries, 0, tmp, 0, this.entries.length);
            this.entries = tmp;
        }
        Entry entry = new Entry();
        entry.setCkass(src);
        entry.setId(this.sequence);
        entry.setSerializer(this.serializerFactory.getSerializer(src));
        this.entries[this.sequence] = entry;
        ++this.sequence;
        return entry;
    }

    public void clear() {
        for (int i = this.buildInIndex; i < this.sequence; ++i) {
            this.entries[i] = null;
        }
        this.sequence = this.buildInIndex;
    }

    public void serializeClass(InternalByteArray byteArray) {
        for (int i = this.buildInIndex; i < this.sequence; ++i) {
            String name = this.entries[i].getCkass().getName();
            byteArray.writeString(name);
        }
    }

    public void deSerializeClass(InternalByteArray byteArray) {
        while (byteArray.remainRead()) {
            String s = byteArray.readString();
            Class<?> aClass = this.nameToClass.get(s);
            if (aClass == null) {
                try {
                    aClass = Class.forName(s);
                    this.nameToClass.put(s, aClass);
                }
                catch (ClassNotFoundException e) {
                    ReflectUtil.throwException((Throwable)e);
                }
            }
            this.getEntry(aClass);
        }
    }

    public static class Entry {
        Class ckass;
        int id;
        FseSerializer serializer;

        public Class getCkass() {
            return this.ckass;
        }

        public void setCkass(Class ckass) {
            this.ckass = ckass;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public FseSerializer getSerializer() {
            return this.serializer;
        }

        public void setSerializer(FseSerializer serializer) {
            this.serializer = serializer;
        }
    }
}

