/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.fse;

import com.jfireframework.fse.InternalByteArray;

public class ByteArray {
    protected byte[] array;
    protected int writePosi = 0;
    protected int readIndex = 0;
    protected boolean needCheck = true;

    protected ByteArray(int size) {
        this.array = new byte[size];
    }

    protected ByteArray(byte[] array) {
        this.array = array;
    }

    public static ByteArray allocate(int size) {
        return new InternalByteArray(size);
    }

    public static ByteArray allocate() {
        return new InternalByteArray(1024);
    }

    public static ByteArray wrap(byte[] array) {
        return new InternalByteArray(array);
    }

    public void setNeedCheck(boolean needCheck) {
        this.needCheck = needCheck;
    }

    protected void ensureCapacity(int len) {
        if (this.needCheck && len > this.array.length - this.writePosi) {
            int newLen = len + this.writePosi > this.array.length << 1 ? len + this.writePosi + this.array.length : this.array.length << 1;
            byte[] tmp = new byte[newLen];
            System.arraycopy(this.array, 0, tmp, 0, this.array.length);
            this.array = tmp;
        }
    }

    public void clear() {
        this.readIndex = 0;
        this.writePosi = 0;
    }

    public void put(byte value) {
        this.ensureCapacity(1);
        this.array[this.writePosi] = value;
        ++this.writePosi;
    }

    public void setByte(int off, byte b) {
        this.array[off] = b;
    }

    public void put(byte[] data) {
        this.ensureCapacity(data.length);
        System.arraycopy(data, 0, this.array, this.writePosi, data.length);
        this.writePosi += data.length;
    }

    public byte get() {
        byte result = this.array[this.readIndex];
        ++this.readIndex;
        return result;
    }

    public byte[] toArray() {
        byte[] result = new byte[this.writePosi];
        System.arraycopy(this.array, 0, result, 0, this.writePosi);
        return result;
    }

    public int getWritePosi() {
        return this.writePosi;
    }

    public void setWritePosi(int writePosi) {
        this.writePosi = writePosi;
    }

    public void setReadPosi(int readPosi) {
        this.readIndex = readPosi;
    }
}

