/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil.reflect;

import com.jfireframework.baseutil.reflect.ParalLock;
import com.jfireframework.baseutil.reflect.ReflectUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class HotswapClassLoader
extends ClassLoader {
    private static final Map<String, classInfo> classInfos = new HashMap<String, classInfo>();
    private static final ParalLock PARAL_LOCK = new ParalLock();
    private final ClassLoader parent;
    private final ConcurrentHashMap<String, Class<?>> reloadClassMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<?>> immutableClassMap = new ConcurrentHashMap();
    private final Set<String> excludeClasses = new HashSet<String>();
    private String[] reloadPackages = new String[0];
    private File[] reloadPaths = new File[0];

    public HotswapClassLoader() {
        this.parent = Thread.currentThread().getContextClassLoader();
    }

    public HotswapClassLoader(HotswapClassLoader classLoader) {
        this.parent = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
    }

    public static void addLibPath(String libPath) {
        File[] files;
        for (File file : files = new File(libPath).listFiles()) {
            if (file.isDirectory() || !file.getName().endsWith(".jar")) continue;
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException e) {
                ReflectUtil.throwException(e);
                return;
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String entryName = jarEntry.getName();
                if (jarEntry.isDirectory() || !entryName.endsWith(".class")) continue;
                String className = entryName.substring(0, entryName.length() - 6);
                className = className.replaceAll("/", ".");
                classInfos.put(className, new classInfo(jarEntry, file.getAbsolutePath()));
            }
            try {
                jarFile.close();
            }
            catch (IOException e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void setReloadPaths(String ... paths) {
        LinkedList<File> files = new LinkedList<File>();
        for (String each : paths) {
            files.add(new File(each));
        }
        this.reloadPaths = files.toArray(new File[files.size()]);
    }

    public void setExcludeClasses(String ... excludeClasses) {
        for (String each : excludeClasses) {
            this.excludeClasses.add(each);
        }
    }

    public void setReloadPackages(String ... packages) {
        this.reloadPackages = packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> c = null;
        c = this.immutableClassMap.get(name);
        if (c != null) {
            return c;
        }
        c = this.reloadClassMap.get(name);
        if (c != null) {
            return c;
        }
        Object object = PARAL_LOCK.getLock(name);
        synchronized (object) {
            boolean exclude = false;
            if (this.excludeClasses.contains(name)) {
                exclude = true;
            }
            if (!exclude) {
                for (String each : this.reloadPackages) {
                    if (!name.startsWith(each)) continue;
                    try {
                        if (classInfos.containsKey(name)) {
                            classInfo classInfo2 = classInfos.get(name);
                            JarFile jarFile = null;
                            InputStream inputStream = null;
                            try {
                                jarFile = new JarFile(classInfo2.jarPath);
                                inputStream = jarFile.getInputStream(classInfo2.jarEntry);
                                byte[] src = new byte[inputStream.available()];
                                inputStream.read(src);
                                c = this.defineClass(name, src, 0, src.length);
                                this.reloadClassMap.put(name, c);
                                Class<?> clazz = c;
                                return clazz;
                            }
                            finally {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                if (jarFile != null) {
                                    jarFile.close();
                                }
                            }
                        }
                        for (File pathFile : this.reloadPaths) {
                            File file = new File(pathFile, name.replace(".", "/") + ".class");
                            if (!file.exists()) continue;
                            FileInputStream inputStream = null;
                            try {
                                inputStream = new FileInputStream(file);
                                byte[] src = new byte[inputStream.available()];
                                inputStream.read(src);
                                c = this.defineClass(name, src, 0, src.length);
                                this.reloadClassMap.put(name, c);
                                Class<?> clazz = c;
                                return clazz;
                            }
                            finally {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            }
            if (c == null) {
                c = this.parent.loadClass(name);
                if (c == null) {
                    throw new ClassNotFoundException(name);
                }
                this.resolveClass(c);
            }
            this.immutableClassMap.put(name, c);
            return c;
        }
    }

    static class classInfo {
        private final JarEntry jarEntry;
        private final String jarPath;

        public classInfo(JarEntry jarEntry, String jarPath) {
            this.jarEntry = jarEntry;
            this.jarPath = jarPath;
        }
    }
}

