/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil.concurrent;

import java.util.concurrent.locks.LockSupport;

public class SingleSync {
    protected Thread owner;
    protected volatile boolean finished = false;
    protected volatile boolean await = false;

    public void signal() {
        this.finished = true;
        if (this.await) {
            LockSupport.unpark(this.owner);
        }
    }

    public void await() {
        this.owner = Thread.currentThread();
        this.await = true;
        while (!this.finished) {
            LockSupport.park();
        }
    }

    public String toString() {
        Thread t = this.owner;
        if (t == null || !this.await) {
            return "no waiter";
        }
        return "thread:" + t.getName() + " is waiting";
    }

    public void reset() {
        this.owner = null;
        this.finished = false;
        this.await = false;
    }
}

