/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil.bytecode.support;

import com.jfireframework.baseutil.bytecode.support.AnnotationContext;
import com.jfireframework.baseutil.bytecode.support.AnnotationContextFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class CacheableAnnotationContextFactory
implements AnnotationContextFactory {
    protected IdentityHashMap<Method, AnnotationContext> methodAnnotationContextStore = new IdentityHashMap();
    protected Map<String, AnnotationContext> resourceNameAnnotationContextStore = new HashMap<String, AnnotationContext>();
    protected IdentityHashMap<Field, AnnotationContext> fieldAnnotationContextStore = new IdentityHashMap();

    protected abstract AnnotationContext build(String var1, ClassLoader var2);

    protected abstract AnnotationContext build(Method var1, ClassLoader var2);

    @Override
    public AnnotationContext get(Class<?> ckass, ClassLoader classLoader) {
        return this.get(ckass.getName().replace('.', '/'), classLoader);
    }

    @Override
    public AnnotationContext get(Method method, ClassLoader classLoader) {
        AnnotationContext annotationContext = this.methodAnnotationContextStore.get(method);
        if (annotationContext != null) {
            return annotationContext;
        }
        annotationContext = this.build(method, classLoader);
        this.methodAnnotationContextStore.put(method, annotationContext);
        return annotationContext;
    }

    @Override
    public AnnotationContext get(String resourceName, ClassLoader classLoader) {
        AnnotationContext annotationContext = this.resourceNameAnnotationContextStore.get(resourceName);
        if (annotationContext != null) {
            return annotationContext;
        }
        annotationContext = this.build(resourceName, classLoader);
        this.resourceNameAnnotationContextStore.put(resourceName, annotationContext);
        return annotationContext;
    }

    @Override
    public AnnotationContext get(Field field, ClassLoader classLoader) {
        AnnotationContext annotationContext = this.fieldAnnotationContextStore.get(field);
        if (annotationContext != null) {
            return annotationContext;
        }
        annotationContext = this.build(field, classLoader);
        this.fieldAnnotationContextStore.put(field, annotationContext);
        return annotationContext;
    }

    protected abstract AnnotationContext build(Field var1, ClassLoader var2);

    @Override
    public AnnotationContext get(Class<?> ckass) {
        return this.get(ckass, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public AnnotationContext get(String resourceName) {
        return this.get(resourceName, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public AnnotationContext get(Method method) {
        return this.get(method, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public AnnotationContext get(Field field) {
        return this.get(field, Thread.currentThread().getContextClassLoader());
    }
}

