/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil.bytecode.structure.Attribute;

import com.jfireframework.baseutil.bytecode.structure.Attribute.AttributeInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.ConstantInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.Utf8Info;
import com.jfireframework.baseutil.bytecode.util.BinaryData;
import java.util.Arrays;
import java.util.Comparator;

public class LocalVariableTableAttriInfo
extends AttributeInfo {
    private int local_variable_table_length;
    private LocalVariableTableEntry[] entries;

    public LocalVariableTableAttriInfo(String name, int length) {
        super(name, length);
    }

    @Override
    public String toString() {
        return "LocalVariableTableAttriInfo{entries=" + Arrays.toString(this.entries) + '}';
    }

    @Override
    protected void resolve(BinaryData binaryData, ConstantInfo[] constantInfos) {
        this.local_variable_table_length = binaryData.readShort();
        this.entries = new LocalVariableTableEntry[this.local_variable_table_length];
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = new LocalVariableTableEntry();
            this.entries[i].resolve(binaryData, constantInfos);
        }
        Arrays.sort(this.entries, new Comparator<LocalVariableTableEntry>(){

            @Override
            public int compare(LocalVariableTableEntry o1, LocalVariableTableEntry o2) {
                return o1.getIndex() - o2.getIndex();
            }
        });
    }

    public LocalVariableTableEntry[] getEntries() {
        return this.entries;
    }

    public class LocalVariableTableEntry {
        private int start_pc;
        private int length;
        private int name_index;
        private int descriptor_index;
        private int index;
        private String name;

        void resolve(BinaryData binaryData, ConstantInfo[] constantInfos) {
            binaryData.addIndex(2);
            binaryData.addIndex(2);
            this.name_index = binaryData.readShort();
            this.name = ((Utf8Info)constantInfos[this.name_index - 1]).getValue();
            binaryData.addIndex(2);
            this.index = binaryData.readShort();
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "LocalVariableTableEntry{index=" + this.index + ", name='" + this.name + '\'' + '}';
        }
    }
}

