/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil.bytecode.structure;

import com.jfireframework.baseutil.bytecode.ClassFile;
import com.jfireframework.baseutil.bytecode.ClassFileParser;
import com.jfireframework.baseutil.bytecode.annotation.AnnotationMetadata;
import com.jfireframework.baseutil.bytecode.annotation.ClassNotExistAnnotationMetadata;
import com.jfireframework.baseutil.bytecode.annotation.DefaultAnnotationMetadata;
import com.jfireframework.baseutil.bytecode.annotation.ValuePair;
import com.jfireframework.baseutil.bytecode.structure.Attribute.AnnotationDefaultAttriInfo;
import com.jfireframework.baseutil.bytecode.structure.Attribute.AttributeInfo;
import com.jfireframework.baseutil.bytecode.structure.ElementValueInfo;
import com.jfireframework.baseutil.bytecode.structure.MethodInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.ConstantInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.Utf8Info;
import com.jfireframework.baseutil.bytecode.util.BinaryData;
import com.jfireframework.baseutil.bytecode.util.BytecodeUtil;
import java.util.Arrays;
import java.util.HashMap;

public class AnnotationInfo {
    private String type;
    private element_value_pair[] pairs;

    public void resolve(BinaryData binaryData, ConstantInfo[] constantInfos) {
        int type_index = binaryData.readShort();
        this.type = ((Utf8Info)constantInfos[type_index - 1]).getValue();
        if (this.type.startsWith("L")) {
            this.type = this.type.substring(1, this.type.length() - 1);
        }
        int num_element_value_pairs = binaryData.readShort();
        this.pairs = new element_value_pair[num_element_value_pairs];
        for (int i = 0; i < num_element_value_pairs; ++i) {
            this.pairs[i] = new element_value_pair();
            this.pairs[i].resolve(binaryData, constantInfos);
        }
    }

    public String toString() {
        return "AnnotationInfo{type='" + this.type + '\'' + ", pairs=" + Arrays.toString(this.pairs) + '}';
    }

    public String getType() {
        return this.type;
    }

    public AnnotationMetadata getAnnotation(ClassLoader classLoader) {
        HashMap<String, ValuePair> elementValues = new HashMap<String, ValuePair>();
        byte[] bytes = BytecodeUtil.loadBytecode(classLoader, this.type);
        if (bytes == null) {
            return new ClassNotExistAnnotationMetadata(this.type);
        }
        ClassFile annotationClassFile = new ClassFileParser(new BinaryData(bytes)).parse();
        HashMap<String, MethodInfo> methodInfoMap = new HashMap<String, MethodInfo>();
        for (MethodInfo methodInfo : annotationClassFile.getMethodInfos()) {
            methodInfoMap.put(methodInfo.getName(), methodInfo);
        }
        block1: for (MethodInfo methodInfo : annotationClassFile.getMethodInfos()) {
            for (AttributeInfo attributeInfo : methodInfo.getAttributeInfos()) {
                if (!(attributeInfo instanceof AnnotationDefaultAttriInfo)) continue;
                elementValues.put(methodInfo.getName(), ((AnnotationDefaultAttriInfo)attributeInfo).getElementValueInfo().getValue(classLoader, methodInfo));
                continue block1;
            }
        }
        for (element_value_pair pair : this.pairs) {
            String name = pair.getElementName();
            ElementValueInfo value = pair.getValue();
            elementValues.put(name, value.getValue(classLoader, (MethodInfo)methodInfoMap.get(name)));
        }
        return new DefaultAnnotationMetadata(this.type, elementValues, classLoader);
    }

    class element_value_pair {
        private String elementName;
        private ElementValueInfo value;

        element_value_pair() {
        }

        void resolve(BinaryData binaryData, ConstantInfo[] constantInfos) {
            int element_name_index = binaryData.readShort();
            this.elementName = ((Utf8Info)constantInfos[element_name_index - 1]).getValue();
            this.value = new ElementValueInfo();
            this.value.resolve(binaryData, constantInfos);
        }

        String getElementName() {
            return this.elementName;
        }

        ElementValueInfo getValue() {
            return this.value;
        }

        public String toString() {
            return "element_value_pair{elementName='" + this.elementName + '\'' + ", value=" + this.value + '}';
        }
    }
}

