/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil.bytecode.annotation;

import com.jfireframework.baseutil.bytecode.annotation.AnnotationMetadata;
import com.jfireframework.baseutil.bytecode.annotation.ValuePair;
import com.jfireframework.baseutil.reflect.ReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractAnnotationMetadata
implements AnnotationMetadata {
    protected String resourceName;
    protected Map<String, ValuePair> attributes;
    protected List<AnnotationMetadata> presentAnnotations;
    protected Annotation annotation;
    protected ClassLoader loader;
    protected Class<?> annotationType;

    public AbstractAnnotationMetadata(String resourceName, Map<String, ValuePair> attributes, ClassLoader loader) {
        this.resourceName = resourceName;
        this.attributes = attributes;
        this.loader = loader;
    }

    @Override
    public boolean shouldIgnore() {
        return this.type().equals(DocumentedName) || this.type().equals(RetentionName) || this.type().equals(TargetName);
    }

    @Override
    public ValuePair getAttribyte(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Class<?> annotationType() {
        if (this.annotationType == null) {
            try {
                this.annotationType = this.loader.loadClass(this.resourceName.replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                ReflectUtil.throwException(e);
                this.annotationType = null;
            }
        }
        return this.annotationType;
    }

    @Override
    public boolean isAnnotation(String name) {
        return name != null && name.equals(this.resourceName);
    }

    @Override
    public String type() {
        return this.resourceName;
    }

    @Override
    public Annotation annotation() {
        if (this.annotation == null) {
            final HashMap<String, Object> values = new HashMap<String, Object>();
            for (Map.Entry<String, ValuePair> entry : this.attributes.entrySet()) {
                block6 : switch (entry.getValue().getElementValueType()) {
                    case BOOLEAN: {
                        values.put(entry.getKey(), entry.getValue().booleanValue());
                        break;
                    }
                    case DOUBLE: {
                        values.put(entry.getKey(), entry.getValue().getD());
                        break;
                    }
                    case SHORT: {
                        values.put(entry.getKey(), entry.getValue().getS());
                        break;
                    }
                    case FLOAT: {
                        values.put(entry.getKey(), Float.valueOf(entry.getValue().getF()));
                        break;
                    }
                    case LONG: {
                        values.put(entry.getKey(), entry.getValue().getL());
                        break;
                    }
                    case CHAR: {
                        values.put(entry.getKey(), Character.valueOf(entry.getValue().getC()));
                        break;
                    }
                    case BYTE: {
                        values.put(entry.getKey(), entry.getValue().getB());
                        break;
                    }
                    case INT: {
                        values.put(entry.getKey(), entry.getValue().getI());
                        break;
                    }
                    case ANNOTATION: {
                        values.put(entry.getKey(), entry.getValue().getAnnotation().annotation());
                        break;
                    }
                    case STRING: {
                        values.put(entry.getKey(), entry.getValue().getStringValue());
                        break;
                    }
                    case CLASS: {
                        try {
                            values.put(entry.getKey(), this.loader.loadClass(entry.getValue().getClassName()));
                        }
                        catch (ClassNotFoundException e) {
                            ReflectUtil.throwException(e);
                        }
                        break;
                    }
                    case ENUM: {
                        try {
                            Class<?> enumClass = this.loader.loadClass(entry.getValue().getEnumTypeName());
                            Object enumInstance = Enum.valueOf(enumClass, entry.getValue().getEnumValueName());
                            values.put(entry.getKey(), enumInstance);
                        }
                        catch (Exception e) {
                            ReflectUtil.throwException(e);
                        }
                        break;
                    }
                    case ARRAY: {
                        ValuePair valuePair = entry.getValue();
                        switch (valuePair.getComponentType()) {
                            case INT: {
                                Object[] array = new int[valuePair.getArray().length];
                                for (int i = 0; i < valuePair.getArray().length; ++i) {
                                    array[i] = valuePair.getArray()[i].getI();
                                }
                                values.put(entry.getKey(), array);
                                break block6;
                            }
                            case BYTE: {
                                Object[] array = new byte[valuePair.getArray().length];
                                for (int i = 0; i < valuePair.getArray().length; ++i) {
                                    array[i] = valuePair.getArray()[i].getB();
                                }
                                values.put(entry.getKey(), array);
                                break block6;
                            }
                            case LONG: {
                                Object[] array = new long[valuePair.getArray().length];
                                for (int i = 0; i < valuePair.getArray().length; ++i) {
                                    array[i] = (int)valuePair.getArray()[i].getL();
                                }
                                values.put(entry.getKey(), array);
                                break block6;
                            }
                            case FLOAT: {
                                Object[] array = new float[valuePair.getArray().length];
                                for (int i = 0; i < valuePair.getArray().length; ++i) {
                                    array[i] = (int)valuePair.getArray()[i].getF();
                                }
                                values.put(entry.getKey(), array);
                                break block6;
                            }
                            case SHORT: {
                                Object[] array = new short[valuePair.getArray().length];
                                for (int i = 0; i < valuePair.getArray().length; ++i) {
                                    array[i] = valuePair.getArray()[i].getS();
                                }
                                values.put(entry.getKey(), array);
                                break block6;
                            }
                            case DOUBLE: {
                                Object[] array = new double[valuePair.getArray().length];
                                for (int i = 0; i < valuePair.getArray().length; ++i) {
                                    array[i] = (int)valuePair.getArray()[i].getD();
                                }
                                values.put(entry.getKey(), array);
                                break block6;
                            }
                            case BOOLEAN: {
                                Object[] array = new boolean[valuePair.getArray().length];
                                for (int i = 0; i < valuePair.getArray().length; ++i) {
                                    array[i] = valuePair.getArray()[i].booleanValue() ? 1 : 0;
                                }
                                values.put(entry.getKey(), array);
                                break block6;
                            }
                            case CHAR: {
                                Object[] array = new char[valuePair.getArray().length];
                                for (int i = 0; i < valuePair.getArray().length; ++i) {
                                    array[i] = valuePair.getArray()[i].getC();
                                }
                                values.put(entry.getKey(), array);
                                break block6;
                            }
                            case STRING: {
                                Object[] array = new String[valuePair.getArray().length];
                                for (int i = 0; i < valuePair.getArray().length; ++i) {
                                    array[i] = (int)valuePair.getArray()[i].getStringValue();
                                }
                                values.put(entry.getKey(), array);
                                break block6;
                            }
                            case CLASS: {
                                Object[] array = new Class[valuePair.getArray().length];
                                for (int i = 0; i < valuePair.getArray().length; ++i) {
                                    try {
                                        array[i] = (int)this.loader.loadClass(valuePair.getArray()[i].getClassName());
                                        continue;
                                    }
                                    catch (Exception e) {
                                        ReflectUtil.throwException(e);
                                    }
                                }
                                values.put(entry.getKey(), array);
                                break block6;
                            }
                            case ENUM: {
                                int i;
                                Object array;
                                try {
                                    String enumTypeName = valuePair.getComponentEnumTypeName();
                                    Class<?> aClass = this.loader.loadClass(enumTypeName);
                                    array = Array.newInstance(aClass, valuePair.getArray().length);
                                    for (i = 0; i < valuePair.getArray().length; ++i) {
                                        Object enumInstance = Enum.valueOf(aClass, valuePair.getArray()[i].getEnumValueName());
                                        Array.set(array, i, enumInstance);
                                    }
                                    values.put(entry.getKey(), array);
                                    break block6;
                                }
                                catch (Exception e) {
                                    ReflectUtil.throwException(e);
                                }
                            }
                            case ANNOTATION: {
                                int i;
                                Object array;
                                String annotationType = entry.getValue().getComponentAnnotationType();
                                try {
                                    Class<?> aClass = this.loader.loadClass(annotationType);
                                    array = Array.newInstance(aClass, valuePair.getArray().length);
                                    for (i = 0; i < valuePair.getArray().length; ++i) {
                                        Array.set(array, i, entry.getValue().getArray()[i].getAnnotation().annotation());
                                    }
                                    values.put(entry.getKey(), array);
                                    break block6;
                                }
                                catch (ClassNotFoundException e) {
                                    ReflectUtil.throwException(e);
                                }
                            }
                        }
                    }
                }
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                this.annotation = (Annotation)Proxy.newProxyInstance(classLoader, new Class[]{classLoader.loadClass(this.resourceName.replace('/', '.'))}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        return values.get(method.getName());
                    }
                });
            }
            catch (ClassNotFoundException e) {
                ReflectUtil.throwException(e);
            }
        }
        return this.annotation;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Map<String, ValuePair> getAttributes() {
        return this.attributes;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }
}

