/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil.bytecode;

import com.jfireframework.baseutil.bytecode.ClassFile;
import com.jfireframework.baseutil.bytecode.structure.Attribute.AttributeInfo;
import com.jfireframework.baseutil.bytecode.structure.FieldInfo;
import com.jfireframework.baseutil.bytecode.structure.MethodInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.ClassInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.ConstantInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.DoubleInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.FieldRefInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.FloatInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.IntegerInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.InterfaceMethodRefInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.InvokeDynamicInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.LongInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.MethodHandleInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.MethodRefInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.MethodTypeInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.NameAndTypeInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.StringInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.Utf8Info;
import com.jfireframework.baseutil.bytecode.util.BinaryData;
import com.jfireframework.baseutil.bytecode.util.ConstantType;
import java.util.Arrays;

public class ClassFileParser {
    private int magic;
    private int minor_version;
    private int major_version;
    private int constant_pool_count;
    private ConstantInfo[] constant_pool;
    private int access_flags;
    private String this_class_name;
    private String super_class_name;
    private String[] interfaces;
    private FieldInfo[] fieldInfos;
    private MethodInfo[] methodInfos;
    private AttributeInfo[] attributeInfos;
    private BinaryData binaryData;

    public ClassFileParser(BinaryData binaryData) {
        this.binaryData = binaryData;
        this.readMagic();
        this.readminorVersion();
        this.readmajorVersion();
        this.readConstantPoolCount();
        this.readConstantInfo();
        this.readAccessFlags();
        this.readThisClass();
        this.readSuperClass();
        this.readInterfaces();
        this.readFieldInfos();
        this.readMethodInfos();
        this.readAttributeInfos();
    }

    public ClassFileParser(byte[] bytecode) {
        this(new BinaryData(bytecode));
    }

    public ClassFile parse() {
        ClassFile classFile = new ClassFile();
        classFile.setAccess_flags(this.access_flags);
        classFile.setMinor_version(this.minor_version);
        classFile.setMajor_version(this.major_version);
        classFile.setInterfaces(this.interfaces);
        classFile.setSuper_class_name(this.super_class_name);
        classFile.setThis_class_name(this.this_class_name);
        classFile.setAttributeInfos(this.attributeInfos);
        classFile.setFieldInfos(this.fieldInfos);
        classFile.setMethodInfos(this.methodInfos);
        return classFile;
    }

    private void readAttributeInfos() {
        int attribute_count = this.binaryData.readShort();
        this.attributeInfos = new AttributeInfo[attribute_count];
        for (int i = 0; i < this.attributeInfos.length; ++i) {
            this.attributeInfos[i] = AttributeInfo.parse(this.binaryData, this.constant_pool);
        }
    }

    private void readMethodInfos() {
        int method_count = this.binaryData.readShort();
        this.methodInfos = new MethodInfo[method_count];
        for (int i = 0; i < method_count; ++i) {
            this.methodInfos[i] = new MethodInfo();
            this.methodInfos[i].resolve(this.binaryData, this.constant_pool);
        }
    }

    private void readFieldInfos() {
        int fields_cout = this.binaryData.readShort();
        this.fieldInfos = new FieldInfo[fields_cout];
        for (int i = 0; i < fields_cout; ++i) {
            this.fieldInfos[i] = new FieldInfo();
            this.fieldInfos[i].resolve(this.binaryData, this.constant_pool);
        }
    }

    private void readInterfaces() {
        int interfaces_cout = this.binaryData.readShort();
        this.interfaces = new String[interfaces_cout];
        for (int i = 0; i < interfaces_cout; ++i) {
            int interfaceIndex = this.binaryData.readShort();
            this.interfaces[i] = ((ClassInfo)this.constant_pool[interfaceIndex - 1]).getName();
        }
    }

    private void readSuperClass() {
        int super_class = this.binaryData.readShort();
        if (super_class == 0) {
            if (!this.this_class_name.equals("java/lang/Object")) {
                throw new RuntimeException("\u5b57\u8282\u7801\u89e3\u6790\u9519\u8bef\uff0c\u53ea\u6709Object\u7c7b\u578b\u7684\u7236\u7c7b\u624d\u5141\u8bb8\u4e3a\u7a7a");
            }
            this.super_class_name = null;
        } else {
            this.super_class_name = ((ClassInfo)this.constant_pool[super_class - 1]).getName();
        }
    }

    private void readThisClass() {
        int this_class = this.binaryData.readShort();
        this.this_class_name = ((ClassInfo)this.constant_pool[this_class - 1]).getName();
    }

    private void readAccessFlags() {
        this.access_flags = this.binaryData.readShort();
    }

    private void readConstantInfo() {
        this.constant_pool = new ConstantInfo[this.constant_pool_count - 1];
        for (int i = 0; i < this.constant_pool.length; ++i) {
            ConstantInfo constantInfo;
            ConstantType constantType = this.readTag();
            switch (constantType) {
                case Utf8: {
                    constantInfo = new Utf8Info();
                    break;
                }
                case Integer: {
                    constantInfo = new IntegerInfo();
                    break;
                }
                case Float: {
                    constantInfo = new FloatInfo();
                    break;
                }
                case Long: {
                    constantInfo = new LongInfo();
                    break;
                }
                case Double: {
                    constantInfo = new DoubleInfo();
                    break;
                }
                case Class: {
                    constantInfo = new ClassInfo();
                    break;
                }
                case String: {
                    constantInfo = new StringInfo();
                    break;
                }
                case FieldRef: {
                    constantInfo = new FieldRefInfo();
                    break;
                }
                case MethodRef: {
                    constantInfo = new MethodRefInfo();
                    break;
                }
                case InterfaceMethodref: {
                    constantInfo = new InterfaceMethodRefInfo();
                    break;
                }
                case NameAndType: {
                    constantInfo = new NameAndTypeInfo();
                    break;
                }
                case MethodHandle: {
                    constantInfo = new MethodHandleInfo();
                    break;
                }
                case MethodType: {
                    constantInfo = new MethodTypeInfo();
                    break;
                }
                case InvokeDynamic: {
                    constantInfo = new InvokeDynamicInfo();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            constantInfo.resolve(this.binaryData);
            this.constant_pool[i] = constantInfo;
            if (!(constantInfo instanceof LongInfo) && !(constantInfo instanceof DoubleInfo)) continue;
            ++i;
        }
        for (ConstantInfo constantInfo : this.constant_pool) {
            if (constantInfo == null) continue;
            constantInfo.resolve(this.constant_pool);
        }
    }

    private ConstantType readTag() {
        byte tag = this.binaryData.readByte();
        return ConstantType.byteValue(tag);
    }

    private void readConstantPoolCount() {
        this.constant_pool_count = this.binaryData.readShort();
    }

    private void readmajorVersion() {
        this.major_version = this.binaryData.readShort();
    }

    private void readminorVersion() {
        this.minor_version = this.binaryData.readShort();
    }

    private void readMagic() {
        if ((this.binaryData.readByte() & 0xFF) != 202 || (this.binaryData.readByte() & 0xFF) != 254 || (this.binaryData.readByte() & 0xFF) != 186 || (this.binaryData.readByte() & 0xFF) != 190) {
            throw new IllegalArgumentException();
        }
        this.magic = -889275714;
    }

    public String toString() {
        return "ClassFileParser{minor_version=" + this.minor_version + ", major_version=" + this.major_version + ", constant_pool_count=" + this.constant_pool_count + ", constant_pool=" + Arrays.toString(this.constant_pool) + ", access_flags=" + this.access_flags + ", this_class_name='" + this.this_class_name + '\'' + ", super_class_name='" + this.super_class_name + '\'' + ", interfaces=" + Arrays.toString(this.interfaces) + ", fieldInfos=" + Arrays.toString(this.fieldInfos) + ", methodInfos=" + Arrays.toString(this.methodInfos) + ", attributeInfos=" + Arrays.toString(this.attributeInfos) + '}';
    }
}

