/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server;

import com.jfinal.kit.FileKit;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import com.jfinal.kit.StrKit;
import com.jfinal.server.IServer;
import java.io.File;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.webapp.WebAppContext;

public class JettyServerForIDEA
implements IServer {
    private String webAppDir;
    private int port;
    private String context;
    private boolean running = false;
    private Server server;
    private WebAppContext webApp;

    public JettyServerForIDEA(String webAppDir, int port, String context) {
        if (webAppDir == null) {
            throw new IllegalStateException("Invalid webAppDir of web server: " + webAppDir);
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port of web server: " + port);
        }
        if (StrKit.isBlank(context)) {
            throw new IllegalStateException("Invalid context of web server: " + context);
        }
        this.webAppDir = webAppDir;
        this.port = port;
        this.context = context;
    }

    @Override
    public void start() {
        if (!this.running) {
            try {
                this.running = true;
                this.doStart();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                LogKit.error(e.getMessage(), e);
            }
        }
    }

    @Override
    public void stop() {
        if (this.running) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                LogKit.error(e.getMessage(), e);
            }
            this.running = false;
        }
    }

    private void doStart() {
        if (!JettyServerForIDEA.available(this.port)) {
            throw new IllegalStateException("port: " + this.port + " already in use!");
        }
        this.deleteSessionData();
        System.out.println("Starting JFinal 3.4");
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        this.server.addConnector((Connector)connector);
        this.webApp = new WebAppContext();
        this.webApp.setThrowUnavailableOnStartupException(true);
        this.webApp.setContextPath(this.context);
        this.webApp.setResourceBase(this.webAppDir);
        this.webApp.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        this.webApp.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
        this.persistSession(this.webApp);
        this.server.setHandler((Handler)this.webApp);
        try {
            System.out.println("Starting web server on port: " + this.port);
            this.server.start();
            System.out.println("Starting Complete. Welcome To The JFinal World :)");
            this.server.join();
        }
        catch (Exception e) {
            LogKit.error(e.getMessage(), e);
            System.exit(100);
        }
    }

    private void deleteSessionData() {
        try {
            FileKit.delete(new File(this.getStoreDir()));
        }
        catch (Exception e) {
            LogKit.logNothing(e);
        }
    }

    private String getStoreDir() {
        String storeDir = PathKit.getWebRootPath() + "/../../session_data" + this.context;
        if ("\\".equals(File.separator)) {
            storeDir = storeDir.replaceAll("/", "\\\\");
        }
        return storeDir;
    }

    private void persistSession(WebAppContext webApp) {
        String storeDir = this.getStoreDir();
        SessionManager sm = webApp.getSessionHandler().getSessionManager();
        if (sm instanceof HashSessionManager) {
            ((HashSessionManager)sm).setStoreDirectory(new File(storeDir));
            return;
        }
        HashSessionManager hsm = new HashSessionManager();
        hsm.setStoreDirectory(new File(storeDir));
        SessionHandler sh = new SessionHandler();
        sh.setSessionManager((SessionManager)hsm);
        webApp.setSessionHandler(sh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean available(int port) {
        if (port <= 0) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LogKit.logNothing(e);
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    LogKit.logNothing(e);
                }
            }
        }
        return false;
    }
}

