/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.kit.LogKit;
import com.jfinal.kit.StrKit;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import com.jfinal.render.RenderManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;

public class FileRender
extends Render {
    protected static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    protected static String baseDownloadPath;
    protected static ServletContext servletContext;
    protected File file;
    protected String downloadFileName = null;

    public FileRender(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file can not be null.");
        }
        this.file = file;
    }

    public FileRender(File file, String downloadFileName) {
        this(file);
        if (StrKit.isBlank(downloadFileName)) {
            throw new IllegalArgumentException("downloadFileName can not be blank.");
        }
        this.downloadFileName = downloadFileName;
    }

    public FileRender(String fileName) {
        if (StrKit.isBlank(fileName)) {
            throw new IllegalArgumentException("fileName can not be blank.");
        }
        String fullFileName = (fileName = fileName.trim()).startsWith("/") || fileName.startsWith("\\") ? (baseDownloadPath.equals("/") ? fileName : baseDownloadPath + fileName) : baseDownloadPath + File.separator + fileName;
        this.file = new File(fullFileName);
    }

    public FileRender(String fileName, String downloadFileName) {
        this(fileName);
        if (StrKit.isBlank(downloadFileName)) {
            throw new IllegalArgumentException("downloadFileName can not be blank.");
        }
        this.downloadFileName = downloadFileName;
    }

    static void init(String baseDownloadPath, ServletContext servletContext) {
        FileRender.baseDownloadPath = baseDownloadPath;
        FileRender.servletContext = servletContext;
    }

    @Override
    public void render() {
        if (this.file == null || !this.file.isFile()) {
            RenderManager.me().getRenderFactory().getErrorRender(404).setContext(this.request, this.response).render();
            return;
        }
        this.response.setHeader("Accept-Ranges", "bytes");
        String fn = this.downloadFileName == null ? this.file.getName() : this.downloadFileName;
        this.response.setHeader("Content-disposition", "attachment; " + this.encodeFileName(this.request, fn));
        String contentType = servletContext.getMimeType(this.file.getName());
        this.response.setContentType(contentType != null ? contentType : DEFAULT_CONTENT_TYPE);
        if (StrKit.isBlank(this.request.getHeader("Range"))) {
            this.normalRender();
        } else {
            this.rangeRender();
        }
    }

    protected String encodeFileName(String fileName) {
        try {
            return new String(fileName.getBytes(FileRender.getEncoding()), "ISO8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return fileName;
        }
    }

    public String encodeFileName(HttpServletRequest request, String fileName) {
        String userAgent = request.getHeader("User-Agent");
        try {
            String encodedFileName = URLEncoder.encode(fileName, "UTF8");
            if (userAgent == null) {
                return "filename=\"" + encodedFileName + "\"";
            }
            if ((userAgent = userAgent.toLowerCase()).indexOf("msie") != -1) {
                return "filename=\"" + encodedFileName + "\"";
            }
            if (userAgent.indexOf("opera") != -1) {
                return "filename*=UTF-8''" + encodedFileName;
            }
            if (userAgent.indexOf("safari") != -1 || userAgent.indexOf("applewebkit") != -1 || userAgent.indexOf("chrome") != -1) {
                return "filename=\"" + new String(fileName.getBytes("UTF-8"), "ISO8859-1") + "\"";
            }
            if (userAgent.indexOf("mozilla") != -1) {
                return "filename*=UTF-8''" + encodedFileName;
            }
            return "filename=\"" + encodedFileName + "\"";
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected void normalRender() {
        block16: {
            this.response.setHeader("Content-Length", String.valueOf(this.file.length()));
            InputStream inputStream = null;
            ServletOutputStream outputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(this.file));
                outputStream = this.response.getOutputStream();
                byte[] buffer = new byte[1024];
                int len = -1;
                while ((len = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, len);
                }
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                String name = e.getClass().getSimpleName();
                if (name.equals("ClientAbortException")) break block16;
                if (name.equals("EofException")) {
                    break block16;
                }
                throw new RenderException(e);
            }
            catch (Exception e) {
                throw new RenderException(e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LogKit.error(e.getMessage(), e);
                    }
                }
            }
        }
    }

    protected void rangeRender() {
        block19: {
            Long[] range = new Long[]{null, null};
            this.processRange(range);
            String contentLength = String.valueOf(range[1] - range[0] + 1L);
            this.response.setHeader("Content-Length", contentLength);
            this.response.setStatus(206);
            StringBuilder contentRange = new StringBuilder("bytes ").append(String.valueOf(range[0])).append("-").append(String.valueOf(range[1])).append("/").append(String.valueOf(this.file.length()));
            this.response.setHeader("Content-Range", contentRange.toString());
            InputStream inputStream = null;
            ServletOutputStream outputStream = null;
            try {
                int len;
                long start = range[0];
                long end = range[1];
                inputStream = new BufferedInputStream(new FileInputStream(this.file));
                if (inputStream.skip(start) != start) {
                    throw new RuntimeException("File skip error");
                }
                outputStream = this.response.getOutputStream();
                byte[] buffer = new byte[1024];
                long position = start;
                while (position <= end && (len = inputStream.read(buffer)) != -1) {
                    if (position + (long)len <= end) {
                        outputStream.write(buffer, 0, len);
                        position += (long)len;
                        continue;
                    }
                    for (int i = 0; i < len && position <= end; ++position, ++i) {
                        outputStream.write(buffer[i]);
                    }
                }
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                String name = e.getClass().getSimpleName();
                if (name.equals("ClientAbortException")) break block19;
                if (name.equals("EofException")) {
                    break block19;
                }
                throw new RenderException(e);
            }
            catch (Exception e) {
                throw new RenderException(e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LogKit.error(e.getMessage(), e);
                    }
                }
            }
        }
    }

    protected void processRange(Long[] range) {
        String[] arr;
        String rangeStr = this.request.getHeader("Range");
        int index = rangeStr.indexOf(44);
        if (index != -1) {
            rangeStr = rangeStr.substring(0, index);
        }
        if ((arr = (rangeStr = rangeStr.replace("bytes=", "")).split("-", 2)).length < 2) {
            throw new RuntimeException("Range error");
        }
        long fileLength = this.file.length();
        for (int i = 0; i < range.length; ++i) {
            if (!StrKit.notBlank(arr[i])) continue;
            range[i] = Long.parseLong(arr[i].trim());
            if (range[i] < fileLength) continue;
            range[i] = fileLength - 1L;
        }
        if (range[0] != null && range[1] == null) {
            range[1] = fileLength - 1L;
        } else if (range[0] == null && range[1] != null) {
            range[0] = fileLength - range[1];
            range[1] = fileLength - 1L;
        }
        if (range[0] == null || range[1] == null || range[0] > range[1]) {
            throw new RuntimeException("Range error");
        }
    }
}

