/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.generator;

import com.jfinal.kit.JavaKeyword;
import com.jfinal.kit.Kv;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import com.jfinal.template.Engine;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseModelGenerator {
    protected Engine engine;
    protected String template = "/com/jfinal/plugin/activerecord/generator/base_model_template.jf";
    protected String baseModelPackageName;
    protected String baseModelOutputDir;
    protected boolean generateChainSetter = false;
    protected JavaKeyword javaKeyword = JavaKeyword.me;
    protected Map<String, String> getterTypeMap = new HashMap<String, String>(){
        {
            this.put("java.lang.String", "getStr");
            this.put("java.lang.Integer", "getInt");
            this.put("java.lang.Long", "getLong");
            this.put("java.lang.Double", "getDouble");
            this.put("java.lang.Float", "getFloat");
            this.put("java.lang.Short", "getShort");
            this.put("java.lang.Byte", "getByte");
        }
    };

    public BaseModelGenerator(String baseModelPackageName, String baseModelOutputDir) {
        if (StrKit.isBlank(baseModelPackageName)) {
            throw new IllegalArgumentException("baseModelPackageName can not be blank.");
        }
        if (baseModelPackageName.contains("/") || baseModelPackageName.contains("\\")) {
            throw new IllegalArgumentException("baseModelPackageName error : " + baseModelPackageName);
        }
        if (StrKit.isBlank(baseModelOutputDir)) {
            throw new IllegalArgumentException("baseModelOutputDir can not be blank.");
        }
        this.baseModelPackageName = baseModelPackageName;
        this.baseModelOutputDir = baseModelOutputDir;
        this.initEngine();
    }

    protected void initEngine() {
        this.engine = new Engine();
        this.engine.setToClassPathSourceFactory();
        this.engine.addSharedMethod(new StrKit());
        this.engine.addSharedObject("getterTypeMap", this.getterTypeMap);
        this.engine.addSharedObject("javaKeyword", this.javaKeyword);
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setGenerateChainSetter(boolean generateChainSetter) {
        this.generateChainSetter = generateChainSetter;
    }

    public void generate(List<TableMeta> tableMetas) {
        System.out.println("Generate base model ...");
        System.out.println("Base Model Output Dir: " + this.baseModelOutputDir);
        for (TableMeta tableMeta : tableMetas) {
            this.genBaseModelContent(tableMeta);
        }
        this.writeToFile(tableMetas);
    }

    protected void genBaseModelContent(TableMeta tableMeta) {
        Kv data = Kv.by("baseModelPackageName", this.baseModelPackageName);
        data.set("generateChainSetter", this.generateChainSetter);
        data.set("tableMeta", tableMeta);
        tableMeta.baseModelContent = this.engine.getTemplate(this.template).renderToString(data);
    }

    protected void writeToFile(List<TableMeta> tableMetas) {
        try {
            for (TableMeta tableMeta : tableMetas) {
                this.writeToFile(tableMeta);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToFile(TableMeta tableMeta) throws IOException {
        File dir = new File(this.baseModelOutputDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String target = this.baseModelOutputDir + File.separator + tableMeta.baseModelName + ".java";
        FileWriter fw = new FileWriter(target);
        try {
            fw.write(tableMeta.baseModelContent);
        }
        finally {
            fw.close();
        }
    }
}

