/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.json;

import com.jfinal.json.IJsonFactory;
import com.jfinal.json.JFinalJsonFactory;
import com.jfinal.kit.StrKit;

public abstract class Json {
    private static IJsonFactory defaultJsonFactory = new JFinalJsonFactory();
    private static String defaultDatePattern = "yyyy-MM-dd HH:mm:ss";
    protected String datePattern = null;

    static void setDefaultJsonFactory(IJsonFactory defaultJsonFactory) {
        if (defaultJsonFactory == null) {
            throw new IllegalArgumentException("defaultJsonFactory can not be null.");
        }
        Json.defaultJsonFactory = defaultJsonFactory;
    }

    static void setDefaultDatePattern(String defaultDatePattern) {
        if (StrKit.isBlank(defaultDatePattern)) {
            throw new IllegalArgumentException("defaultDatePattern can not be blank.");
        }
        Json.defaultDatePattern = defaultDatePattern;
    }

    public Json setDatePattern(String datePattern) {
        if (StrKit.isBlank(datePattern)) {
            throw new IllegalArgumentException("datePattern can not be blank.");
        }
        this.datePattern = datePattern;
        return this;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public String getDefaultDatePattern() {
        return defaultDatePattern;
    }

    public static Json getJson() {
        return defaultJsonFactory.getJson();
    }

    public abstract String toJson(Object var1);

    public abstract <T> T parse(String var1, Class<T> var2);
}

